/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat.variable;

import ch.javasoft.jsmat.common.MatClass;
import ch.javasoft.jsmat.common.MatType;
import ch.javasoft.jsmat.primitive.MatInt8;
import ch.javasoft.jsmat.variable.MatAllocated;
import ch.javasoft.jsmat.variable.MatVariable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatStructure
extends MatAllocated {
    private final Map<String, ? extends MatAllocated>[] mFields;

    public MatStructure(Map<String, ? extends MatAllocated> fields) {
        this(new Map[]{fields}, new int[]{1, 1});
    }

    public MatStructure(Map<String, ? extends MatAllocated>[] fields, int[] dims) {
        super(MatClass.STRUCT, dims);
        this.mFields = fields;
        this.checkMapSizesEqual();
        this.checkValueLength(fields.length);
    }

    private void checkMapSizesEqual() {
        if (this.mFields.length == 0) {
            return;
        }
        int unit = this.mFields[0].size();
        int i = 1;
        while (i < this.mFields.length) {
            if (unit != this.mFields[i].size()) {
                throw new IllegalArgumentException("not all field maps have same size");
            }
            ++i;
        }
    }

    @Override
    public int getRawDataSize() {
        return MatStructure.getRawDataSize(this.mFields);
    }

    static int getRawDataSize(Map<String, ? extends MatVariable>[] fields) {
        int size = 0;
        size += 4;
        size += 4;
        size += new MatInt8(MatStructure.getFieldNamesAsByteArray(fields)).getSize();
        int i = 0;
        while (i < fields.length) {
            for (String name : fields[i].keySet()) {
                MatVariable mx = fields[i].get(name);
                size += mx.getSize(name);
            }
            ++i;
        }
        return size;
    }

    @Override
    public void writeRawData(DataOutput out) throws IOException {
        MatStructure.writeStructStart(out, this.mFields);
        int i = 0;
        while (i < this.mFields.length) {
            for (String name : this.mFields[i].keySet()) {
                MatAllocated mx = this.mFields[i].get(name);
                mx.write(name, out);
            }
            ++i;
        }
    }

    static void writeStructStart(DataOutput out, Map<String, ? extends MatVariable>[] fields) throws IOException {
        int itag = 0x40000 | MatType.INT32.type & 0xFFFF;
        out.writeInt(itag);
        out.writeInt(MatStructure.getMaxFieldNameLength(fields));
        new MatInt8(MatStructure.getFieldNamesAsByteArray(fields)).write(out);
    }

    private static byte[] getFieldNamesAsByteArray(Map<String, ? extends MatVariable>[] fields) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        char[] buffer = new char[MatStructure.getMaxFieldNameLength(fields)];
        try {
            int i = 0;
            while (i < fields.length) {
                for (String name : fields[i].keySet()) {
                    Arrays.fill(buffer, '\u0000');
                    System.arraycopy(name.toCharArray(), 0, buffer, 0, name.length());
                    dos.writeBytes(new String(buffer));
                }
                ++i;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return baos.toByteArray();
    }

    private static int getMaxFieldNameLength(Map<String, ? extends MatVariable>[] fields) {
        int len = Integer.MIN_VALUE;
        int i = 0;
        while (i < fields.length) {
            for (String name : fields[i].keySet()) {
                len = Math.max(len, name.length());
            }
            ++i;
        }
        return len + 1;
    }
}

