/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jsmat.variable;

import ch.javasoft.jsmat.common.MatClass;
import ch.javasoft.jsmat.variable.MatAllocated;
import ch.javasoft.jsmat.variable.MatCharMatrix;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatCell
extends MatAllocated {
    private final Collection<? extends MatAllocated> mElements;

    public MatCell(String[] elements) {
        this(elements, new int[]{1, elements.length});
    }

    public MatCell(String[] elements, int[] dims) {
        this(MatCell.createMatrixCollection(elements), dims);
    }

    public MatCell(Collection<? extends MatAllocated> elements) {
        this(elements, new int[]{1, elements.size()});
    }

    public MatCell(Collection<? extends MatAllocated> elements, int[] dims) {
        super(MatClass.CELL, dims);
        this.mElements = elements;
        this.checkValueLength(elements.size());
    }

    private static Collection<? extends MatAllocated> createMatrixCollection(String[] elements) {
        ArrayList<MatCharMatrix> list = new ArrayList<MatCharMatrix>(elements.length);
        int i = 0;
        while (i < elements.length) {
            list.add(new MatCharMatrix(elements[i]));
            ++i;
        }
        return list;
    }

    @Override
    protected int getRawDataSize() {
        int size = 0;
        for (MatAllocated matAllocated : this.mElements) {
            size += matAllocated.getSize("@");
        }
        return size;
    }

    @Override
    protected void writeRawData(DataOutput out) throws IOException {
        for (MatAllocated matAllocated : this.mElements) {
            matAllocated.write("@", out);
        }
    }
}

