/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.job;

import ch.javasoft.job.Executable;
import ch.javasoft.job.Job;
import ch.javasoft.job.JobMonitor;
import ch.javasoft.job.JobResult;
import ch.javasoft.job.JobTerminationHandler;
import ch.javasoft.job.NewThreadJobProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiJobExecutable<R>
implements Executable<Queue<R>> {
    private final Job<? extends R>[] jobs;

    private MultiJobExecutable(Job<? extends R> ... jobs) {
        this.jobs = jobs;
    }

    public MultiJobExecutable(Job<? extends R> jobA, Job<? extends R> jobB) {
        this(new Job[]{jobA, jobB});
    }

    public MultiJobExecutable(Job<? extends R> jobA, Job<? extends R> jobB, Job<? extends R> jobC) {
        this(new Job[]{jobA, jobB, jobC});
    }

    public MultiJobExecutable(Job<? extends R> jobA, Job<? extends R> jobB, Job<? extends R> jobC, Job<? extends R> jobD) {
        this(new Job[]{jobA, jobB, jobC, jobD});
    }

    public MultiJobExecutable(Iterable<Job<? extends R>> jobs) {
        this(MultiJobExecutable.toArray(jobs));
    }

    private static <R> Job<? extends R>[] toArray(Iterable<Job<? extends R>> jobs) {
        ArrayList<Job<R>> cjobs;
        if (jobs instanceof Collection) {
            cjobs = (ArrayList<Job<R>>)jobs;
        } else {
            cjobs = new ArrayList<Job<R>>();
            for (Job<R> job : jobs) {
                cjobs.add(job);
            }
        }
        return cjobs.toArray(new Job[cjobs.size()]);
    }

    @Override
    public JobMonitor<Queue<R>> exec() {
        final ConcurrentHashMap<Job<? extends R>, JobMonitor<? extends R>> monitors = new ConcurrentHashMap<Job<? extends R>, JobMonitor<? extends R>>();
        final ConcurrentLinkedQueue results = new ConcurrentLinkedQueue();
        final AtomicReference exception = new AtomicReference();
        NewThreadJobProcessor<? extends R> proc = new NewThreadJobProcessor<R>();
        final CountDownLatch counter = new CountDownLatch(this.jobs.length);
        proc.addJobTerminatedHandler(new JobTerminationHandler<R>(){

            @Override
            public void terminated(Job job, R result) {
                results.add(result);
                monitors.remove(job);
                counter.countDown();
            }

            @Override
            public void terminatedByException(Job job, Throwable t) {
                if (exception.compareAndSet(null, t)) {
                    while (counter.getCount() > 0L) {
                        counter.countDown();
                    }
                    for (JobMonitor mon : monitors.values()) {
                        mon.interrupt();
                    }
                } else {
                    counter.countDown();
                }
            }
        });
        int i = 0;
        while (i < this.jobs.length) {
            monitors.put(this.jobs[i], proc.exec(this.jobs[i]));
            ++i;
        }
        return new JobMonitor<Queue<R>>(){
            private JobResult<Queue<R>> result;

            @Override
            public JobResult<Queue<R>> getJobResult() {
                if (this.isRunning()) {
                    return null;
                }
                if (this.result == null) {
                    this.result = new JobResult<Queue<R>>(){

                        @Override
                        public Throwable getException() {
                            return (Throwable)exception.get();
                        }

                        @Override
                        public Queue<R> getResult() {
                            return this.isException() ? null : results;
                        }

                        @Override
                        public boolean isException() {
                            return exception.get() != null;
                        }
                    };
                }
                return this.result;
            }

            @Override
            public void interrupt() {
                if (exception.compareAndSet(null, new InterruptedException())) {
                    while (counter.getCount() > 0L) {
                        counter.countDown();
                    }
                    for (JobMonitor mon : monitors.values()) {
                        mon.interrupt();
                    }
                }
            }

            @Override
            public boolean isRunning() {
                return counter.getCount() > 0L;
            }

            @Override
            public JobResult<Queue<R>> waitForResult() throws InterruptedException {
                counter.await();
                return this.getJobResult();
            }
        };
    }

    @Override
    public JobMonitor<Queue<R>> exec(JobTerminationHandler<Queue<R>> terminationHandler) {
        NewThreadJobProcessor<Queue<R>> proc = new NewThreadJobProcessor<Queue<R>>();
        proc.addJobTerminatedHandler(terminationHandler);
        return proc.exec(new Job<Queue<R>>(){

            @Override
            public Queue<R> run() throws Throwable {
                return MultiJobExecutable.this.execAndWaitThrowException();
            }
        });
    }

    @Override
    public JobResult<Queue<R>> execAndWait() throws InterruptedException {
        return this.exec().waitForResult();
    }

    @Override
    public Queue<R> execAndWaitThrowException() throws InterruptedException, Throwable {
        JobResult<Queue<R>> result = this.execAndWait();
        if (result.isException()) {
            throw result.getException();
        }
        return result.getResult();
    }
}

