/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.jbase;

import ch.javasoft.jbase.RandomAccessPersister;
import ch.javasoft.jbase.util.UnsupportedOperationException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.ReadWriteLock;

public class RandomAccessFilePersistor
implements RandomAccessPersister {
    private final File file;
    private final RandomAccessFile raf;

    public RandomAccessFilePersistor(File folder, String fileName) throws FileNotFoundException {
        this(new File(folder, fileName));
    }

    public RandomAccessFilePersistor(File file) throws FileNotFoundException {
        this(file, new RandomAccessFile(file, "rw"));
    }

    protected RandomAccessFilePersistor(File file, RandomAccessFile raf) throws FileNotFoundException {
        this.file = file;
        this.raf = raf;
    }

    public long getPosition() throws IOException {
        return this.raf.getFilePointer();
    }

    public void setPosition(long bytePos) throws IOException {
        this.raf.seek(bytePos);
    }

    public void setLength(long byteLength) throws IOException {
        this.raf.setLength(byteLength);
    }

    public void flush() throws IOException {
        this.raf.getChannel().force(true);
    }

    public void close(boolean erase) throws IOException {
        this.raf.close();
        if (erase) {
            this.file.delete();
        }
    }

    public DataInput getInput() throws IOException {
        return this.raf;
    }

    public DataOutput getOutput() throws IOException {
        return this.raf;
    }

    public RandomAccessFilePersistor createReadCopy(ReadWriteLock lock) throws IOException {
        RandomAccessFilePersistor copy = new RandomAccessFilePersistor(this.file, new RandomAccessFile(this.file, "r")){

            public DataOutput getOutput() throws IOException {
                throw new UnsupportedOperationException("read only copy, data output not supported");
            }

            public void setLength(long arg0) throws IOException {
                throw new UnsupportedOperationException("read only copy, setting length not supported");
            }

            public void flush() throws IOException {
                throw new UnsupportedOperationException("read only copy, flushing not supported");
            }
        };
        copy.setPosition(this.getPosition());
        return copy;
    }
}

