/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.io;

import java.io.IOException;
import java.io.OutputStream;

public class LengthTrackingOutputStream
extends OutputStream {
    private final OutputStream mOut;
    private int mLength;

    public LengthTrackingOutputStream(OutputStream out) {
        this.mOut = out;
    }

    public void resetLength() {
        this.mLength = 0;
    }

    public int getLength() {
        return this.mLength;
    }

    public void write(int b) throws IOException {
        this.mOut.write(b);
        ++this.mLength;
    }

    public void write(byte[] b) throws IOException {
        this.mOut.write(b);
        this.mLength += b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.mOut.write(b, off, len);
        this.mLength += len;
    }
}

