/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.factory;

import ch.javasoft.factory.ConfigException;
import ch.javasoft.factory.Factory;
import ch.javasoft.factory.FactoryNotFoundException;
import ch.javasoft.factory.IllegalFactoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryUtil {
    public static <T, C, F extends Factory<T, C>> T create(Class<T> clazz, String factoryClassName, C config) throws FactoryNotFoundException, IllegalFactoryException, ConfigException {
        Object val;
        Class<? extends Factory> factoryClass = FactoryUtil.loadFactoryClass(factoryClassName);
        Factory factory = FactoryUtil.createFactory(clazz, factoryClass);
        try {
            val = factory.create(config);
        }
        catch (ClassCastException e) {
            throw new IllegalFactoryException("illegal config type for factory " + factory + ": " + config);
        }
        if (val == null || clazz.isInstance(val)) {
            return clazz.cast(val);
        }
        throw new IllegalFactoryException("factory " + factoryClassName + " created not an instance of " + clazz.getName() + ": " + val);
    }

    public static <T, C, F extends Factory<T, C>> T create(Class<T> clazz, Class<F> factoryClass, C config) throws FactoryNotFoundException, IllegalFactoryException, ConfigException {
        F factory = FactoryUtil.createFactory(clazz, factoryClass);
        return factory.create(config);
    }

    public static Class<? extends Factory> loadFactoryClass(String factoryClassName) throws FactoryNotFoundException, IllegalFactoryException {
        Class<?> factoryClass;
        try {
            factoryClass = Class.forName(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            throw new FactoryNotFoundException(factoryClassName, e);
        }
        try {
            return factoryClass.asSubclass(Factory.class);
        }
        catch (ClassCastException e) {
            throw new IllegalFactoryException("not an instance of " + Factory.class.getName() + ": " + factoryClassName);
        }
    }

    public static <T, C, F extends Factory<T, C>> F createFactory(Class<T> clazz, Class<F> factoryClass) throws IllegalFactoryException {
        try {
            return (F)((Factory)factoryClass.newInstance());
        }
        catch (IllegalAccessException e) {
            throw new IllegalFactoryException("could not instantiated factory " + factoryClass.getName() + ", e=" + e, e);
        }
        catch (InstantiationException e) {
            throw new IllegalFactoryException("could not instantiated factory " + factoryClass.getName() + ", e=" + e, e);
        }
    }

    private FactoryUtil() {
    }
}

