/*
 * Decompiled with CFR 0.152.
 */
package ch.javasoft.cdd.parser;

import ch.javasoft.math.BigFraction;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CddNumberFormat {
    integer{

        public Class<BigInteger[]> getArrayClass() {
            return BigInteger[].class;
        }

        public Class<BigInteger> getNumberClass() {
            return BigInteger.class;
        }

        @Override
        public double parseDouble(String str) {
            return new BigInteger(str).doubleValue();
        }

        @Override
        public BigInteger parseNumber(String str) {
            BigInteger val = new BigInteger(str);
            if (BigInteger.ZERO.equals(val)) {
                return BigInteger.ZERO;
            }
            if (BigInteger.ONE.equals(val)) {
                return BigInteger.ONE;
            }
            if (BigInteger.TEN.equals(val)) {
                return BigInteger.TEN;
            }
            return val;
        }

        public BigInteger[][] newMatrix(int rows, int cols) {
            return new BigInteger[rows][cols];
        }

        @Override
        public int getColumnCount(Object[] matrix) {
            BigInteger[][] mx = (BigInteger[][])matrix;
            return mx.length == 0 ? 0 : mx[0].length;
        }

        @Override
        public BigInteger getNumber(Object[] matrix, int row, int col) {
            return ((BigInteger[][])matrix)[row][col];
        }

        @Override
        public void parseAndSet(Object[] matrix, int row, int col, String value) {
            ((BigInteger[][])matrix)[row][col] = this.parseNumber(value);
        }
    }
    ,
    rational{

        public Class<BigFraction[]> getArrayClass() {
            return BigFraction[].class;
        }

        public Class<BigFraction> getNumberClass() {
            return BigFraction.class;
        }

        @Override
        public double parseDouble(String str) {
            return BigFraction.valueOf(str).doubleValue();
        }

        @Override
        public BigFraction parseNumber(String str) {
            return BigFraction.valueOf(str);
        }

        public BigFraction[][] newMatrix(int rows, int cols) {
            return new BigFraction[rows][cols];
        }

        @Override
        public int getColumnCount(Object[] matrix) {
            BigFraction[][] mx = (BigFraction[][])matrix;
            return mx.length == 0 ? 0 : mx[0].length;
        }

        @Override
        public BigFraction getNumber(Object[] matrix, int row, int col) {
            return ((BigFraction[][])matrix)[row][col];
        }

        @Override
        public void parseAndSet(Object[] matrix, int row, int col, String value) {
            ((BigFraction[][])matrix)[row][col] = this.parseNumber(value);
        }
    }
    ,
    real{

        public Class<double[]> getArrayClass() {
            return double[].class;
        }

        public Class<Double> getNumberClass() {
            return Double.TYPE;
        }

        @Override
        public double parseDouble(String str) {
            return Double.parseDouble(str);
        }

        @Override
        public Double parseNumber(String str) {
            return Double.valueOf(str);
        }

        public double[][] newMatrix(int rows, int cols) {
            return new double[rows][cols];
        }

        @Override
        public int getColumnCount(Object[] matrix) {
            double[][] mx = (double[][])matrix;
            return mx.length == 0 ? 0 : mx[0].length;
        }

        @Override
        public Double getNumber(Object[] matrix, int row, int col) {
            return ((double[][])matrix)[row][col];
        }

        @Override
        public void parseAndSet(Object[] matrix, int row, int col, String value) {
            ((double[][])matrix)[row][col] = this.parseDouble(value);
        }
    };


    private CddNumberFormat() {
    }

    public abstract Class<?> getArrayClass();

    public abstract Class<? extends Number> getNumberClass();

    public abstract double parseDouble(String var1);

    public abstract Number parseNumber(String var1);

    public abstract Object[] newMatrix(int var1, int var2);

    public abstract int getColumnCount(Object[] var1);

    public abstract Number getNumber(Object[] var1, int var2, int var3);

    public abstract void parseAndSet(Object[] var1, int var2, int var3, String var4);

    public static <A> A[] castMatrix(Class<A> arrayClass, Object[] matrix) throws ClassCastException {
        if (arrayClass.isAssignableFrom(matrix.getClass().getComponentType())) {
            return matrix;
        }
        throw new ClassCastException(String.valueOf(arrayClass.getName()) + "[]: " + matrix);
    }

    /* synthetic */ CddNumberFormat(String string, int n, CddNumberFormat cddNumberFormat) {
        this();
    }
}

