"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeHttpBodyInputObject = exports.makeHttpQueryInputObject = exports.makeUrlParamInputObject = exports.makeHttpArgument = void 0;
const graphql_transformer_common_1 = require("graphql-transformer-common");
function makeHttpArgument(name, inputType, makeNonNull) {
    const type = makeNonNull ? graphql_transformer_common_1.makeNonNullType(graphql_transformer_common_1.makeNamedType(inputType.name.value)) : graphql_transformer_common_1.makeNamedType(inputType.name.value);
    return graphql_transformer_common_1.makeInputValueDefinition(name, type);
}
exports.makeHttpArgument = makeHttpArgument;
function makeUrlParamInputObject(parent, field, urlParams) {
    const name = graphql_transformer_common_1.ModelResourceIDs.UrlParamsInputObjectName(parent.name.value, field.name.value);
    const urlParamFields = urlParams.map((param) => {
        return graphql_transformer_common_1.makeInputValueDefinition(param, graphql_transformer_common_1.makeNonNullType(graphql_transformer_common_1.makeNamedType('String')));
    });
    return {
        kind: 'InputObjectTypeDefinition',
        name: {
            kind: 'Name',
            value: name,
        },
        fields: urlParamFields,
        directives: [],
    };
}
exports.makeUrlParamInputObject = makeUrlParamInputObject;
function makeHttpQueryInputObject(parent, field, queryArgArray, deNull) {
    const name = graphql_transformer_common_1.ModelResourceIDs.HttpQueryInputObjectName(parent.name.value, field.name.value);
    const fields = deNull
        ? queryArgArray.map((arg) => {
            return {
                ...arg,
                type: graphql_transformer_common_1.unwrapNonNull(arg.type),
            };
        })
        : queryArgArray;
    return {
        kind: 'InputObjectTypeDefinition',
        name: {
            kind: 'Name',
            value: name,
        },
        fields,
        directives: [],
    };
}
exports.makeHttpQueryInputObject = makeHttpQueryInputObject;
function makeHttpBodyInputObject(parent, field, bodyArgArray, deNull) {
    const name = graphql_transformer_common_1.ModelResourceIDs.HttpBodyInputObjectName(parent.name.value, field.name.value);
    const fields = deNull
        ? bodyArgArray.map((arg) => {
            return {
                ...arg,
                type: graphql_transformer_common_1.unwrapNonNull(arg.type),
            };
        })
        : bodyArgArray;
    return {
        kind: 'InputObjectTypeDefinition',
        name: {
            kind: 'Name',
            value: name,
        },
        fields,
        directives: [],
    };
}
exports.makeHttpBodyInputObject = makeHttpBodyInputObject;
//# sourceMappingURL=definitions.js.map