# Changelog
All notable changes to this project will be documented in this file.

## [0.1.5] - 2022-05-11

### CI configuration

- Update and simplify GitLab CI config
- Use more GitLab instance-wide includes
- Add `rust.yml` workflow
- Add `python.yml` workflow
- Lint and typecheck Python tests
- Add `publish.yml` workflow
- Add `wheels.yml` workflow
- Upload Python wheels to PyPI in `publish.yml`

### Documentation

- Add subsampled canvas image export examples

### Miscellaneous Tasks

- Add pylintrc config file

### Testing

- Export subsampled images in all formats

### Build

- Upgrade the PyO3 dependency to v0.16
- Upgrade `python3-dll-a` dependency to v0.2
- Upgrade the PyO3 dependency to v0.16.3
- Upgrade the PyO3 dependency to v0.16.4
- Upgrade to planetarium v0.1.5

## [0.1.4] - 2022-03-03

### Features

- Add subsampled canvas image export method

### Build

- Use `python3-dll-a` crate to target Windows

## [0.1.3] - 2021-12-20

### Bug Fixes

- Fix spurious clippy warnings for rust v1.57
- Update setuptools for pylint runs

### CI configuration

- Fail the clippy check on warnings

### Documentation

- Add window image export examples

### Features

- Add `Canvas.PIXEL_MAX` class attribute
- Add `Window` type bindings
- Add `export_window_image()` method binding

### Refactor

- Extract `SpotShape` tests into a module

### Build

- Update Planetarium to v0.1.3

## [0.1.2] - 2021-11-24

### Documentation

- Expand Python class docstrings

### Features

- Implement `__hash__` for `SpotId` and enums
- Add `SpotShape` helper methods
- Add `Transform` type bindings
- Support the view coordinate transformation

### Refactor

- Use `From<T>` conversions in constructors

### Testing

- Add `Transform` class unit tests

### Build

- Update `planetarium` dependency to v0.1.2

## [0.1.1] - 2021-11-18

### CI configuration

- Build Python package source distribution
- Test install from the Python package source

### Documentation

- Add a usage example to the module docstring

### Features

- Add support for RAW image formats and more
- Add `SpotShape` class constructor variants
- Implement `__str__` and `__repr__` for classes

### Miscellaneous Tasks

- Add `git-cliff` config file
- Add a change log file

### Testing

- Add spot parameters adjustment unit test

### Build

- Update `planetarium` dependency to v0.1.1

## [0.1.0] - 2021-11-11

### CI configuration

- Add a basic GitLab CI config file
- Build and publish `win_amd64` wheels
- Perform test install on Linux and Windows.

### Testing

- Add some integration tests in Python
- Add canvas image export test case

### Build

- Add python3.dll exported symbol definitions
- Add Windows cross compile environment script

<!-- generated by git-cliff -->
