"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBSeeder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class DynamoDBSeeder extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const seeds = props.seeds.bind(this);
        const seedsBucket = ((_b = seeds.s3Location) === null || _b === void 0 ? void 0 : _b.bucketName) ? aws_cdk_lib_1.aws_s3.Bucket.fromBucketName(this, 'SeedsBucket', seeds.s3Location.bucketName) : undefined;
        const handler = new aws_cdk_lib_1.aws_lambda.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: 'Custom::DynamodbSeeder',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'dynamodb-seeder')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::DynamodbSeeder',
            timeout: (_c = props.timeout) !== null && _c !== void 0 ? _c : aws_cdk_lib_1.Duration.minutes(15),
        });
        handler.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: ['dynamodb:BatchWriteItem'],
            resources: [props.table.tableArn],
        }));
        if (props.table.encryptionKey) {
            handler.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                actions: ['kms:Encrypt', 'kms:Decrypt', 'kms:ReEncrypt*', 'kms:GenerateDataKey*', 'kms:DescribeKey', 'kms:CreateGrant'],
                resources: [props.table.encryptionKey.keyArn],
            }));
        }
        if (seedsBucket) {
            const objectKey = (_e = (_d = seeds.s3Location) === null || _d === void 0 ? void 0 : _d.objectKey) !== null && _e !== void 0 ? _e : '*';
            handler.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                actions: ['s3:GetObject'],
                resources: [seedsBucket.arnForObjects(objectKey)],
            }));
        }
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::DynamodbSeeder',
            properties: {
                TableName: props.table.tableName,
                Seeds: {
                    InlineSeeds: seeds.inlineSeeds,
                    S3Bucket: seeds.s3Location && seeds.s3Location.bucketName,
                    S3Key: seeds.s3Location && seeds.s3Location.objectKey,
                    S3ObjectVersion: seeds.s3Location && seeds.s3Location.objectVersion,
                },
            },
        });
    }
}
exports.DynamoDBSeeder = DynamoDBSeeder;
_a = JSII_RTTI_SYMBOL_1;
DynamoDBSeeder[_a] = { fqn: "@cloudcomponents/cdk-dynamodb-seeder.DynamoDBSeeder", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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