# Generated by Django 3.2.11 on 2022-01-30 00:08

import colorfield.fields
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wagtailimages", "0023_add_choose_permissions"),
    ]

    operations = [
        migrations.CreateModel(
            name="Theme",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(default="Wagtail", max_length=50, unique=True),
                ),
                ("active", models.BooleanField(default=True)),
                (
                    "sidebar_logo_background_color",
                    colorfield.fields.ColorField(
                        default="#555555",
                        image_field=None,
                        max_length=18,
                        null=True,
                        samples=None,
                    ),
                ),
                (
                    "sidebar_logo_shape",
                    models.CharField(
                        choices=[
                            ("circular", "Circular"),
                            ("rectangular", "Rectangular"),
                            ("square", "Square"),
                        ],
                        default="circular",
                        max_length=50,
                    ),
                ),
                (
                    "color_primary",
                    colorfield.fields.ColorField(
                        default="#007d7e", image_field=None, max_length=10, samples=None
                    ),
                ),
                (
                    "color_primary_darker",
                    colorfield.fields.ColorField(
                        default=None,
                        image_field=None,
                        max_length=10,
                        null=True,
                        samples=None,
                    ),
                ),
                (
                    "color_primary_dark",
                    colorfield.fields.ColorField(
                        default=None,
                        image_field=None,
                        max_length=10,
                        null=True,
                        samples=None,
                    ),
                ),
                (
                    "color_primary_lighter",
                    colorfield.fields.ColorField(
                        default=None,
                        image_field=None,
                        max_length=10,
                        null=True,
                        samples=None,
                    ),
                ),
                (
                    "color_primary_light",
                    colorfield.fields.ColorField(
                        default=None,
                        image_field=None,
                        max_length=10,
                        null=True,
                        samples=None,
                    ),
                ),
                (
                    "color_input_focus",
                    colorfield.fields.ColorField(
                        default=None,
                        image_field=None,
                        max_length=10,
                        null=True,
                        samples=None,
                    ),
                ),
                (
                    "color_input_focus_border",
                    colorfield.fields.ColorField(
                        default=None,
                        image_field=None,
                        max_length=10,
                        null=True,
                        samples=None,
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        default="Welcome to the Wagtail CMS", max_length=50
                    ),
                ),
                (
                    "title_color",
                    colorfield.fields.ColorField(
                        default="#F5DD5D", image_field=None, max_length=10, samples=None
                    ),
                ),
                ("title_visible", models.BooleanField(default=True)),
                (
                    "logo",
                    models.FileField(
                        upload_to="wagtail-admin-interface/branding-logo/"
                    ),
                ),
                (
                    "logo_color",
                    colorfield.fields.ColorField(
                        default="#FFFFFF", image_field=None, max_length=10, samples=None
                    ),
                ),
                ("logo_max_width", models.PositiveSmallIntegerField(default=400)),
                ("logo_max_height", models.PositiveSmallIntegerField(default=100)),
                ("logo_visible", models.BooleanField(default=True)),
                ("favicon", models.FileField(upload_to="admin-interface/favicon/")),
                ("env_name", models.CharField(max_length=50)),
                (
                    "env_color",
                    colorfield.fields.ColorField(
                        default="#E74C3C", image_field=None, max_length=10, samples=None
                    ),
                ),
                ("env_visible_in_header", models.BooleanField(default=True)),
                ("env_visible_in_favicon", models.BooleanField(default=True)),
                (
                    "sidebar_logo",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="wagtailimages.image",
                    ),
                ),
                (
                    "sidebar_logo_mobile",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="wagtailimages.image",
                    ),
                ),
            ],
            options={
                "verbose_name": "Theme",
                "verbose_name_plural": "Themes",
            },
        ),
    ]
