/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["vendors-node_modules_jupyterlab_filebrowser_lib_index_js"],{

/***/ "../node_modules/@jupyterlab/filebrowser/lib/browser.js":
/*!**************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/browser.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FileBrowser\": () => (/* binding */ FileBrowser)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/services */ \"webpack/sharing/consume/default/@jupyterlab/services/@jupyterlab/services\");\n/* harmony import */ var _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _crumbs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./crumbs */ \"../node_modules/@jupyterlab/filebrowser/lib/crumbs.js\");\n/* harmony import */ var _listing__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./listing */ \"../node_modules/@jupyterlab/filebrowser/lib/listing.js\");\n/* harmony import */ var _upload__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./upload */ \"../node_modules/@jupyterlab/filebrowser/lib/upload.js\");\n/* harmony import */ var _search__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./search */ \"../node_modules/@jupyterlab/filebrowser/lib/search.js\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n\n/**\n * The class name added to file browsers.\n */\nconst FILE_BROWSER_CLASS = 'jp-FileBrowser';\n/**\n * The class name added to the filebrowser crumbs node.\n */\nconst CRUMBS_CLASS = 'jp-FileBrowser-crumbs';\n/**\n * The class name added to the filebrowser filterbox node.\n */\nconst FILTERBOX_CLASS = 'jp-FileBrowser-filterBox';\n/**\n * The class name added to the filebrowser toolbar node.\n */\nconst TOOLBAR_CLASS = 'jp-FileBrowser-toolbar';\n/**\n * The class name added to the filebrowser listing node.\n */\nconst LISTING_CLASS = 'jp-FileBrowser-listing';\n/**\n * A widget which hosts a file browser.\n *\n * The widget uses the Jupyter Contents API to retrieve contents,\n * and presents itself as a flat list of files and directories with\n * breadcrumbs.\n */\nclass FileBrowser extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_3__.Widget {\n    /**\n     * Construct a new file browser.\n     *\n     * @param model - The file browser view model.\n     */\n    constructor(options) {\n        super();\n        this._useFuzzyFilter = true;\n        this.addClass(FILE_BROWSER_CLASS);\n        this.id = options.id;\n        const model = (this.model = options.model);\n        const renderer = options.renderer;\n        const translator = this.translator;\n        model.connectionFailure.connect(this._onConnectionFailure, this);\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__.nullTranslator;\n        this._manager = model.manager;\n        this._trans = this.translator.load('jupyterlab');\n        this._crumbs = new _crumbs__WEBPACK_IMPORTED_MODULE_5__.BreadCrumbs({ model, translator });\n        this.toolbar = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Toolbar();\n        this._directoryPending = false;\n        const newFolder = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ToolbarButton({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.newFolderIcon,\n            onClick: () => {\n                this.createNewDirectory();\n            },\n            tooltip: this._trans.__('New Folder')\n        });\n        const uploader = new _upload__WEBPACK_IMPORTED_MODULE_6__.Uploader({ model, translator: this.translator });\n        const refresher = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ToolbarButton({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.refreshIcon,\n            onClick: () => {\n                void model.refresh();\n            },\n            tooltip: this._trans.__('Refresh File List')\n        });\n        this.toolbar.addItem('newFolder', newFolder);\n        this.toolbar.addItem('upload', uploader);\n        this.toolbar.addItem('refresher', refresher);\n        this._listing = new _listing__WEBPACK_IMPORTED_MODULE_7__.DirListing({\n            model,\n            renderer,\n            translator: this.translator\n        });\n        this._filenameSearcher = (0,_search__WEBPACK_IMPORTED_MODULE_8__.FilenameSearcher)({\n            listing: this._listing,\n            useFuzzyFilter: this._useFuzzyFilter,\n            placeholder: this._trans.__('Filter files by name')\n        });\n        this._crumbs.addClass(CRUMBS_CLASS);\n        this.toolbar.addClass(TOOLBAR_CLASS);\n        this._filenameSearcher.addClass(FILTERBOX_CLASS);\n        this._listing.addClass(LISTING_CLASS);\n        this.layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_3__.PanelLayout();\n        this.layout.addWidget(this.toolbar);\n        this.layout.addWidget(this._filenameSearcher);\n        this.layout.addWidget(this._crumbs);\n        this.layout.addWidget(this._listing);\n        if (options.restore !== false) {\n            void model.restore(this.id);\n        }\n    }\n    /**\n     * Whether to show active file in file browser\n     */\n    get navigateToCurrentDirectory() {\n        return this._navigateToCurrentDirectory;\n    }\n    set navigateToCurrentDirectory(value) {\n        this._navigateToCurrentDirectory = value;\n    }\n    /**\n     * Whether to use fuzzy filtering on file names.\n     */\n    set useFuzzyFilter(value) {\n        this._useFuzzyFilter = value;\n        this._filenameSearcher = (0,_search__WEBPACK_IMPORTED_MODULE_8__.FilenameSearcher)({\n            listing: this._listing,\n            useFuzzyFilter: this._useFuzzyFilter,\n            placeholder: this._trans.__('Filter files by name'),\n            forceRefresh: true\n        });\n        this._filenameSearcher.addClass(FILTERBOX_CLASS);\n        this.layout.removeWidget(this._filenameSearcher);\n        this.layout.removeWidget(this._crumbs);\n        this.layout.removeWidget(this._listing);\n        this.layout.addWidget(this._filenameSearcher);\n        this.layout.addWidget(this._crumbs);\n        this.layout.addWidget(this._listing);\n    }\n    /**\n     * Create an iterator over the listing's selected items.\n     *\n     * @returns A new iterator over the listing's selected items.\n     */\n    selectedItems() {\n        return this._listing.selectedItems();\n    }\n    /**\n     * Select an item by name.\n     *\n     * @param name - The name of the item to select.\n     */\n    async selectItemByName(name) {\n        await this._listing.selectItemByName(name);\n    }\n    clearSelectedItems() {\n        this._listing.clearSelectedItems();\n    }\n    /**\n     * Rename the first currently selected item.\n     *\n     * @returns A promise that resolves with the new name of the item.\n     */\n    rename() {\n        return this._listing.rename();\n    }\n    /**\n     * Cut the selected items.\n     */\n    cut() {\n        this._listing.cut();\n    }\n    /**\n     * Copy the selected items.\n     */\n    copy() {\n        this._listing.copy();\n    }\n    /**\n     * Paste the items from the clipboard.\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    paste() {\n        return this._listing.paste();\n    }\n    /**\n     * Create a new directory\n     */\n    createNewDirectory() {\n        if (this._directoryPending === true) {\n            return;\n        }\n        this._directoryPending = true;\n        // TODO: We should provide a hook into when the\n        // directory is done being created. This probably\n        // means storing a pendingDirectory promise and\n        // returning that if there is already a directory\n        // request.\n        void this._manager\n            .newUntitled({\n            path: this.model.path,\n            type: 'directory'\n        })\n            .then(async (model) => {\n            await this._listing.selectItemByName(model.name);\n            this._directoryPending = false;\n        })\n            .catch(err => {\n            this._directoryPending = false;\n        });\n    }\n    /**\n     * Delete the currently selected item(s).\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    delete() {\n        return this._listing.delete();\n    }\n    /**\n     * Duplicate the currently selected item(s).\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    duplicate() {\n        return this._listing.duplicate();\n    }\n    /**\n     * Download the currently selected item(s).\n     */\n    download() {\n        return this._listing.download();\n    }\n    /**\n     * Shut down kernels on the applicable currently selected items.\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    shutdownKernels() {\n        return this._listing.shutdownKernels();\n    }\n    /**\n     * Select next item.\n     */\n    selectNext() {\n        this._listing.selectNext();\n    }\n    /**\n     * Select previous item.\n     */\n    selectPrevious() {\n        this._listing.selectPrevious();\n    }\n    /**\n     * Find a model given a click.\n     *\n     * @param event - The mouse event.\n     *\n     * @returns The model for the selected file.\n     */\n    modelForClick(event) {\n        return this._listing.modelForClick(event);\n    }\n    /**\n     * Handle a connection lost signal from the model.\n     */\n    _onConnectionFailure(sender, args) {\n        if (args instanceof _jupyterlab_services__WEBPACK_IMPORTED_MODULE_1__.ServerConnection.ResponseError &&\n            args.response.status === 404) {\n            const title = this._trans.__('Directory not found');\n            args.message = this._trans.__('Directory not found: \"%1\"', this.model.path);\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(title, args);\n        }\n    }\n}\n//# sourceMappingURL=browser.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/browser.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/crumbs.js":
/*!*************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/crumbs.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"BreadCrumbs\": () => (/* binding */ BreadCrumbs)\n/* harmony export */ });\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/domutils */ \"webpack/sharing/consume/default/@lumino/domutils/@lumino/domutils\");\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_domutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @jupyterlab/docmanager */ \"webpack/sharing/consume/default/@jupyterlab/docmanager/@jupyterlab/docmanager\");\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n/**\n * The class name added to the breadcrumb node.\n */\nconst BREADCRUMB_CLASS = 'jp-BreadCrumbs';\n/**\n * The class name for the breadcrumbs home node\n */\nconst BREADCRUMB_HOME_CLASS = 'jp-BreadCrumbs-home';\n/**\n * The class name added to the breadcrumb node.\n */\nconst BREADCRUMB_ITEM_CLASS = 'jp-BreadCrumbs-item';\n/**\n * Bread crumb paths.\n */\nconst BREAD_CRUMB_PATHS = ['/', '../../', '../', ''];\n/**\n * The mime type for a contents drag object.\n */\nconst CONTENTS_MIME = 'application/x-jupyter-icontents';\n/**\n * The class name added to drop targets.\n */\nconst DROP_TARGET_CLASS = 'jp-mod-dropTarget';\n/**\n * A class which hosts folder breadcrumbs.\n */\nclass BreadCrumbs extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_2__.Widget {\n    /**\n     * Construct a new file browser crumb widget.\n     *\n     * @param model - The file browser view model.\n     */\n    constructor(options) {\n        super();\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_6__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._model = options.model;\n        this.addClass(BREADCRUMB_CLASS);\n        this._crumbs = Private.createCrumbs();\n        this._crumbSeps = Private.createCrumbSeparators();\n        this.node.appendChild(this._crumbs[Private.Crumb.Home]);\n        this._model.refreshed.connect(this.update, this);\n    }\n    /**\n     * Handle the DOM events for the bread crumbs.\n     *\n     * @param event - The DOM event sent to the widget.\n     *\n     * #### Notes\n     * This method implements the DOM `EventListener` interface and is\n     * called in response to events on the panel's DOM node. It should\n     * not be called directly by user code.\n     */\n    handleEvent(event) {\n        switch (event.type) {\n            case 'click':\n                this._evtClick(event);\n                break;\n            case 'lm-dragenter':\n                this._evtDragEnter(event);\n                break;\n            case 'lm-dragleave':\n                this._evtDragLeave(event);\n                break;\n            case 'lm-dragover':\n                this._evtDragOver(event);\n                break;\n            case 'lm-drop':\n                this._evtDrop(event);\n                break;\n            default:\n                return;\n        }\n    }\n    /**\n     * A message handler invoked on an `'after-attach'` message.\n     */\n    onAfterAttach(msg) {\n        super.onAfterAttach(msg);\n        this.update();\n        const node = this.node;\n        node.addEventListener('click', this);\n        node.addEventListener('lm-dragenter', this);\n        node.addEventListener('lm-dragleave', this);\n        node.addEventListener('lm-dragover', this);\n        node.addEventListener('lm-drop', this);\n    }\n    /**\n     * A message handler invoked on a `'before-detach'` message.\n     */\n    onBeforeDetach(msg) {\n        super.onBeforeDetach(msg);\n        const node = this.node;\n        node.removeEventListener('click', this);\n        node.removeEventListener('lm-dragenter', this);\n        node.removeEventListener('lm-dragleave', this);\n        node.removeEventListener('lm-dragover', this);\n        node.removeEventListener('lm-drop', this);\n    }\n    /**\n     * A handler invoked on an `'update-request'` message.\n     */\n    onUpdateRequest(msg) {\n        // Update the breadcrumb list.\n        const contents = this._model.manager.services.contents;\n        const localPath = contents.localPath(this._model.path);\n        Private.updateCrumbs(this._crumbs, this._crumbSeps, localPath);\n    }\n    /**\n     * Handle the `'click'` event for the widget.\n     */\n    _evtClick(event) {\n        // Do nothing if it's not a left mouse press.\n        if (event.button !== 0) {\n            return;\n        }\n        // Find a valid click target.\n        let node = event.target;\n        while (node && node !== this.node) {\n            if (node.classList.contains(BREADCRUMB_ITEM_CLASS) ||\n                node.classList.contains(BREADCRUMB_HOME_CLASS)) {\n                const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.findFirstIndex(this._crumbs, value => value === node);\n                this._model\n                    .cd(BREAD_CRUMB_PATHS[index])\n                    .catch(error => (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showErrorMessage)(this._trans.__('Open Error'), error));\n                // Stop the event propagation.\n                event.preventDefault();\n                event.stopPropagation();\n                return;\n            }\n            node = node.parentElement;\n        }\n    }\n    /**\n     * Handle the `'lm-dragenter'` event for the widget.\n     */\n    _evtDragEnter(event) {\n        if (event.mimeData.hasData(CONTENTS_MIME)) {\n            const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.findFirstIndex(this._crumbs, node => _lumino_domutils__WEBPACK_IMPORTED_MODULE_1__.ElementExt.hitTest(node, event.clientX, event.clientY));\n            if (index !== -1) {\n                if (index !== Private.Crumb.Current) {\n                    this._crumbs[index].classList.add(DROP_TARGET_CLASS);\n                    event.preventDefault();\n                    event.stopPropagation();\n                }\n            }\n        }\n    }\n    /**\n     * Handle the `'lm-dragleave'` event for the widget.\n     */\n    _evtDragLeave(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        const dropTarget = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.DOMUtils.findElement(this.node, DROP_TARGET_CLASS);\n        if (dropTarget) {\n            dropTarget.classList.remove(DROP_TARGET_CLASS);\n        }\n    }\n    /**\n     * Handle the `'lm-dragover'` event for the widget.\n     */\n    _evtDragOver(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        event.dropAction = event.proposedAction;\n        const dropTarget = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.DOMUtils.findElement(this.node, DROP_TARGET_CLASS);\n        if (dropTarget) {\n            dropTarget.classList.remove(DROP_TARGET_CLASS);\n        }\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.findFirstIndex(this._crumbs, node => _lumino_domutils__WEBPACK_IMPORTED_MODULE_1__.ElementExt.hitTest(node, event.clientX, event.clientY));\n        if (index !== -1) {\n            this._crumbs[index].classList.add(DROP_TARGET_CLASS);\n        }\n    }\n    /**\n     * Handle the `'lm-drop'` event for the widget.\n     */\n    _evtDrop(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        if (event.proposedAction === 'none') {\n            event.dropAction = 'none';\n            return;\n        }\n        if (!event.mimeData.hasData(CONTENTS_MIME)) {\n            return;\n        }\n        event.dropAction = event.proposedAction;\n        let target = event.target;\n        while (target && target.parentElement) {\n            if (target.classList.contains(DROP_TARGET_CLASS)) {\n                target.classList.remove(DROP_TARGET_CLASS);\n                break;\n            }\n            target = target.parentElement;\n        }\n        // Get the path based on the target node.\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.ArrayExt.findFirstIndex(this._crumbs, node => node === target);\n        if (index === -1) {\n            return;\n        }\n        const model = this._model;\n        const path = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__.PathExt.resolve(model.path, BREAD_CRUMB_PATHS[index]);\n        const manager = model.manager;\n        // Move all of the items.\n        const promises = [];\n        const oldPaths = event.mimeData.getData(CONTENTS_MIME);\n        for (const oldPath of oldPaths) {\n            const localOldPath = manager.services.contents.localPath(oldPath);\n            const name = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__.PathExt.basename(localOldPath);\n            const newPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__.PathExt.join(path, name);\n            promises.push((0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_5__.renameFile)(manager, oldPath, newPath));\n        }\n        void Promise.all(promises).catch(err => {\n            return (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.showErrorMessage)(this._trans.__('Move Error'), err);\n        });\n    }\n}\n/**\n * The namespace for the crumbs private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Breadcrumb item list enum.\n     */\n    let Crumb;\n    (function (Crumb) {\n        Crumb[Crumb[\"Home\"] = 0] = \"Home\";\n        Crumb[Crumb[\"Ellipsis\"] = 1] = \"Ellipsis\";\n        Crumb[Crumb[\"Parent\"] = 2] = \"Parent\";\n        Crumb[Crumb[\"Current\"] = 3] = \"Current\";\n    })(Crumb = Private.Crumb || (Private.Crumb = {}));\n    /**\n     * Populate the breadcrumb node.\n     */\n    function updateCrumbs(breadcrumbs, separators, path) {\n        const node = breadcrumbs[0].parentNode;\n        // Remove all but the home node.\n        const firstChild = node.firstChild;\n        while (firstChild && firstChild.nextSibling) {\n            node.removeChild(firstChild.nextSibling);\n        }\n        node.appendChild(separators[0]);\n        const parts = path.split('/');\n        if (parts.length > 2) {\n            node.appendChild(breadcrumbs[Crumb.Ellipsis]);\n            const grandParent = parts.slice(0, parts.length - 2).join('/');\n            breadcrumbs[Crumb.Ellipsis].title = grandParent;\n            node.appendChild(separators[1]);\n        }\n        if (path) {\n            if (parts.length >= 2) {\n                breadcrumbs[Crumb.Parent].textContent = parts[parts.length - 2];\n                node.appendChild(breadcrumbs[Crumb.Parent]);\n                const parent = parts.slice(0, parts.length - 1).join('/');\n                breadcrumbs[Crumb.Parent].title = parent;\n                node.appendChild(separators[2]);\n            }\n            breadcrumbs[Crumb.Current].textContent = parts[parts.length - 1];\n            node.appendChild(breadcrumbs[Crumb.Current]);\n            breadcrumbs[Crumb.Current].title = path;\n            node.appendChild(separators[3]);\n        }\n    }\n    Private.updateCrumbs = updateCrumbs;\n    /**\n     * Create the breadcrumb nodes.\n     */\n    function createCrumbs() {\n        const home = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7__.folderIcon.element({\n            className: BREADCRUMB_HOME_CLASS,\n            tag: 'span',\n            title: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_4__.PageConfig.getOption('serverRoot') || 'Jupyter Server Root',\n            stylesheet: 'breadCrumb'\n        });\n        const ellipsis = _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_7__.ellipsesIcon.element({\n            className: BREADCRUMB_ITEM_CLASS,\n            tag: 'span',\n            stylesheet: 'breadCrumb'\n        });\n        const parent = document.createElement('span');\n        parent.className = BREADCRUMB_ITEM_CLASS;\n        const current = document.createElement('span');\n        current.className = BREADCRUMB_ITEM_CLASS;\n        return [home, ellipsis, parent, current];\n    }\n    Private.createCrumbs = createCrumbs;\n    /**\n     * Create the breadcrumb separator nodes.\n     */\n    function createCrumbSeparators() {\n        const items = [];\n        // The maximum number of directories that will be shown in the crumbs\n        const MAX_DIRECTORIES = 2;\n        // Make separators for after each directory, one at the beginning, and one\n        // after a possible ellipsis.\n        for (let i = 0; i < MAX_DIRECTORIES + 2; i++) {\n            const item = document.createElement('span');\n            item.textContent = '/';\n            items.push(item);\n        }\n        return items;\n    }\n    Private.createCrumbSeparators = createCrumbSeparators;\n})(Private || (Private = {}));\n//# sourceMappingURL=crumbs.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/crumbs.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/index.js":
/*!************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FileBrowser\": () => (/* reexport safe */ _browser__WEBPACK_IMPORTED_MODULE_0__.FileBrowser),\n/* harmony export */   \"BreadCrumbs\": () => (/* reexport safe */ _crumbs__WEBPACK_IMPORTED_MODULE_1__.BreadCrumbs),\n/* harmony export */   \"IFileBrowserFactory\": () => (/* reexport safe */ _tokens__WEBPACK_IMPORTED_MODULE_2__.IFileBrowserFactory),\n/* harmony export */   \"DirListing\": () => (/* reexport safe */ _listing__WEBPACK_IMPORTED_MODULE_3__.DirListing),\n/* harmony export */   \"CHUNK_SIZE\": () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_4__.CHUNK_SIZE),\n/* harmony export */   \"FileBrowserModel\": () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_4__.FileBrowserModel),\n/* harmony export */   \"FilterFileBrowserModel\": () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_4__.FilterFileBrowserModel),\n/* harmony export */   \"LARGE_FILE_SIZE\": () => (/* reexport safe */ _model__WEBPACK_IMPORTED_MODULE_4__.LARGE_FILE_SIZE),\n/* harmony export */   \"FileDialog\": () => (/* reexport safe */ _opendialog__WEBPACK_IMPORTED_MODULE_5__.FileDialog),\n/* harmony export */   \"FilenameSearcher\": () => (/* reexport safe */ _search__WEBPACK_IMPORTED_MODULE_6__.FilenameSearcher),\n/* harmony export */   \"Uploader\": () => (/* reexport safe */ _upload__WEBPACK_IMPORTED_MODULE_7__.Uploader),\n/* harmony export */   \"FileUploadStatus\": () => (/* reexport safe */ _uploadstatus__WEBPACK_IMPORTED_MODULE_8__.FileUploadStatus)\n/* harmony export */ });\n/* harmony import */ var _browser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./browser */ \"../node_modules/@jupyterlab/filebrowser/lib/browser.js\");\n/* harmony import */ var _crumbs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./crumbs */ \"../node_modules/@jupyterlab/filebrowser/lib/crumbs.js\");\n/* harmony import */ var _tokens__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./tokens */ \"../node_modules/@jupyterlab/filebrowser/lib/tokens.js\");\n/* harmony import */ var _listing__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./listing */ \"../node_modules/@jupyterlab/filebrowser/lib/listing.js\");\n/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./model */ \"../node_modules/@jupyterlab/filebrowser/lib/model.js\");\n/* harmony import */ var _opendialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./opendialog */ \"../node_modules/@jupyterlab/filebrowser/lib/opendialog.js\");\n/* harmony import */ var _search__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./search */ \"../node_modules/@jupyterlab/filebrowser/lib/search.js\");\n/* harmony import */ var _upload__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./upload */ \"../node_modules/@jupyterlab/filebrowser/lib/upload.js\");\n/* harmony import */ var _uploadstatus__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./uploadstatus */ \"../node_modules/@jupyterlab/filebrowser/lib/uploadstatus.js\");\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/**\n * @packageDocumentation\n * @module filebrowser\n */\n\n\n\n\n\n\n\n\n\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/index.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/listing.js":
/*!**************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/listing.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"DirListing\": () => (/* binding */ DirListing)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/docmanager */ \"webpack/sharing/consume/default/@jupyterlab/docmanager/@jupyterlab/docmanager\");\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/docregistry */ \"webpack/sharing/consume/default/@jupyterlab/docregistry/@jupyterlab/docregistry\");\n/* harmony import */ var _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @lumino/domutils */ \"webpack/sharing/consume/default/@lumino/domutils/@lumino/domutils\");\n/* harmony import */ var _lumino_domutils__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_lumino_domutils__WEBPACK_IMPORTED_MODULE_7__);\n/* harmony import */ var _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @lumino/dragdrop */ \"webpack/sharing/consume/default/@lumino/dragdrop/@lumino/dragdrop\");\n/* harmony import */ var _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_lumino_dragdrop__WEBPACK_IMPORTED_MODULE_8__);\n/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @lumino/messaging */ \"webpack/sharing/consume/default/@lumino/messaging/@lumino/messaging\");\n/* harmony import */ var _lumino_messaging__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_lumino_messaging__WEBPACK_IMPORTED_MODULE_9__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_10__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_11__);\n/* harmony import */ var _lumino_virtualdom__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @lumino/virtualdom */ \"webpack/sharing/consume/default/@lumino/virtualdom/@lumino/virtualdom\");\n/* harmony import */ var _lumino_virtualdom__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(_lumino_virtualdom__WEBPACK_IMPORTED_MODULE_12__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_13__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * The class name added to DirListing widget.\n */\nconst DIR_LISTING_CLASS = 'jp-DirListing';\n/**\n * The class name added to a dir listing header node.\n */\nconst HEADER_CLASS = 'jp-DirListing-header';\n/**\n * The class name added to a dir listing list header cell.\n */\nconst HEADER_ITEM_CLASS = 'jp-DirListing-headerItem';\n/**\n * The class name added to a header cell text node.\n */\nconst HEADER_ITEM_TEXT_CLASS = 'jp-DirListing-headerItemText';\n/**\n * The class name added to a header cell icon node.\n */\nconst HEADER_ITEM_ICON_CLASS = 'jp-DirListing-headerItemIcon';\n/**\n * The class name added to the dir listing content node.\n */\nconst CONTENT_CLASS = 'jp-DirListing-content';\n/**\n * The class name added to dir listing content item.\n */\nconst ITEM_CLASS = 'jp-DirListing-item';\n/**\n * The class name added to the listing item text cell.\n */\nconst ITEM_TEXT_CLASS = 'jp-DirListing-itemText';\n/**\n * The class name added to the listing item icon cell.\n */\nconst ITEM_ICON_CLASS = 'jp-DirListing-itemIcon';\n/**\n * The class name added to the listing item modified cell.\n */\nconst ITEM_MODIFIED_CLASS = 'jp-DirListing-itemModified';\n/**\n * The class name added to the dir listing editor node.\n */\nconst EDITOR_CLASS = 'jp-DirListing-editor';\n/**\n * The class name added to the name column header cell.\n */\nconst NAME_ID_CLASS = 'jp-id-name';\n/**\n * The class name added to the modified column header cell.\n */\nconst MODIFIED_ID_CLASS = 'jp-id-modified';\n/**\n * The class name added to the narrow column header cell.\n */\nconst NARROW_ID_CLASS = 'jp-id-narrow';\n/**\n * The mime type for a contents drag object.\n */\nconst CONTENTS_MIME = 'application/x-jupyter-icontents';\n/**\n * The mime type for a rich contents drag object.\n */\nconst CONTENTS_MIME_RICH = 'application/x-jupyter-icontentsrich';\n/**\n * The class name added to drop targets.\n */\nconst DROP_TARGET_CLASS = 'jp-mod-dropTarget';\n/**\n * The class name added to selected rows.\n */\nconst SELECTED_CLASS = 'jp-mod-selected';\n/**\n * The class name added to drag state icons to add space between the icon and the file name\n */\nconst DRAG_ICON_CLASS = 'jp-DragIcon';\n/**\n * The class name added to the widget when there are items on the clipboard.\n */\nconst CLIPBOARD_CLASS = 'jp-mod-clipboard';\n/**\n * The class name added to cut rows.\n */\nconst CUT_CLASS = 'jp-mod-cut';\n/**\n * The class name added when there are more than one selected rows.\n */\nconst MULTI_SELECTED_CLASS = 'jp-mod-multiSelected';\n/**\n * The class name added to indicate running notebook.\n */\nconst RUNNING_CLASS = 'jp-mod-running';\n/**\n * The class name added for a decending sort.\n */\nconst DESCENDING_CLASS = 'jp-mod-descending';\n/**\n * The maximum duration between two key presses when selecting files by prefix.\n */\nconst PREFIX_APPEND_DURATION = 1000;\n/**\n * The threshold in pixels to start a drag event.\n */\nconst DRAG_THRESHOLD = 5;\n/**\n * A boolean indicating whether the platform is Mac.\n */\nconst IS_MAC = !!navigator.platform.match(/Mac/i);\n/**\n * The factory MIME type supported by lumino dock panels.\n */\nconst FACTORY_MIME = 'application/vnd.lumino.widget-factory';\n/**\n * A widget which hosts a file list area.\n */\nclass DirListing extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_11__.Widget {\n    /**\n     * Construct a new file browser directory listing widget.\n     *\n     * @param model - The file browser view model.\n     */\n    constructor(options) {\n        super({\n            node: (options.renderer || DirListing.defaultRenderer).createNode()\n        });\n        this._items = [];\n        this._sortedItems = [];\n        this._sortState = {\n            direction: 'ascending',\n            key: 'name'\n        };\n        this._onItemOpened = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_10__.Signal(this);\n        this._drag = null;\n        this._dragData = null;\n        this._selectTimer = -1;\n        this._isCut = false;\n        this._prevPath = '';\n        this._clipboard = [];\n        this._softSelection = '';\n        this._selection = Object.create(null);\n        this._searchPrefix = '';\n        this._searchPrefixTimer = -1;\n        this._inRename = false;\n        this._isDirty = false;\n        this.addClass(DIR_LISTING_CLASS);\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_13__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._model = options.model;\n        this._model.fileChanged.connect(this._onFileChanged, this);\n        this._model.refreshed.connect(this._onModelRefreshed, this);\n        this._model.pathChanged.connect(this._onPathChanged, this);\n        this._editNode = document.createElement('input');\n        this._editNode.className = EDITOR_CLASS;\n        this._manager = this._model.manager;\n        this._renderer = options.renderer || DirListing.defaultRenderer;\n        const headerNode = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, HEADER_CLASS);\n        this._renderer.populateHeaderNode(headerNode, this.translator);\n        this._manager.activateRequested.connect(this._onActivateRequested, this);\n    }\n    /**\n     * Dispose of the resources held by the directory listing.\n     */\n    dispose() {\n        this._items.length = 0;\n        this._sortedItems.length = 0;\n        this._clipboard.length = 0;\n        super.dispose();\n    }\n    /**\n     * Get the model used by the listing.\n     */\n    get model() {\n        return this._model;\n    }\n    /**\n     * Get the dir listing header node.\n     *\n     * #### Notes\n     * This is the node which holds the header cells.\n     *\n     * Modifying this node directly can lead to undefined behavior.\n     */\n    get headerNode() {\n        return _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, HEADER_CLASS);\n    }\n    /**\n     * Get the dir listing content node.\n     *\n     * #### Notes\n     * This is the node which holds the item nodes.\n     *\n     * Modifying this node directly can lead to undefined behavior.\n     */\n    get contentNode() {\n        return _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, CONTENT_CLASS);\n    }\n    /**\n     * The renderer instance used by the directory listing.\n     */\n    get renderer() {\n        return this._renderer;\n    }\n    /**\n     * The current sort state.\n     */\n    get sortState() {\n        return this._sortState;\n    }\n    /**\n     * A signal fired when an item is opened.\n     */\n    get onItemOpened() {\n        return this._onItemOpened;\n    }\n    /**\n     * Create an iterator over the listing's selected items.\n     *\n     * @returns A new iterator over the listing's selected items.\n     */\n    selectedItems() {\n        const items = this._sortedItems;\n        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.filter)(items, item => this._selection[item.name]);\n    }\n    /**\n     * Create an iterator over the listing's sorted items.\n     *\n     * @returns A new iterator over the listing's sorted items.\n     */\n    sortedItems() {\n        return new _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayIterator(this._sortedItems);\n    }\n    /**\n     * Sort the items using a sort condition.\n     */\n    sort(state) {\n        this._sortedItems = Private.sort(this.model.items(), state);\n        this._sortState = state;\n        this.update();\n    }\n    /**\n     * Rename the first currently selected item.\n     *\n     * @returns A promise that resolves with the new name of the item.\n     */\n    rename() {\n        return this._doRename();\n    }\n    /**\n     * Cut the selected items.\n     */\n    cut() {\n        this._isCut = true;\n        this._copy();\n        this.update();\n    }\n    /**\n     * Copy the selected items.\n     */\n    copy() {\n        this._copy();\n    }\n    /**\n     * Paste the items from the clipboard.\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    paste() {\n        if (!this._clipboard.length) {\n            this._isCut = false;\n            return Promise.resolve(undefined);\n        }\n        const basePath = this._model.path;\n        const promises = [];\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.each)(this._clipboard, path => {\n            if (this._isCut) {\n                const parts = path.split('/');\n                const name = parts[parts.length - 1];\n                const newPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(basePath, name);\n                promises.push(this._model.manager.rename(path, newPath));\n            }\n            else {\n                promises.push(this._model.manager.copy(path, basePath));\n            }\n        });\n        // Remove any cut modifiers.\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.each)(this._items, item => {\n            item.classList.remove(CUT_CLASS);\n        });\n        this._clipboard.length = 0;\n        this._isCut = false;\n        this.removeClass(CLIPBOARD_CLASS);\n        return Promise.all(promises)\n            .then(() => {\n            return undefined;\n        })\n            .catch(error => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Paste Error'), error);\n        });\n    }\n    /**\n     * Delete the currently selected item(s).\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    async delete() {\n        const items = this._sortedItems.filter(item => this._selection[item.name]);\n        if (!items.length) {\n            return;\n        }\n        const message = items.length === 1\n            ? this._trans.__('Are you sure you want to permanently delete: %1?', items[0].name)\n            : this._trans._n('Are you sure you want to permanently delete the %1 selected item?', 'Are you sure you want to permanently delete the %1 selected items?', items.length);\n        const result = await (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showDialog)({\n            title: this._trans.__('Delete'),\n            body: message,\n            buttons: [\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.cancelButton({ label: this._trans.__('Cancel') }),\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.warnButton({ label: this._trans.__('Delete') })\n            ]\n        });\n        if (!this.isDisposed && result.button.accept) {\n            await this._delete(items.map(item => item.path));\n        }\n    }\n    /**\n     * Duplicate the currently selected item(s).\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    duplicate() {\n        const basePath = this._model.path;\n        const promises = [];\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.each)(this.selectedItems(), item => {\n            if (item.type !== 'directory') {\n                const oldPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(basePath, item.name);\n                promises.push(this._model.manager.copy(oldPath, basePath));\n            }\n        });\n        return Promise.all(promises)\n            .then(() => {\n            return undefined;\n        })\n            .catch(error => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Duplicate file'), error);\n        });\n    }\n    /**\n     * Download the currently selected item(s).\n     */\n    async download() {\n        await Promise.all((0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.toArray)(this.selectedItems())\n            .filter(item => item.type !== 'directory')\n            .map(item => this._model.download(item.path)));\n    }\n    /**\n     * Shut down kernels on the applicable currently selected items.\n     *\n     * @returns A promise that resolves when the operation is complete.\n     */\n    shutdownKernels() {\n        const model = this._model;\n        const items = this._sortedItems;\n        const paths = items.map(item => item.path);\n        const promises = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.toArray)(this._model.sessions())\n            .filter(session => {\n            const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.firstIndexOf(paths, session.path);\n            return this._selection[items[index].name];\n        })\n            .map(session => model.manager.services.sessions.shutdown(session.id));\n        return Promise.all(promises)\n            .then(() => {\n            return undefined;\n        })\n            .catch(error => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Shut down kernel'), error);\n        });\n    }\n    /**\n     * Select next item.\n     *\n     * @param keepExisting - Whether to keep the current selection and add to it.\n     */\n    selectNext(keepExisting = false) {\n        let index = -1;\n        const selected = Object.keys(this._selection);\n        const items = this._sortedItems;\n        if (selected.length === 1 || keepExisting) {\n            // Select the next item.\n            const name = selected[selected.length - 1];\n            index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(items, value => value.name === name);\n            index += 1;\n            if (index === this._items.length) {\n                index = 0;\n            }\n        }\n        else if (selected.length === 0) {\n            // Select the first item.\n            index = 0;\n        }\n        else {\n            // Select the last selected item.\n            const name = selected[selected.length - 1];\n            index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(items, value => value.name === name);\n        }\n        if (index !== -1) {\n            this._selectItem(index, keepExisting);\n            _lumino_domutils__WEBPACK_IMPORTED_MODULE_7__.ElementExt.scrollIntoViewIfNeeded(this.contentNode, this._items[index]);\n        }\n    }\n    /**\n     * Select previous item.\n     *\n     * @param keepExisting - Whether to keep the current selection and add to it.\n     */\n    selectPrevious(keepExisting = false) {\n        let index = -1;\n        const selected = Object.keys(this._selection);\n        const items = this._sortedItems;\n        if (selected.length === 1 || keepExisting) {\n            // Select the previous item.\n            const name = selected[0];\n            index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(items, value => value.name === name);\n            index -= 1;\n            if (index === -1) {\n                index = this._items.length - 1;\n            }\n        }\n        else if (selected.length === 0) {\n            // Select the last item.\n            index = this._items.length - 1;\n        }\n        else {\n            // Select the first selected item.\n            const name = selected[0];\n            index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(items, value => value.name === name);\n        }\n        if (index !== -1) {\n            this._selectItem(index, keepExisting);\n            _lumino_domutils__WEBPACK_IMPORTED_MODULE_7__.ElementExt.scrollIntoViewIfNeeded(this.contentNode, this._items[index]);\n        }\n    }\n    /**\n     * Select the first item that starts with prefix being typed.\n     */\n    selectByPrefix() {\n        const prefix = this._searchPrefix.toLowerCase();\n        const items = this._sortedItems;\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(items, value => {\n            return value.name.toLowerCase().substr(0, prefix.length) === prefix;\n        });\n        if (index !== -1) {\n            this._selectItem(index, false);\n            _lumino_domutils__WEBPACK_IMPORTED_MODULE_7__.ElementExt.scrollIntoViewIfNeeded(this.contentNode, this._items[index]);\n        }\n    }\n    /**\n     * Get whether an item is selected by name.\n     *\n     * @param name - The name of of the item.\n     *\n     * @returns Whether the item is selected.\n     */\n    isSelected(name) {\n        return this._selection[name] === true;\n    }\n    /**\n     * Find a model given a click.\n     *\n     * @param event - The mouse event.\n     *\n     * @returns The model for the selected file.\n     */\n    modelForClick(event) {\n        const items = this._sortedItems;\n        const index = Private.hitTestNodes(this._items, event);\n        if (index !== -1) {\n            return items[index];\n        }\n        return undefined;\n    }\n    /**\n     * Clear the selected items.\n     */\n    clearSelectedItems() {\n        this._selection = Object.create(null);\n    }\n    /**\n     * Select an item by name.\n     *\n     * @param name - The name of the item to select.\n     *\n     * @returns A promise that resolves when the name is selected.\n     */\n    async selectItemByName(name) {\n        // Make sure the file is available.\n        await this.model.refresh();\n        if (this.isDisposed) {\n            throw new Error('File browser is disposed.');\n        }\n        const items = this._sortedItems;\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(items, value => value.name === name);\n        if (index === -1) {\n            throw new Error('Item does not exist.');\n        }\n        this._selectItem(index, false);\n        _lumino_messaging__WEBPACK_IMPORTED_MODULE_9__.MessageLoop.sendMessage(this, _lumino_widgets__WEBPACK_IMPORTED_MODULE_11__.Widget.Msg.UpdateRequest);\n        _lumino_domutils__WEBPACK_IMPORTED_MODULE_7__.ElementExt.scrollIntoViewIfNeeded(this.contentNode, this._items[index]);\n    }\n    /**\n     * Handle the DOM events for the directory listing.\n     *\n     * @param event - The DOM event sent to the widget.\n     *\n     * #### Notes\n     * This method implements the DOM `EventListener` interface and is\n     * called in response to events on the panel's DOM node. It should\n     * not be called directly by user code.\n     */\n    handleEvent(event) {\n        switch (event.type) {\n            case 'mousedown':\n                this._evtMousedown(event);\n                break;\n            case 'mouseup':\n                this._evtMouseup(event);\n                break;\n            case 'mousemove':\n                this._evtMousemove(event);\n                break;\n            case 'keydown':\n                this._evtKeydown(event);\n                break;\n            case 'click':\n                this._evtClick(event);\n                break;\n            case 'dblclick':\n                this._evtDblClick(event);\n                break;\n            case 'dragenter':\n            case 'dragover':\n                this.addClass('jp-mod-native-drop');\n                event.preventDefault();\n                break;\n            case 'dragleave':\n            case 'dragend':\n                this.removeClass('jp-mod-native-drop');\n                break;\n            case 'drop':\n                this.removeClass('jp-mod-native-drop');\n                this._evtNativeDrop(event);\n                break;\n            case 'scroll':\n                this._evtScroll(event);\n                break;\n            case 'lm-dragenter':\n                this._evtDragEnter(event);\n                break;\n            case 'lm-dragleave':\n                this._evtDragLeave(event);\n                break;\n            case 'lm-dragover':\n                this._evtDragOver(event);\n                break;\n            case 'lm-drop':\n                this._evtDrop(event);\n                break;\n            default:\n                break;\n        }\n    }\n    /**\n     * A message handler invoked on an `'after-attach'` message.\n     */\n    onAfterAttach(msg) {\n        super.onAfterAttach(msg);\n        const node = this.node;\n        const content = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, CONTENT_CLASS);\n        node.addEventListener('mousedown', this);\n        node.addEventListener('keydown', this);\n        node.addEventListener('click', this);\n        node.addEventListener('dblclick', this);\n        content.addEventListener('dragenter', this);\n        content.addEventListener('dragover', this);\n        content.addEventListener('dragleave', this);\n        content.addEventListener('dragend', this);\n        content.addEventListener('drop', this);\n        content.addEventListener('scroll', this);\n        content.addEventListener('lm-dragenter', this);\n        content.addEventListener('lm-dragleave', this);\n        content.addEventListener('lm-dragover', this);\n        content.addEventListener('lm-drop', this);\n    }\n    /**\n     * A message handler invoked on a `'before-detach'` message.\n     */\n    onBeforeDetach(msg) {\n        super.onBeforeDetach(msg);\n        const node = this.node;\n        const content = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, CONTENT_CLASS);\n        node.removeEventListener('mousedown', this);\n        node.removeEventListener('keydown', this);\n        node.removeEventListener('click', this);\n        node.removeEventListener('dblclick', this);\n        content.removeEventListener('scroll', this);\n        content.removeEventListener('dragover', this);\n        content.removeEventListener('dragover', this);\n        content.removeEventListener('dragleave', this);\n        content.removeEventListener('dragend', this);\n        content.removeEventListener('drop', this);\n        content.removeEventListener('lm-dragenter', this);\n        content.removeEventListener('lm-dragleave', this);\n        content.removeEventListener('lm-dragover', this);\n        content.removeEventListener('lm-drop', this);\n        document.removeEventListener('mousemove', this, true);\n        document.removeEventListener('mouseup', this, true);\n    }\n    /**\n     * A message handler invoked on an `'after-show'` message.\n     */\n    onAfterShow(msg) {\n        if (this._isDirty) {\n            // Update the sorted items.\n            this.sort(this.sortState);\n            this.update();\n        }\n    }\n    /**\n     * A handler invoked on an `'update-request'` message.\n     */\n    onUpdateRequest(msg) {\n        this._isDirty = false;\n        // Fetch common variables.\n        const items = this._sortedItems;\n        const nodes = this._items;\n        const content = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, CONTENT_CLASS);\n        const renderer = this._renderer;\n        this.removeClass(MULTI_SELECTED_CLASS);\n        this.removeClass(SELECTED_CLASS);\n        // Remove any excess item nodes.\n        while (nodes.length > items.length) {\n            content.removeChild(nodes.pop());\n        }\n        // Add any missing item nodes.\n        while (nodes.length < items.length) {\n            const node = renderer.createItemNode();\n            node.classList.add(ITEM_CLASS);\n            nodes.push(node);\n            content.appendChild(node);\n        }\n        // Remove extra classes from the nodes.\n        nodes.forEach(item => {\n            item.classList.remove(SELECTED_CLASS);\n            item.classList.remove(RUNNING_CLASS);\n            item.classList.remove(CUT_CLASS);\n        });\n        // Add extra classes to item nodes based on widget state.\n        items.forEach((item, i) => {\n            const node = nodes[i];\n            const ft = this._manager.registry.getFileTypeForModel(item);\n            renderer.updateItemNode(node, item, ft, this.translator);\n            if (this._selection[item.name]) {\n                node.classList.add(SELECTED_CLASS);\n                if (this._isCut && this._model.path === this._prevPath) {\n                    node.classList.add(CUT_CLASS);\n                }\n            }\n            // add metadata to the node\n            node.setAttribute('data-isdir', item.type === 'directory' ? 'true' : 'false');\n        });\n        // Handle the selectors on the widget node.\n        const selected = Object.keys(this._selection).length;\n        if (selected) {\n            this.addClass(SELECTED_CLASS);\n            if (selected > 1) {\n                this.addClass(MULTI_SELECTED_CLASS);\n            }\n        }\n        // Handle file session statuses.\n        const paths = items.map(item => item.path);\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.each)(this._model.sessions(), session => {\n            var _a;\n            const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.firstIndexOf(paths, session.path);\n            const node = nodes[index];\n            // Node may have been filtered out.\n            if (node) {\n                let name = (_a = session.kernel) === null || _a === void 0 ? void 0 : _a.name;\n                const specs = this._model.specs;\n                node.classList.add(RUNNING_CLASS);\n                if (specs && name) {\n                    const spec = specs.kernelspecs[name];\n                    name = spec ? spec.display_name : 'unknown'; // FIXME-TRANS: Is this localizable?\n                }\n                node.title = this._trans.__('%1\\nKernel: %2', node.title, name);\n            }\n        });\n        this._prevPath = this._model.path;\n    }\n    onResize(msg) {\n        const { width } = msg.width === -1 ? this.node.getBoundingClientRect() : msg;\n        this.toggleClass('jp-DirListing-narrow', width < 250);\n    }\n    /**\n     * Handle the `'click'` event for the widget.\n     */\n    _evtClick(event) {\n        const target = event.target;\n        const header = this.headerNode;\n        if (header.contains(target)) {\n            const state = this.renderer.handleHeaderClick(header, event);\n            if (state) {\n                this.sort(state);\n            }\n            return;\n        }\n    }\n    /**\n     * Handle the `'scroll'` event for the widget.\n     */\n    _evtScroll(event) {\n        this.headerNode.scrollLeft = this.contentNode.scrollLeft;\n    }\n    /**\n     * Handle the `'mousedown'` event for the widget.\n     */\n    _evtMousedown(event) {\n        // Bail if clicking within the edit node\n        if (event.target === this._editNode) {\n            return;\n        }\n        // Blur the edit node if necessary.\n        if (this._editNode.parentNode) {\n            if (this._editNode !== event.target) {\n                this._editNode.focus();\n                this._editNode.blur();\n                clearTimeout(this._selectTimer);\n            }\n            else {\n                return;\n            }\n        }\n        let index = Private.hitTestNodes(this._items, event);\n        if (index === -1) {\n            return;\n        }\n        this._handleFileSelect(event);\n        if (event.button !== 0) {\n            clearTimeout(this._selectTimer);\n        }\n        // Check for clearing a context menu.\n        const newContext = (IS_MAC && event.ctrlKey) || event.button === 2;\n        if (newContext) {\n            return;\n        }\n        // Left mouse press for drag start.\n        if (event.button === 0) {\n            this._dragData = {\n                pressX: event.clientX,\n                pressY: event.clientY,\n                index: index\n            };\n            document.addEventListener('mouseup', this, true);\n            document.addEventListener('mousemove', this, true);\n        }\n    }\n    /**\n     * Handle the `'mouseup'` event for the widget.\n     */\n    _evtMouseup(event) {\n        // Handle any soft selection from the previous mouse down.\n        if (this._softSelection) {\n            const altered = event.metaKey || event.shiftKey || event.ctrlKey;\n            // See if we need to clear the other selection.\n            if (!altered && event.button === 0) {\n                this.clearSelectedItems();\n                this._selection[this._softSelection] = true;\n                this.update();\n            }\n            this._softSelection = '';\n        }\n        // Remove the drag listeners if necessary.\n        if (event.button !== 0 || !this._drag) {\n            document.removeEventListener('mousemove', this, true);\n            document.removeEventListener('mouseup', this, true);\n            return;\n        }\n        event.preventDefault();\n        event.stopPropagation();\n    }\n    /**\n     * Handle the `'mousemove'` event for the widget.\n     */\n    _evtMousemove(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        // Bail if we are the one dragging.\n        if (this._drag || !this._dragData) {\n            return;\n        }\n        // Check for a drag initialization.\n        const data = this._dragData;\n        const dx = Math.abs(event.clientX - data.pressX);\n        const dy = Math.abs(event.clientY - data.pressY);\n        if (dx < DRAG_THRESHOLD && dy < DRAG_THRESHOLD) {\n            return;\n        }\n        this._startDrag(data.index, event.clientX, event.clientY);\n    }\n    /**\n     * Handle the opening of an item.\n     */\n    _handleOpen(item) {\n        this._onItemOpened.emit(item);\n        if (item.type === 'directory') {\n            const localPath = this._manager.services.contents.localPath(item.path);\n            this._model\n                .cd(`/${localPath}`)\n                .catch(error => (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Open directory'), error));\n        }\n        else {\n            const path = item.path;\n            this._manager.openOrReveal(path);\n        }\n    }\n    /**\n     * Handle the `'keydown'` event for the widget.\n     */\n    _evtKeydown(event) {\n        switch (event.keyCode) {\n            case 13: {\n                // Enter\n                // Do nothing if any modifier keys are pressed.\n                if (event.ctrlKey || event.shiftKey || event.altKey || event.metaKey) {\n                    return;\n                }\n                event.preventDefault();\n                event.stopPropagation();\n                const selected = Object.keys(this._selection);\n                const name = selected[0];\n                const items = this._sortedItems;\n                const i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(items, value => value.name === name);\n                if (i === -1) {\n                    return;\n                }\n                const item = this._sortedItems[i];\n                this._handleOpen(item);\n                break;\n            }\n            case 38: // Up arrow\n                this.selectPrevious(event.shiftKey);\n                event.stopPropagation();\n                event.preventDefault();\n                break;\n            case 40: // Down arrow\n                this.selectNext(event.shiftKey);\n                event.stopPropagation();\n                event.preventDefault();\n                break;\n            default:\n                break;\n        }\n        // Detects printable characters typed by the user.\n        // Not all browsers support .key, but it discharges us from reconstructing\n        // characters from key codes.\n        if (!this._inRename && event.key !== undefined && event.key.length === 1) {\n            this._searchPrefix += event.key;\n            clearTimeout(this._searchPrefixTimer);\n            this._searchPrefixTimer = window.setTimeout(() => {\n                this._searchPrefix = '';\n            }, PREFIX_APPEND_DURATION);\n            this.selectByPrefix();\n            event.stopPropagation();\n            event.preventDefault();\n        }\n    }\n    /**\n     * Handle the `'dblclick'` event for the widget.\n     */\n    _evtDblClick(event) {\n        // Do nothing if it's not a left mouse press.\n        if (event.button !== 0) {\n            return;\n        }\n        // Do nothing if any modifier keys are pressed.\n        if (event.ctrlKey || event.shiftKey || event.altKey || event.metaKey) {\n            return;\n        }\n        // Stop the event propagation.\n        event.preventDefault();\n        event.stopPropagation();\n        clearTimeout(this._selectTimer);\n        this._editNode.blur();\n        // Find a valid double click target.\n        const target = event.target;\n        const i = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(this._items, node => node.contains(target));\n        if (i === -1) {\n            return;\n        }\n        const item = this._sortedItems[i];\n        this._handleOpen(item);\n    }\n    /**\n     * Handle the `drop` event for the widget.\n     */\n    _evtNativeDrop(event) {\n        var _a;\n        const files = (_a = event.dataTransfer) === null || _a === void 0 ? void 0 : _a.files;\n        if (!files || files.length === 0) {\n            return;\n        }\n        event.preventDefault();\n        for (let i = 0; i < files.length; i++) {\n            void this._model.upload(files[i]);\n        }\n    }\n    /**\n     * Handle the `'lm-dragenter'` event for the widget.\n     */\n    _evtDragEnter(event) {\n        if (event.mimeData.hasData(CONTENTS_MIME)) {\n            const index = Private.hitTestNodes(this._items, event);\n            if (index === -1) {\n                return;\n            }\n            const item = this._sortedItems[index];\n            if (item.type !== 'directory' || this._selection[item.name]) {\n                return;\n            }\n            const target = event.target;\n            target.classList.add(DROP_TARGET_CLASS);\n            event.preventDefault();\n            event.stopPropagation();\n        }\n    }\n    /**\n     * Handle the `'lm-dragleave'` event for the widget.\n     */\n    _evtDragLeave(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        const dropTarget = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, DROP_TARGET_CLASS);\n        if (dropTarget) {\n            dropTarget.classList.remove(DROP_TARGET_CLASS);\n        }\n    }\n    /**\n     * Handle the `'lm-dragover'` event for the widget.\n     */\n    _evtDragOver(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        event.dropAction = event.proposedAction;\n        const dropTarget = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(this.node, DROP_TARGET_CLASS);\n        if (dropTarget) {\n            dropTarget.classList.remove(DROP_TARGET_CLASS);\n        }\n        const index = Private.hitTestNodes(this._items, event);\n        this._items[index].classList.add(DROP_TARGET_CLASS);\n    }\n    /**\n     * Handle the `'lm-drop'` event for the widget.\n     */\n    _evtDrop(event) {\n        event.preventDefault();\n        event.stopPropagation();\n        clearTimeout(this._selectTimer);\n        if (event.proposedAction === 'none') {\n            event.dropAction = 'none';\n            return;\n        }\n        if (!event.mimeData.hasData(CONTENTS_MIME)) {\n            return;\n        }\n        let target = event.target;\n        while (target && target.parentElement) {\n            if (target.classList.contains(DROP_TARGET_CLASS)) {\n                target.classList.remove(DROP_TARGET_CLASS);\n                break;\n            }\n            target = target.parentElement;\n        }\n        // Get the path based on the target node.\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.firstIndexOf(this._items, target);\n        const items = this._sortedItems;\n        let basePath = this._model.path;\n        if (items[index].type === 'directory') {\n            basePath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(basePath, items[index].name);\n        }\n        const manager = this._manager;\n        // Handle the items.\n        const promises = [];\n        const paths = event.mimeData.getData(CONTENTS_MIME);\n        if (event.ctrlKey && event.proposedAction === 'move') {\n            event.dropAction = 'copy';\n        }\n        else {\n            event.dropAction = event.proposedAction;\n        }\n        for (const path of paths) {\n            const localPath = manager.services.contents.localPath(path);\n            const name = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.basename(localPath);\n            const newPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(basePath, name);\n            // Skip files that are not moving.\n            if (newPath === path) {\n                continue;\n            }\n            if (event.dropAction === 'copy') {\n                promises.push(manager.copy(path, basePath));\n            }\n            else {\n                promises.push((0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.renameFile)(manager, path, newPath));\n            }\n        }\n        Promise.all(promises).catch(error => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Error while copying/moving files'), error);\n        });\n    }\n    /**\n     * Start a drag event.\n     */\n    _startDrag(index, clientX, clientY) {\n        let selectedNames = Object.keys(this._selection);\n        const source = this._items[index];\n        const items = this._sortedItems;\n        let selectedItems;\n        let item;\n        // If the source node is not selected, use just that node.\n        if (!source.classList.contains(SELECTED_CLASS)) {\n            item = items[index];\n            selectedNames = [item.name];\n            selectedItems = [item];\n        }\n        else {\n            const name = selectedNames[0];\n            item = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.find)(items, value => value.name === name);\n            selectedItems = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.toArray)(this.selectedItems());\n        }\n        if (!item) {\n            return;\n        }\n        // Create the drag image.\n        const ft = this._manager.registry.getFileTypeForModel(item);\n        const dragImage = this.renderer.createDragImage(source, selectedNames.length, this._trans, ft);\n        // Set up the drag event.\n        this._drag = new _lumino_dragdrop__WEBPACK_IMPORTED_MODULE_8__.Drag({\n            dragImage,\n            mimeData: new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_6__.MimeData(),\n            supportedActions: 'move',\n            proposedAction: 'move'\n        });\n        const basePath = this._model.path;\n        const paths = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.toArray)((0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.map)(selectedNames, name => {\n            return _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(basePath, name);\n        }));\n        this._drag.mimeData.setData(CONTENTS_MIME, paths);\n        // Add thunks for getting mime data content.\n        // We thunk the content so we don't try to make a network call\n        // when it's not needed. E.g. just moving files around\n        // in a filebrowser\n        const services = this.model.manager.services;\n        for (const item of selectedItems) {\n            this._drag.mimeData.setData(CONTENTS_MIME_RICH, {\n                model: item,\n                withContent: async () => {\n                    return await services.contents.get(item.path);\n                }\n            });\n        }\n        if (item && item.type !== 'directory') {\n            const otherPaths = paths.slice(1).reverse();\n            this._drag.mimeData.setData(FACTORY_MIME, () => {\n                if (!item) {\n                    return;\n                }\n                const path = item.path;\n                let widget = this._manager.findWidget(path);\n                if (!widget) {\n                    widget = this._manager.open(item.path);\n                }\n                if (otherPaths.length) {\n                    const firstWidgetPlaced = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_6__.PromiseDelegate();\n                    void firstWidgetPlaced.promise.then(() => {\n                        let prevWidget = widget;\n                        otherPaths.forEach(path => {\n                            const options = {\n                                ref: prevWidget === null || prevWidget === void 0 ? void 0 : prevWidget.id,\n                                mode: 'tab-after'\n                            };\n                            prevWidget = this._manager.openOrReveal(path, void 0, void 0, options);\n                            this._manager.openOrReveal(item.path);\n                        });\n                    });\n                    firstWidgetPlaced.resolve(void 0);\n                }\n                return widget;\n            });\n        }\n        // Start the drag and remove the mousemove and mouseup listeners.\n        document.removeEventListener('mousemove', this, true);\n        document.removeEventListener('mouseup', this, true);\n        clearTimeout(this._selectTimer);\n        void this._drag.start(clientX, clientY).then(action => {\n            this._drag = null;\n            clearTimeout(this._selectTimer);\n        });\n    }\n    /**\n     * Handle selection on a file node.\n     */\n    _handleFileSelect(event) {\n        // Fetch common variables.\n        const items = this._sortedItems;\n        const index = Private.hitTestNodes(this._items, event);\n        clearTimeout(this._selectTimer);\n        if (index === -1) {\n            return;\n        }\n        // Clear any existing soft selection.\n        this._softSelection = '';\n        const name = items[index].name;\n        const selected = Object.keys(this._selection);\n        // Handle toggling.\n        if ((IS_MAC && event.metaKey) || (!IS_MAC && event.ctrlKey)) {\n            if (this._selection[name]) {\n                delete this._selection[name];\n            }\n            else {\n                this._selection[name] = true;\n            }\n            // Handle multiple select.\n        }\n        else if (event.shiftKey) {\n            this._handleMultiSelect(selected, index);\n            // Handle a 'soft' selection\n        }\n        else if (name in this._selection && selected.length > 1) {\n            this._softSelection = name;\n            // Default to selecting the only the item.\n        }\n        else {\n            // Select only the given item.\n            this.clearSelectedItems();\n            this._selection[name] = true;\n        }\n        this.update();\n    }\n    /**\n     * Handle a multiple select on a file item node.\n     */\n    _handleMultiSelect(selected, index) {\n        // Find the \"nearest selected\".\n        const items = this._sortedItems;\n        let nearestIndex = -1;\n        for (let i = 0; i < this._items.length; i++) {\n            if (i === index) {\n                continue;\n            }\n            const name = items[i].name;\n            if (selected.indexOf(name) !== -1) {\n                if (nearestIndex === -1) {\n                    nearestIndex = i;\n                }\n                else {\n                    if (Math.abs(index - i) < Math.abs(nearestIndex - i)) {\n                        nearestIndex = i;\n                    }\n                }\n            }\n        }\n        // Default to the first element (and fill down).\n        if (nearestIndex === -1) {\n            nearestIndex = 0;\n        }\n        // Select the rows between the current and the nearest selected.\n        for (let i = 0; i < this._items.length; i++) {\n            if ((nearestIndex >= i && index <= i) ||\n                (nearestIndex <= i && index >= i)) {\n                this._selection[items[i].name] = true;\n            }\n        }\n    }\n    /**\n     * Copy the selected items, and optionally cut as well.\n     */\n    _copy() {\n        this._clipboard.length = 0;\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.each)(this.selectedItems(), item => {\n            this._clipboard.push(item.path);\n        });\n    }\n    /**\n     * Delete the files with the given paths.\n     */\n    async _delete(paths) {\n        await Promise.all(paths.map(path => this._model.manager.deleteFile(path).catch(err => {\n            void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Delete Failed'), err);\n        })));\n    }\n    /**\n     * Allow the user to rename item on a given row.\n     */\n    _doRename() {\n        this._inRename = true;\n        const items = this._sortedItems;\n        const name = Object.keys(this._selection)[0];\n        const index = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(items, value => value.name === name);\n        const row = this._items[index];\n        const item = items[index];\n        const nameNode = this.renderer.getNameNode(row);\n        const original = item.name;\n        this._editNode.value = original;\n        this._selectItem(index, false);\n        return Private.doRename(nameNode, this._editNode).then(newName => {\n            this.node.focus();\n            if (!newName || newName === original) {\n                this._inRename = false;\n                return original;\n            }\n            if (!(0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.isValidFileName)(newName)) {\n                void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans.__('showErrorMessage', 'Rename Error'), Error(this._trans._p('showErrorMessage', '\"%1\" is not a valid name for a file. Names must have nonzero length, and cannot include \"/\", \"\\\\\", or \":\"', newName)));\n                this._inRename = false;\n                return original;\n            }\n            if (this.isDisposed) {\n                this._inRename = false;\n                throw new Error('File browser is disposed.');\n            }\n            const manager = this._manager;\n            const oldPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(this._model.path, original);\n            const newPath = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.join(this._model.path, newName);\n            const promise = (0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.renameFile)(manager, oldPath, newPath);\n            return promise\n                .catch(error => {\n                if (error !== 'File not renamed') {\n                    void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Rename Error'), error);\n                }\n                this._inRename = false;\n                return original;\n            })\n                .then(() => {\n                if (this.isDisposed) {\n                    this._inRename = false;\n                    throw new Error('File browser is disposed.');\n                }\n                if (this._inRename) {\n                    // No need to catch because `newName` will always exit.\n                    void this.selectItemByName(newName);\n                }\n                this._inRename = false;\n                return newName;\n            });\n        });\n    }\n    /**\n     * Select a given item.\n     */\n    _selectItem(index, keepExisting) {\n        // Selected the given row(s)\n        const items = this._sortedItems;\n        if (!keepExisting) {\n            this.clearSelectedItems();\n        }\n        const name = items[index].name;\n        this._selection[name] = true;\n        this.update();\n    }\n    /**\n     * Handle the `refreshed` signal from the model.\n     */\n    _onModelRefreshed() {\n        // Update the selection.\n        const existing = Object.keys(this._selection);\n        this.clearSelectedItems();\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.each)(this._model.items(), item => {\n            const name = item.name;\n            if (existing.indexOf(name) !== -1) {\n                this._selection[name] = true;\n            }\n        });\n        if (this.isVisible) {\n            // Update the sorted items.\n            this.sort(this.sortState);\n        }\n        else {\n            this._isDirty = true;\n        }\n    }\n    /**\n     * Handle a `pathChanged` signal from the model.\n     */\n    _onPathChanged() {\n        // Reset the selection.\n        this.clearSelectedItems();\n        // Update the sorted items.\n        this.sort(this.sortState);\n    }\n    /**\n     * Handle a `fileChanged` signal from the model.\n     */\n    _onFileChanged(sender, args) {\n        const newValue = args.newValue;\n        if (!newValue) {\n            return;\n        }\n        const name = newValue.name;\n        if (args.type !== 'new' || !name) {\n            return;\n        }\n        void this.selectItemByName(name)\n            .then(() => {\n            if (!this.isDisposed && newValue.type === 'directory') {\n                return this._doRename();\n            }\n        })\n            .catch(() => {\n            /* Ignore if file does not exist. */\n        });\n    }\n    /**\n     * Handle an `activateRequested` signal from the manager.\n     */\n    _onActivateRequested(sender, args) {\n        const dirname = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.dirname(args);\n        if (dirname !== this._model.path) {\n            return;\n        }\n        const basename = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.basename(args);\n        this.selectItemByName(basename).catch(() => {\n            /* Ignore if file does not exist. */\n        });\n    }\n}\n/**\n * The namespace for the `DirListing` class statics.\n */\n(function (DirListing) {\n    /**\n     * The default implementation of an `IRenderer`.\n     */\n    class Renderer {\n        /**\n         * Create the DOM node for a dir listing.\n         */\n        createNode() {\n            const node = document.createElement('div');\n            const header = document.createElement('div');\n            const content = document.createElement('ul');\n            content.className = CONTENT_CLASS;\n            header.className = HEADER_CLASS;\n            node.appendChild(header);\n            node.appendChild(content);\n            node.tabIndex = 1;\n            return node;\n        }\n        /**\n         * Populate and empty header node for a dir listing.\n         *\n         * @param node - The header node to populate.\n         */\n        populateHeaderNode(node, translator) {\n            translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_13__.nullTranslator;\n            const trans = translator.load('jupyterlab');\n            const name = this._createHeaderItemNode(trans.__('Name'));\n            const narrow = document.createElement('div');\n            const modified = this._createHeaderItemNode(trans.__('Last Modified'));\n            name.classList.add(NAME_ID_CLASS);\n            name.classList.add(SELECTED_CLASS);\n            modified.classList.add(MODIFIED_ID_CLASS);\n            narrow.classList.add(NARROW_ID_CLASS);\n            narrow.textContent = '...';\n            node.appendChild(name);\n            node.appendChild(narrow);\n            node.appendChild(modified);\n            // set the initial caret icon\n            Private.updateCaret(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(name, HEADER_ITEM_ICON_CLASS), 'right', 'up');\n        }\n        /**\n         * Handle a header click.\n         *\n         * @param node - A node populated by [[populateHeaderNode]].\n         *\n         * @param event - A click event on the node.\n         *\n         * @returns The sort state of the header after the click event.\n         */\n        handleHeaderClick(node, event) {\n            const name = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, NAME_ID_CLASS);\n            const modified = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, MODIFIED_ID_CLASS);\n            const state = { direction: 'ascending', key: 'name' };\n            const target = event.target;\n            if (name.contains(target)) {\n                const modifiedIcon = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(modified, HEADER_ITEM_ICON_CLASS);\n                const nameIcon = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(name, HEADER_ITEM_ICON_CLASS);\n                if (name.classList.contains(SELECTED_CLASS)) {\n                    if (!name.classList.contains(DESCENDING_CLASS)) {\n                        state.direction = 'descending';\n                        name.classList.add(DESCENDING_CLASS);\n                        Private.updateCaret(nameIcon, 'right', 'down');\n                    }\n                    else {\n                        name.classList.remove(DESCENDING_CLASS);\n                        Private.updateCaret(nameIcon, 'right', 'up');\n                    }\n                }\n                else {\n                    name.classList.remove(DESCENDING_CLASS);\n                    Private.updateCaret(nameIcon, 'right', 'up');\n                }\n                name.classList.add(SELECTED_CLASS);\n                modified.classList.remove(SELECTED_CLASS);\n                modified.classList.remove(DESCENDING_CLASS);\n                Private.updateCaret(modifiedIcon, 'left');\n                return state;\n            }\n            if (modified.contains(target)) {\n                const modifiedIcon = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(modified, HEADER_ITEM_ICON_CLASS);\n                const nameIcon = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(name, HEADER_ITEM_ICON_CLASS);\n                state.key = 'last_modified';\n                if (modified.classList.contains(SELECTED_CLASS)) {\n                    if (!modified.classList.contains(DESCENDING_CLASS)) {\n                        state.direction = 'descending';\n                        modified.classList.add(DESCENDING_CLASS);\n                        Private.updateCaret(modifiedIcon, 'left', 'down');\n                    }\n                    else {\n                        modified.classList.remove(DESCENDING_CLASS);\n                        Private.updateCaret(modifiedIcon, 'left', 'up');\n                    }\n                }\n                else {\n                    modified.classList.remove(DESCENDING_CLASS);\n                    Private.updateCaret(modifiedIcon, 'left', 'up');\n                }\n                modified.classList.add(SELECTED_CLASS);\n                name.classList.remove(SELECTED_CLASS);\n                name.classList.remove(DESCENDING_CLASS);\n                Private.updateCaret(nameIcon, 'right');\n                return state;\n            }\n            return state;\n        }\n        /**\n         * Create a new item node for a dir listing.\n         *\n         * @returns A new DOM node to use as a content item.\n         */\n        createItemNode() {\n            const node = document.createElement('li');\n            const icon = document.createElement('span');\n            const text = document.createElement('span');\n            const modified = document.createElement('span');\n            icon.className = ITEM_ICON_CLASS;\n            text.className = ITEM_TEXT_CLASS;\n            modified.className = ITEM_MODIFIED_CLASS;\n            node.appendChild(icon);\n            node.appendChild(text);\n            node.appendChild(modified);\n            return node;\n        }\n        /**\n         * Update an item node to reflect the current state of a model.\n         *\n         * @param node - A node created by [[createItemNode]].\n         *\n         * @param model - The model object to use for the item state.\n         *\n         * @param fileType - The file type of the item, if applicable.\n         *\n         */\n        updateItemNode(node, model, fileType, translator) {\n            translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_13__.nullTranslator;\n            fileType =\n                fileType || _jupyterlab_docregistry__WEBPACK_IMPORTED_MODULE_3__.DocumentRegistry.getDefaultTextFileType(translator);\n            const { icon, iconClass, name } = fileType;\n            translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_13__.nullTranslator;\n            const trans = translator.load('jupyterlab');\n            const iconContainer = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_ICON_CLASS);\n            const text = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_TEXT_CLASS);\n            const modified = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_MODIFIED_CLASS);\n            // render the file item's icon\n            _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.LabIcon.resolveElement({\n                icon,\n                iconClass: (0,_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.classes)(iconClass, 'jp-Icon'),\n                container: iconContainer,\n                className: ITEM_ICON_CLASS,\n                stylesheet: 'listing'\n            });\n            let hoverText = trans.__('Name: %1', model.name);\n            // add file size to pop up if its available\n            if (model.size !== null && model.size !== undefined) {\n                hoverText += trans.__('\\nSize: %1', Private.formatFileSize(model.size, 1, 1024));\n            }\n            if (model.path) {\n                const dirname = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.dirname(model.path);\n                if (dirname) {\n                    hoverText += trans.__('\\nPath: %1', dirname.substr(0, 50));\n                    if (dirname.length > 50) {\n                        hoverText += '...';\n                    }\n                }\n            }\n            if (model.created) {\n                hoverText += trans.__('\\nCreated: %1', _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Time.format(new Date(model.created), 'YYYY-MM-DD HH:mm:ss'));\n            }\n            if (model.last_modified) {\n                hoverText += trans.__('\\nModified: %1', _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Time.format(new Date(model.last_modified), 'YYYY-MM-DD HH:mm:ss'));\n            }\n            hoverText += trans.__('\\nWritable: %1', model.writable);\n            node.title = hoverText;\n            node.setAttribute('data-file-type', name);\n            if (model.name.startsWith('.')) {\n                node.setAttribute('data-is-dot', 'true');\n            }\n            else {\n                node.removeAttribute('data-is-dot');\n            }\n            // If an item is being edited currently, its text node is unavailable.\n            if (text) {\n                const indices = !model.indices ? [] : model.indices;\n                let highlightedName = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.StringExt.highlight(model.name, indices, _lumino_virtualdom__WEBPACK_IMPORTED_MODULE_12__.h.mark);\n                _lumino_virtualdom__WEBPACK_IMPORTED_MODULE_12__.VirtualDOM.render(_lumino_virtualdom__WEBPACK_IMPORTED_MODULE_12__.h.span(highlightedName), text);\n            }\n            let modText = '';\n            let modTitle = '';\n            if (model.last_modified) {\n                modText = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Time.formatHuman(new Date(model.last_modified));\n                modTitle = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.Time.format(new Date(model.last_modified), 'lll');\n            }\n            modified.textContent = modText;\n            modified.title = modTitle;\n        }\n        /**\n         * Get the node containing the file name.\n         *\n         * @param node - A node created by [[createItemNode]].\n         *\n         * @returns The node containing the file name.\n         */\n        getNameNode(node) {\n            return _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(node, ITEM_TEXT_CLASS);\n        }\n        /**\n         * Create a drag image for an item.\n         *\n         * @param node - A node created by [[createItemNode]].\n         *\n         * @param count - The number of items being dragged.\n         *\n         * @param fileType - The file type of the item, if applicable.\n         *\n         * @returns An element to use as the drag image.\n         */\n        createDragImage(node, count, trans, fileType) {\n            const dragImage = node.cloneNode(true);\n            const modified = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(dragImage, ITEM_MODIFIED_CLASS);\n            const icon = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(dragImage, ITEM_ICON_CLASS);\n            dragImage.removeChild(modified);\n            if (!fileType) {\n                icon.textContent = '';\n                icon.className = '';\n            }\n            else {\n                icon.textContent = fileType.iconLabel || '';\n                icon.className = fileType.iconClass || '';\n            }\n            icon.classList.add(DRAG_ICON_CLASS);\n            if (count > 1) {\n                const nameNode = _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.DOMUtils.findElement(dragImage, ITEM_TEXT_CLASS);\n                nameNode.textContent = trans._n('%1 Item', '%1 Items', count);\n            }\n            return dragImage;\n        }\n        /**\n         * Create a node for a header item.\n         */\n        _createHeaderItemNode(label) {\n            const node = document.createElement('div');\n            const text = document.createElement('span');\n            const icon = document.createElement('span');\n            node.className = HEADER_ITEM_CLASS;\n            text.className = HEADER_ITEM_TEXT_CLASS;\n            icon.className = HEADER_ITEM_ICON_CLASS;\n            text.textContent = label;\n            node.appendChild(text);\n            node.appendChild(icon);\n            return node;\n        }\n    }\n    DirListing.Renderer = Renderer;\n    /**\n     * The default `IRenderer` instance.\n     */\n    DirListing.defaultRenderer = new Renderer();\n})(DirListing || (DirListing = {}));\n/**\n * The namespace for the listing private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Handle editing text on a node.\n     *\n     * @returns Boolean indicating whether the name changed.\n     */\n    function doRename(text, edit) {\n        const parent = text.parentElement;\n        parent.replaceChild(edit, text);\n        edit.focus();\n        const index = edit.value.lastIndexOf('.');\n        if (index === -1) {\n            edit.setSelectionRange(0, edit.value.length);\n        }\n        else {\n            edit.setSelectionRange(0, index);\n        }\n        return new Promise((resolve, reject) => {\n            edit.onblur = () => {\n                parent.replaceChild(text, edit);\n                resolve(edit.value);\n            };\n            edit.onkeydown = (event) => {\n                switch (event.keyCode) {\n                    case 13: // Enter\n                        event.stopPropagation();\n                        event.preventDefault();\n                        edit.blur();\n                        break;\n                    case 27: // Escape\n                        event.stopPropagation();\n                        event.preventDefault();\n                        edit.blur();\n                        break;\n                    case 38: // Up arrow\n                        event.stopPropagation();\n                        event.preventDefault();\n                        if (edit.selectionStart !== edit.selectionEnd) {\n                            edit.selectionStart = edit.selectionEnd = 0;\n                        }\n                        break;\n                    case 40: // Down arrow\n                        event.stopPropagation();\n                        event.preventDefault();\n                        if (edit.selectionStart !== edit.selectionEnd) {\n                            edit.selectionStart = edit.selectionEnd = edit.value.length;\n                        }\n                        break;\n                    default:\n                        break;\n                }\n            };\n        });\n    }\n    Private.doRename = doRename;\n    /**\n     * Sort a list of items by sort state as a new array.\n     */\n    function sort(items, state) {\n        const copy = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.toArray)(items);\n        const reverse = state.direction === 'descending' ? 1 : -1;\n        if (state.key === 'last_modified') {\n            // Sort by last modified (grouping directories first)\n            copy.sort((a, b) => {\n                const t1 = a.type === 'directory' ? 0 : 1;\n                const t2 = b.type === 'directory' ? 0 : 1;\n                const valA = new Date(a.last_modified).getTime();\n                const valB = new Date(b.last_modified).getTime();\n                return t1 - t2 || (valA - valB) * reverse;\n            });\n        }\n        else {\n            // Sort by name (grouping directories first)\n            copy.sort((a, b) => {\n                const t1 = a.type === 'directory' ? 0 : 1;\n                const t2 = b.type === 'directory' ? 0 : 1;\n                return t1 - t2 || b.name.localeCompare(a.name) * reverse;\n            });\n        }\n        return copy;\n    }\n    Private.sort = sort;\n    /**\n     * Get the index of the node at a client position, or `-1`.\n     */\n    function hitTestNodes(nodes, event) {\n        return _lumino_algorithm__WEBPACK_IMPORTED_MODULE_5__.ArrayExt.findFirstIndex(nodes, node => _lumino_domutils__WEBPACK_IMPORTED_MODULE_7__.ElementExt.hitTest(node, event.clientX, event.clientY) ||\n            event.target === node);\n    }\n    Private.hitTestNodes = hitTestNodes;\n    /**\n     * Format bytes to human readable string.\n     */\n    function formatFileSize(bytes, decimalPoint, k) {\n        // https://www.codexworld.com/how-to/convert-file-size-bytes-kb-mb-gb-javascript/\n        if (bytes === 0) {\n            return '0 Bytes';\n        }\n        const dm = decimalPoint || 2;\n        const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];\n        const i = Math.floor(Math.log(bytes) / Math.log(k));\n        if (i >= 0 && i < sizes.length) {\n            return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];\n        }\n        else {\n            return String(bytes);\n        }\n    }\n    Private.formatFileSize = formatFileSize;\n    /**\n     * Update an inline svg caret icon in a node.\n     */\n    function updateCaret(container, float, state) {\n        if (state) {\n            (state === 'down' ? _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.caretDownIcon : _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.caretUpIcon).element({\n                container,\n                tag: 'span',\n                stylesheet: 'listingHeaderItem',\n                float\n            });\n        }\n        else {\n            _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_4__.LabIcon.remove(container);\n            container.className = HEADER_ITEM_ICON_CLASS;\n        }\n    }\n    Private.updateCaret = updateCaret;\n})(Private || (Private = {}));\n//# sourceMappingURL=listing.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/listing.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/model.js":
/*!************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/model.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"LARGE_FILE_SIZE\": () => (/* binding */ LARGE_FILE_SIZE),\n/* harmony export */   \"CHUNK_SIZE\": () => (/* binding */ CHUNK_SIZE),\n/* harmony export */   \"FileBrowserModel\": () => (/* binding */ FileBrowserModel),\n/* harmony export */   \"FilterFileBrowserModel\": () => (/* binding */ FilterFileBrowserModel)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/docmanager */ \"webpack/sharing/consume/default/@jupyterlab/docmanager/@jupyterlab/docmanager\");\n/* harmony import */ var _jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @lumino/polling */ \"webpack/sharing/consume/default/@lumino/polling/@lumino/polling\");\n/* harmony import */ var _lumino_polling__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_lumino_polling__WEBPACK_IMPORTED_MODULE_5__);\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @lumino/signaling */ \"webpack/sharing/consume/default/@lumino/signaling/@lumino/signaling\");\n/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_6__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_7__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n\n/**\n * The default duration of the auto-refresh in ms\n */\nconst DEFAULT_REFRESH_INTERVAL = 10000;\n/**\n * The maximum upload size (in bytes) for notebook version < 5.1.0\n */\nconst LARGE_FILE_SIZE = 15 * 1024 * 1024;\n/**\n * The size (in bytes) of the biggest chunk we should upload at once.\n */\nconst CHUNK_SIZE = 1024 * 1024;\n/**\n * An implementation of a file browser model.\n *\n * #### Notes\n * All paths parameters without a leading `'/'` are interpreted as relative to\n * the current directory.  Supports `'../'` syntax.\n */\nclass FileBrowserModel {\n    /**\n     * Construct a new file browser model.\n     */\n    constructor(options) {\n        var _a;\n        this._connectionFailure = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);\n        this._fileChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);\n        this._items = [];\n        this._key = '';\n        this._pathChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);\n        this._paths = new Set();\n        this._pending = null;\n        this._pendingPath = null;\n        this._refreshed = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);\n        this._sessions = [];\n        this._state = null;\n        this._isDisposed = false;\n        this._restored = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_4__.PromiseDelegate();\n        this._uploads = [];\n        this._uploadChanged = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal(this);\n        this.manager = options.manager;\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_7__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._driveName = options.driveName || '';\n        const rootPath = this._driveName ? this._driveName + ':' : '';\n        this._model = {\n            path: rootPath,\n            name: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.basename(rootPath),\n            type: 'directory',\n            content: undefined,\n            writable: false,\n            created: 'unknown',\n            last_modified: 'unknown',\n            mimetype: 'text/plain',\n            format: 'text'\n        };\n        this._state = options.state || null;\n        const refreshInterval = options.refreshInterval || DEFAULT_REFRESH_INTERVAL;\n        const { services } = options.manager;\n        services.contents.fileChanged.connect(this._onFileChanged, this);\n        services.sessions.runningChanged.connect(this._onRunningChanged, this);\n        this._unloadEventListener = (e) => {\n            if (this._uploads.length > 0) {\n                const confirmationMessage = this._trans.__('Files still uploading');\n                e.returnValue = confirmationMessage;\n                return confirmationMessage;\n            }\n        };\n        window.addEventListener('beforeunload', this._unloadEventListener);\n        this._poll = new _lumino_polling__WEBPACK_IMPORTED_MODULE_5__.Poll({\n            auto: (_a = options.auto) !== null && _a !== void 0 ? _a : true,\n            name: '@jupyterlab/filebrowser:Model',\n            factory: () => this.cd('.'),\n            frequency: {\n                interval: refreshInterval,\n                backoff: true,\n                max: 300 * 1000\n            },\n            standby: 'when-hidden'\n        });\n    }\n    /**\n     * A signal emitted when the file browser model loses connection.\n     */\n    get connectionFailure() {\n        return this._connectionFailure;\n    }\n    /**\n     * The drive name that gets prepended to the path.\n     */\n    get driveName() {\n        return this._driveName;\n    }\n    /**\n     * A promise that resolves when the model is first restored.\n     */\n    get restored() {\n        return this._restored.promise;\n    }\n    /**\n     * Get the file path changed signal.\n     */\n    get fileChanged() {\n        return this._fileChanged;\n    }\n    /**\n     * Get the current path.\n     */\n    get path() {\n        return this._model ? this._model.path : '';\n    }\n    /**\n     * A signal emitted when the path changes.\n     */\n    get pathChanged() {\n        return this._pathChanged;\n    }\n    /**\n     * A signal emitted when the directory listing is refreshed.\n     */\n    get refreshed() {\n        return this._refreshed;\n    }\n    /**\n     * Get the kernel spec models.\n     */\n    get specs() {\n        return this.manager.services.kernelspecs.specs;\n    }\n    /**\n     * Get whether the model is disposed.\n     */\n    get isDisposed() {\n        return this._isDisposed;\n    }\n    /**\n     * A signal emitted when an upload progresses.\n     */\n    get uploadChanged() {\n        return this._uploadChanged;\n    }\n    /**\n     * Create an iterator over the status of all in progress uploads.\n     */\n    uploads() {\n        return new _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayIterator(this._uploads);\n    }\n    /**\n     * Dispose of the resources held by the model.\n     */\n    dispose() {\n        if (this.isDisposed) {\n            return;\n        }\n        window.removeEventListener('beforeunload', this._unloadEventListener);\n        this._isDisposed = true;\n        this._poll.dispose();\n        this._sessions.length = 0;\n        this._items.length = 0;\n        _lumino_signaling__WEBPACK_IMPORTED_MODULE_6__.Signal.clearData(this);\n    }\n    /**\n     * Create an iterator over the model's items.\n     *\n     * @returns A new iterator over the model's items.\n     */\n    items() {\n        return new _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayIterator(this._items);\n    }\n    /**\n     * Create an iterator over the active sessions in the directory.\n     *\n     * @returns A new iterator over the model's active sessions.\n     */\n    sessions() {\n        return new _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayIterator(this._sessions);\n    }\n    /**\n     * Force a refresh of the directory contents.\n     */\n    async refresh() {\n        await this._poll.refresh();\n        await this._poll.tick;\n        this._refreshed.emit(void 0);\n    }\n    /**\n     * Change directory.\n     *\n     * @param path - The path to the file or directory.\n     *\n     * @returns A promise with the contents of the directory.\n     */\n    async cd(newValue = '.') {\n        if (newValue !== '.') {\n            newValue = this.manager.services.contents.resolvePath(this._model.path, newValue);\n        }\n        else {\n            newValue = this._pendingPath || this._model.path;\n        }\n        if (this._pending) {\n            // Collapse requests to the same directory.\n            if (newValue === this._pendingPath) {\n                return this._pending;\n            }\n            // Otherwise wait for the pending request to complete before continuing.\n            await this._pending;\n        }\n        const oldValue = this.path;\n        const options = { content: true };\n        this._pendingPath = newValue;\n        if (oldValue !== newValue) {\n            this._sessions.length = 0;\n        }\n        const services = this.manager.services;\n        this._pending = services.contents\n            .get(newValue, options)\n            .then(contents => {\n            if (this.isDisposed) {\n                return;\n            }\n            this._handleContents(contents);\n            this._pendingPath = null;\n            this._pending = null;\n            if (oldValue !== newValue) {\n                // If there is a state database and a unique key, save the new path.\n                // We don't need to wait on the save to continue.\n                if (this._state && this._key) {\n                    void this._state.save(this._key, { path: newValue });\n                }\n                this._pathChanged.emit({\n                    name: 'path',\n                    oldValue,\n                    newValue\n                });\n            }\n            this._onRunningChanged(services.sessions, services.sessions.running());\n            this._refreshed.emit(void 0);\n        })\n            .catch(error => {\n            this._pendingPath = null;\n            this._pending = null;\n            if (error.response && error.response.status === 404) {\n                error.message = this._trans.__('Directory not found: \"%1\"', this._model.path);\n                console.error(error);\n                this._connectionFailure.emit(error);\n                return this.cd('/');\n            }\n            else {\n                this._connectionFailure.emit(error);\n            }\n        });\n        return this._pending;\n    }\n    /**\n     * Download a file.\n     *\n     * @param path - The path of the file to be downloaded.\n     *\n     * @returns A promise which resolves when the file has begun\n     *   downloading.\n     */\n    async download(path) {\n        const url = await this.manager.services.contents.getDownloadUrl(path);\n        const element = document.createElement('a');\n        element.href = url;\n        element.download = '';\n        document.body.appendChild(element);\n        element.click();\n        document.body.removeChild(element);\n        return void 0;\n    }\n    /**\n     * Restore the state of the file browser.\n     *\n     * @param id - The unique ID that is used to construct a state database key.\n     *\n     * @param populate - If `false`, the restoration ID will be set but the file\n     * browser state will not be fetched from the state database.\n     *\n     * @returns A promise when restoration is complete.\n     *\n     * #### Notes\n     * This function will only restore the model *once*. If it is called multiple\n     * times, all subsequent invocations are no-ops.\n     */\n    async restore(id, populate = true) {\n        const { manager } = this;\n        const key = `file-browser-${id}:cwd`;\n        const state = this._state;\n        const restored = !!this._key;\n        if (restored) {\n            return;\n        }\n        // Set the file browser key for state database fetch/save.\n        this._key = key;\n        if (!populate || !state) {\n            this._restored.resolve(undefined);\n            return;\n        }\n        await manager.services.ready;\n        try {\n            const value = await state.fetch(key);\n            if (!value) {\n                this._restored.resolve(undefined);\n                return;\n            }\n            const path = value['path'];\n            const localPath = manager.services.contents.localPath(path);\n            await manager.services.contents.get(path);\n            await this.cd(localPath);\n        }\n        catch (error) {\n            await state.remove(key);\n        }\n        this._restored.resolve(undefined);\n    }\n    /**\n     * Upload a `File` object.\n     *\n     * @param file - The `File` object to upload.\n     *\n     * @returns A promise containing the new file contents model.\n     *\n     * #### Notes\n     * On Notebook version < 5.1.0, this will fail to upload files that are too\n     * big to be sent in one request to the server. On newer versions, or on\n     * Jupyter Server, it will ask for confirmation then upload the file in 1 MB\n     * chunks.\n     */\n    async upload(file) {\n        // We do not support Jupyter Notebook version less than 4, and Jupyter\n        // Server advertises itself as version 1 and supports chunked\n        // uploading. We assume any version less than 4.0.0 to be Jupyter Server\n        // instead of Jupyter Notebook.\n        const serverVersion = _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PageConfig.getNotebookVersion();\n        const supportsChunked = serverVersion < [4, 0, 0] /* Jupyter Server */ ||\n            serverVersion >= [5, 1, 0]; /* Jupyter Notebook >= 5.1.0 */\n        const largeFile = file.size > LARGE_FILE_SIZE;\n        if (largeFile && !supportsChunked) {\n            const msg = this._trans.__('Cannot upload file (>%1 MB). %2', LARGE_FILE_SIZE / (1024 * 1024), file.name);\n            console.warn(msg);\n            throw msg;\n        }\n        const err = 'File not uploaded';\n        if (largeFile && !(await this._shouldUploadLarge(file))) {\n            throw 'Cancelled large file upload';\n        }\n        await this._uploadCheckDisposed();\n        await this.refresh();\n        await this._uploadCheckDisposed();\n        if ((0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.find)(this._items, i => i.name === file.name) &&\n            !(await (0,_jupyterlab_docmanager__WEBPACK_IMPORTED_MODULE_2__.shouldOverwrite)(file.name))) {\n            throw err;\n        }\n        await this._uploadCheckDisposed();\n        const chunkedUpload = supportsChunked && file.size > CHUNK_SIZE;\n        return await this._upload(file, chunkedUpload);\n    }\n    async _shouldUploadLarge(file) {\n        const { button } = await (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showDialog)({\n            title: this._trans.__('Large file size warning'),\n            body: this._trans.__('The file size is %1 MB. Do you still want to upload it?', Math.round(file.size / (1024 * 1024))),\n            buttons: [\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.cancelButton({ label: this._trans.__('Cancel') }),\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.Dialog.warnButton({ label: this._trans.__('Upload') })\n            ]\n        });\n        return button.accept;\n    }\n    /**\n     * Perform the actual upload.\n     */\n    async _upload(file, chunked) {\n        // Gather the file model parameters.\n        let path = this._model.path;\n        path = path ? path + '/' + file.name : file.name;\n        const name = file.name;\n        const type = 'file';\n        const format = 'base64';\n        const uploadInner = async (blob, chunk) => {\n            await this._uploadCheckDisposed();\n            const reader = new FileReader();\n            reader.readAsDataURL(blob);\n            await new Promise((resolve, reject) => {\n                reader.onload = resolve;\n                reader.onerror = event => reject(`Failed to upload \"${file.name}\":` + event);\n            });\n            await this._uploadCheckDisposed();\n            // remove header https://stackoverflow.com/a/24289420/907060\n            const content = reader.result.split(',')[1];\n            const model = {\n                type,\n                format,\n                name,\n                chunk,\n                content\n            };\n            return await this.manager.services.contents.save(path, model);\n        };\n        if (!chunked) {\n            try {\n                return await uploadInner(file);\n            }\n            catch (err) {\n                _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.removeFirstWhere(this._uploads, uploadIndex => {\n                    return file.name === uploadIndex.path;\n                });\n                throw err;\n            }\n        }\n        let finalModel;\n        let upload = { path, progress: 0 };\n        this._uploadChanged.emit({\n            name: 'start',\n            newValue: upload,\n            oldValue: null\n        });\n        for (let start = 0; !finalModel; start += CHUNK_SIZE) {\n            const end = start + CHUNK_SIZE;\n            const lastChunk = end >= file.size;\n            const chunk = lastChunk ? -1 : end / CHUNK_SIZE;\n            const newUpload = { path, progress: start / file.size };\n            this._uploads.splice(this._uploads.indexOf(upload));\n            this._uploads.push(newUpload);\n            this._uploadChanged.emit({\n                name: 'update',\n                newValue: newUpload,\n                oldValue: upload\n            });\n            upload = newUpload;\n            let currentModel;\n            try {\n                currentModel = await uploadInner(file.slice(start, end), chunk);\n            }\n            catch (err) {\n                _lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.ArrayExt.removeFirstWhere(this._uploads, uploadIndex => {\n                    return file.name === uploadIndex.path;\n                });\n                this._uploadChanged.emit({\n                    name: 'failure',\n                    newValue: upload,\n                    oldValue: null\n                });\n                throw err;\n            }\n            if (lastChunk) {\n                finalModel = currentModel;\n            }\n        }\n        this._uploads.splice(this._uploads.indexOf(upload));\n        this._uploadChanged.emit({\n            name: 'finish',\n            newValue: null,\n            oldValue: upload\n        });\n        return finalModel;\n    }\n    _uploadCheckDisposed() {\n        if (this.isDisposed) {\n            return Promise.reject('Filemanager disposed. File upload canceled');\n        }\n        return Promise.resolve();\n    }\n    /**\n     * Handle an updated contents model.\n     */\n    _handleContents(contents) {\n        // Update our internal data.\n        this._model = {\n            name: contents.name,\n            path: contents.path,\n            type: contents.type,\n            content: undefined,\n            writable: contents.writable,\n            created: contents.created,\n            last_modified: contents.last_modified,\n            mimetype: contents.mimetype,\n            format: contents.format\n        };\n        this._items = contents.content;\n        this._paths.clear();\n        contents.content.forEach((model) => {\n            this._paths.add(model.path);\n        });\n    }\n    /**\n     * Handle a change to the running sessions.\n     */\n    _onRunningChanged(sender, models) {\n        this._populateSessions(models);\n        this._refreshed.emit(void 0);\n    }\n    /**\n     * Handle a change on the contents manager.\n     */\n    _onFileChanged(sender, change) {\n        const path = this._model.path;\n        const { sessions } = this.manager.services;\n        const { oldValue, newValue } = change;\n        const value = oldValue && oldValue.path && _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.dirname(oldValue.path) === path\n            ? oldValue\n            : newValue && newValue.path && _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_1__.PathExt.dirname(newValue.path) === path\n                ? newValue\n                : undefined;\n        // If either the old value or the new value is in the current path, update.\n        if (value) {\n            void this._poll.refresh();\n            this._populateSessions(sessions.running());\n            this._fileChanged.emit(change);\n            return;\n        }\n    }\n    /**\n     * Populate the model's sessions collection.\n     */\n    _populateSessions(models) {\n        this._sessions.length = 0;\n        (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.each)(models, model => {\n            if (this._paths.has(model.path)) {\n                this._sessions.push(model);\n            }\n        });\n    }\n}\n/**\n * File browser model with optional filter on element.\n */\nclass FilterFileBrowserModel extends FileBrowserModel {\n    constructor(options) {\n        super(options);\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_7__.nullTranslator;\n        this._filter = options.filter ? options.filter : model => true;\n    }\n    /**\n     * Create an iterator over the filtered model's items.\n     *\n     * @returns A new iterator over the model's items.\n     */\n    items() {\n        return (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_3__.filter)(super.items(), (value, index) => {\n            if (value.type === 'directory') {\n                return true;\n            }\n            else {\n                return this._filter(value);\n            }\n        });\n    }\n    setFilter(filter) {\n        this._filter = filter;\n        void this.refresh();\n    }\n}\n//# sourceMappingURL=model.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/model.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/opendialog.js":
/*!*****************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/opendialog.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FileDialog\": () => (/* binding */ FileDialog)\n/* harmony export */ });\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/widgets */ \"webpack/sharing/consume/default/@lumino/widgets/@lumino/widgets\");\n/* harmony import */ var _lumino_widgets__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_widgets__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/coreutils */ \"webpack/sharing/consume/default/@jupyterlab/coreutils/@jupyterlab/coreutils\");\n/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _browser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./browser */ \"../node_modules/@jupyterlab/filebrowser/lib/browser.js\");\n/* harmony import */ var _model__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./model */ \"../node_modules/@jupyterlab/filebrowser/lib/model.js\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n\n\n\n/**\n * The class name added to open file dialog\n */\nconst OPEN_DIALOG_CLASS = 'jp-Open-Dialog';\n/**\n * Namespace for file dialog\n */\nvar FileDialog;\n(function (FileDialog) {\n    /**\n     * Create and show a open files dialog.\n     *\n     * Note: if nothing is selected when `getValue` will return the browser\n     * model current path.\n     *\n     * @param options - The dialog setup options.\n     *\n     * @returns A promise that resolves with whether the dialog was accepted.\n     */\n    function getOpenFiles(options) {\n        const translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__.nullTranslator;\n        const trans = translator.load('jupyterlab');\n        const dialogOptions = {\n            title: options.title,\n            buttons: [\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.cancelButton({ label: trans.__('Cancel') }),\n                _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog.okButton({\n                    label: trans.__('Select')\n                })\n            ],\n            focusNodeSelector: options.focusNodeSelector,\n            host: options.host,\n            renderer: options.renderer,\n            body: new OpenDialog(options.manager, options.filter, translator)\n        };\n        const dialog = new _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.Dialog(dialogOptions);\n        return dialog.launch();\n    }\n    FileDialog.getOpenFiles = getOpenFiles;\n    /**\n     * Create and show a open directory dialog.\n     *\n     * Note: if nothing is selected when `getValue` will return the browser\n     * model current path.\n     *\n     * @param options - The dialog setup options.\n     *\n     * @returns A promise that resolves with whether the dialog was accepted.\n     */\n    function getExistingDirectory(options) {\n        return getOpenFiles(Object.assign(Object.assign({}, options), { filter: model => false }));\n    }\n    FileDialog.getExistingDirectory = getExistingDirectory;\n})(FileDialog || (FileDialog = {}));\n/**\n * Open dialog widget\n */\nclass OpenDialog extends _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.Widget {\n    constructor(manager, filter, translator) {\n        super();\n        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__.nullTranslator;\n        this.addClass(OPEN_DIALOG_CLASS);\n        this._browser = Private.createFilteredFileBrowser('filtered-file-browser-dialog', manager, filter, {}, translator);\n        // Build the sub widgets\n        const layout = new _lumino_widgets__WEBPACK_IMPORTED_MODULE_1__.PanelLayout();\n        layout.addWidget(this._browser);\n        // Set Widget content\n        this.layout = layout;\n    }\n    /**\n     * Get the selected items.\n     */\n    getValue() {\n        const selection = (0,_lumino_algorithm__WEBPACK_IMPORTED_MODULE_0__.toArray)(this._browser.selectedItems());\n        if (selection.length === 0) {\n            // Return current path\n            return [\n                {\n                    path: this._browser.model.path,\n                    name: _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_2__.PathExt.basename(this._browser.model.path),\n                    type: 'directory',\n                    content: undefined,\n                    writable: false,\n                    created: 'unknown',\n                    last_modified: 'unknown',\n                    mimetype: 'text/plain',\n                    format: 'text'\n                }\n            ];\n        }\n        else {\n            return selection;\n        }\n    }\n}\nvar Private;\n(function (Private) {\n    /**\n     * Create a new file browser instance.\n     *\n     * @param id - The widget/DOM id of the file browser.\n     *\n     * @param manager - A document manager instance.\n     *\n     * @param filter - function to filter file browser item.\n     *\n     * @param options - The optional file browser configuration object.\n     *\n     * #### Notes\n     * The ID parameter is used to set the widget ID. It is also used as part of\n     * the unique key necessary to store the file browser's restoration data in\n     * the state database if that functionality is enabled.\n     *\n     * If, after the file browser has been generated by the factory, the ID of the\n     * resulting widget is changed by client code, the restoration functionality\n     * will not be disrupted as long as there are no ID collisions, i.e., as long\n     * as the initial ID passed into the factory is used for only one file browser\n     * instance.\n     */\n    Private.createFilteredFileBrowser = (id, manager, filter, options = {}, translator) => {\n        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__.nullTranslator;\n        const model = new _model__WEBPACK_IMPORTED_MODULE_5__.FilterFileBrowserModel({\n            manager,\n            filter,\n            translator,\n            driveName: options.driveName,\n            refreshInterval: options.refreshInterval\n        });\n        const widget = new _browser__WEBPACK_IMPORTED_MODULE_6__.FileBrowser({\n            id,\n            model,\n            translator\n        });\n        return widget;\n    };\n})(Private || (Private = {}));\n//# sourceMappingURL=opendialog.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/opendialog.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/search.js":
/*!*************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/search.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FilenameSearcher\": () => (/* binding */ FilenameSearcher)\n/* harmony export */ });\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n\n/**\n * Perform a fuzzy search on a single item.\n */\nfunction fuzzySearch(source, query) {\n    // Set up the match score and indices array.\n    let score = Infinity;\n    let indices = null;\n    // The regex for search word boundaries\n    const rgx = /\\b\\w/g;\n    let continueSearch = true;\n    // Search the source by word boundary.\n    while (continueSearch) {\n        // Find the next word boundary in the source.\n        let rgxMatch = rgx.exec(source);\n        // Break if there is no more source context.\n        if (!rgxMatch) {\n            break;\n        }\n        // Run the string match on the relevant substring.\n        let match = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_1__.StringExt.matchSumOfDeltas(source, query, rgxMatch.index);\n        // Break if there is no match.\n        if (!match) {\n            break;\n        }\n        // Update the match if the score is better.\n        if (match && match.score <= score) {\n            score = match.score;\n            indices = match.indices;\n        }\n    }\n    // Bail if there was no match.\n    if (!indices || score === Infinity) {\n        return null;\n    }\n    // Handle a split match.\n    return {\n        score,\n        indices\n    };\n}\nconst FilterBox = (props) => {\n    const [filter, setFilter] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');\n    if (props.forceRefresh) {\n        (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {\n            props.listing.model.setFilter((item) => {\n                return true;\n            });\n        }, []);\n    }\n    /**\n     * Handler for search input changes.\n     */\n    const handleChange = (e) => {\n        const target = e.target;\n        setFilter(target.value);\n        props.listing.model.setFilter((item) => {\n            if (props.useFuzzyFilter) {\n                // Run the fuzzy search for the item and query.\n                const name = item.name.toLowerCase();\n                const query = target.value.toLowerCase();\n                let score = fuzzySearch(name, query);\n                // Ignore the item if it is not a match.\n                if (!score) {\n                    item.indices = [];\n                    return false;\n                }\n                item.indices = score.indices;\n                return true;\n            }\n            const i = item.name.indexOf(target.value);\n            if (i === -1) {\n                item.indices = [];\n                return false;\n            }\n            item.indices = [...Array(target.value.length).keys()].map(x => x + i);\n            return true;\n        });\n    };\n    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.InputGroup, { type: \"text\", rightIcon: \"ui-components:search\", placeholder: props.placeholder, onChange: handleChange, value: filter }));\n};\n/**\n * A widget which hosts a input textbox to filter on file names.\n */\nconst FilenameSearcher = (props) => {\n    return _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_3__.ReactWidget.create(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FilterBox, { listing: props.listing, useFuzzyFilter: props.useFuzzyFilter, placeholder: props.placeholder, forceRefresh: props.forceRefresh }));\n};\n//# sourceMappingURL=search.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/search.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/tokens.js":
/*!*************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/tokens.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"IFileBrowserFactory\": () => (/* binding */ IFileBrowserFactory)\n/* harmony export */ });\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ \"webpack/sharing/consume/default/@lumino/coreutils/@lumino/coreutils\");\n/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n/* tslint:disable */\n/**\n * The path tracker token.\n */\nconst IFileBrowserFactory = new _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.Token('@jupyterlab/filebrowser:IFileBrowserFactory');\n//# sourceMappingURL=tokens.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/tokens.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/upload.js":
/*!*************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/upload.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"Uploader\": () => (/* binding */ Uploader)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @jupyterlab/ui-components */ \"webpack/sharing/consume/default/@jupyterlab/ui-components/@jupyterlab/ui-components\");\n/* harmony import */ var _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n\n\n\n/**\n * A widget which provides an upload button.\n */\nclass Uploader extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.ToolbarButton {\n    /**\n     * Construct a new file browser buttons widget.\n     */\n    constructor(options) {\n        super({\n            icon: _jupyterlab_ui_components__WEBPACK_IMPORTED_MODULE_2__.fileUploadIcon,\n            onClick: () => {\n                this._input.click();\n            },\n            tooltip: Private.translateToolTip(options.translator)\n        });\n        /**\n         * The 'change' handler for the input field.\n         */\n        this._onInputChanged = () => {\n            const files = Array.prototype.slice.call(this._input.files);\n            const pending = files.map(file => this.fileBrowserModel.upload(file));\n            void Promise.all(pending).catch(error => {\n                void (0,_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.showErrorMessage)(this._trans._p('showErrorMessage', 'Upload Error'), error);\n            });\n        };\n        /**\n         * The 'click' handler for the input field.\n         */\n        this._onInputClicked = () => {\n            // In order to allow repeated uploads of the same file (with delete in between),\n            // we need to clear the input value to trigger a change event.\n            this._input.value = '';\n        };\n        this._input = Private.createUploadInput();\n        this.fileBrowserModel = options.model;\n        this.translator = options.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._input.onclick = this._onInputClicked;\n        this._input.onchange = this._onInputChanged;\n        this.addClass('jp-id-upload');\n    }\n}\n/**\n * The namespace for module private data.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Create the upload input node for a file buttons widget.\n     */\n    function createUploadInput() {\n        const input = document.createElement('input');\n        input.type = 'file';\n        input.multiple = true;\n        return input;\n    }\n    Private.createUploadInput = createUploadInput;\n    /**\n     * Translate upload tooltip.\n     */\n    function translateToolTip(translator) {\n        translator = translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_1__.nullTranslator;\n        const trans = translator.load('jupyterlab');\n        return trans.__('Upload Files');\n    }\n    Private.translateToolTip = translateToolTip;\n})(Private || (Private = {}));\n//# sourceMappingURL=upload.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/upload.js?");

/***/ }),

/***/ "../node_modules/@jupyterlab/filebrowser/lib/uploadstatus.js":
/*!*******************************************************************!*\
  !*** ../node_modules/@jupyterlab/filebrowser/lib/uploadstatus.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"FileUploadStatus\": () => (/* binding */ FileUploadStatus)\n/* harmony export */ });\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/apputils */ \"webpack/sharing/consume/default/@jupyterlab/apputils/@jupyterlab/apputils\");\n/* harmony import */ var _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/statusbar */ \"webpack/sharing/consume/default/@jupyterlab/statusbar/@jupyterlab/statusbar\");\n/* harmony import */ var _jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @lumino/algorithm */ \"webpack/sharing/consume/default/@lumino/algorithm/@lumino/algorithm\");\n/* harmony import */ var _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ \"webpack/sharing/consume/default/react/react\");\n/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @jupyterlab/translation */ \"webpack/sharing/consume/default/@jupyterlab/translation/@jupyterlab/translation\");\n/* harmony import */ var _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__);\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n//\n\n\n\n\n\n/**\n * Half-spacing between items in the overall status item.\n */\nconst HALF_SPACING = 4;\n/**\n * A pure function component for a FileUpload status item.\n *\n * @param props: the props for the component.\n *\n * @returns a tsx component for the file upload status.\n */\nfunction FileUploadComponent(props) {\n    const translator = props.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__.nullTranslator;\n    const trans = translator.load('jupyterlab');\n    return (react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_1__.GroupItem, { spacing: HALF_SPACING },\n        react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_1__.TextItem, { source: trans.__('Uploading…') }),\n        react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_1__.ProgressBar, { percentage: props.upload })));\n}\n/**\n * The time for which to show the \"Complete!\" message after uploading.\n */\nconst UPLOAD_COMPLETE_MESSAGE_MILLIS = 2000;\n/**\n * Status bar item to display file upload progress.\n */\nclass FileUploadStatus extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.VDomRenderer {\n    /**\n     * Construct a new FileUpload status item.\n     */\n    constructor(opts) {\n        super(new FileUploadStatus.Model(opts.tracker.currentWidget && opts.tracker.currentWidget.model));\n        this._onBrowserChange = (tracker, browser) => {\n            if (browser === null) {\n                this.model.browserModel = null;\n            }\n            else {\n                this.model.browserModel = browser.model;\n            }\n        };\n        this.translator = opts.translator || _jupyterlab_translation__WEBPACK_IMPORTED_MODULE_4__.nullTranslator;\n        this._trans = this.translator.load('jupyterlab');\n        this._tracker = opts.tracker;\n        this._tracker.currentChanged.connect(this._onBrowserChange);\n    }\n    /**\n     * Render the FileUpload status.\n     */\n    render() {\n        const uploadPaths = this.model.items;\n        if (uploadPaths.length > 0) {\n            const item = this.model.items[0];\n            if (item.complete) {\n                return react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_jupyterlab_statusbar__WEBPACK_IMPORTED_MODULE_1__.TextItem, { source: this._trans.__('Complete!') });\n            }\n            else {\n                return (react__WEBPACK_IMPORTED_MODULE_3___default().createElement(FileUploadComponent, { upload: this.model.items[0].progress, translator: this.translator }));\n            }\n        }\n        else {\n            return react__WEBPACK_IMPORTED_MODULE_3___default().createElement(FileUploadComponent, { upload: 100, translator: this.translator });\n        }\n    }\n    dispose() {\n        super.dispose();\n        this._tracker.currentChanged.disconnect(this._onBrowserChange);\n    }\n}\n/**\n * A namespace for FileUpload class statics.\n */\n(function (FileUploadStatus) {\n    /**\n     * The VDomModel for the FileUpload renderer.\n     */\n    class Model extends _jupyterlab_apputils__WEBPACK_IMPORTED_MODULE_0__.VDomModel {\n        /**\n         * Construct a new model.\n         */\n        constructor(browserModel) {\n            super();\n            /**\n             * Handle an uploadChanged event in the filebrowser model.\n             */\n            this._uploadChanged = (browse, uploads) => {\n                if (uploads.name === 'start') {\n                    this._items.push({\n                        path: uploads.newValue.path,\n                        progress: uploads.newValue.progress * 100,\n                        complete: false\n                    });\n                }\n                else if (uploads.name === 'update') {\n                    const idx = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.findFirstIndex(this._items, val => val.path === uploads.oldValue.path);\n                    if (idx !== -1) {\n                        this._items[idx].progress = uploads.newValue.progress * 100;\n                    }\n                }\n                else if (uploads.name === 'finish') {\n                    const idx = _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.findFirstIndex(this._items, val => val.path === uploads.oldValue.path);\n                    if (idx !== -1) {\n                        this._items[idx].complete = true;\n                        setTimeout(() => {\n                            _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.removeAt(this._items, idx);\n                            this.stateChanged.emit(void 0);\n                        }, UPLOAD_COMPLETE_MESSAGE_MILLIS);\n                    }\n                }\n                else if (uploads.name === 'failure') {\n                    _lumino_algorithm__WEBPACK_IMPORTED_MODULE_2__.ArrayExt.removeFirstWhere(this._items, val => val.path === uploads.newValue.path);\n                }\n                this.stateChanged.emit(void 0);\n            };\n            this._items = [];\n            this._browserModel = null;\n            this.browserModel = browserModel;\n        }\n        /**\n         * The currently uploading items.\n         */\n        get items() {\n            return this._items;\n        }\n        /**\n         * The current file browser model.\n         */\n        get browserModel() {\n            return this._browserModel;\n        }\n        set browserModel(browserModel) {\n            const oldBrowserModel = this._browserModel;\n            if (oldBrowserModel) {\n                oldBrowserModel.uploadChanged.disconnect(this._uploadChanged);\n            }\n            this._browserModel = browserModel;\n            this._items = [];\n            if (this._browserModel !== null) {\n                this._browserModel.uploadChanged.connect(this._uploadChanged);\n            }\n            this.stateChanged.emit(void 0);\n        }\n    }\n    FileUploadStatus.Model = Model;\n})(FileUploadStatus || (FileUploadStatus = {}));\n//# sourceMappingURL=uploadstatus.js.map\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@jupyterlab/filebrowser/lib/uploadstatus.js?");

/***/ })

}]);