/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.Closeable;
import java.io.DataInput;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.cs.BaseServer;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.ConnectionListener;
import org.jgroups.blocks.cs.NioServer;
import org.jgroups.blocks.cs.ReceiverAdapter;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.GossipType;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.SslContextFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class GossipRouter
extends ReceiverAdapter
implements ConnectionListener {
    @LocalAddress
    @Property(name="bind_addr", description="The bind address which should be used by the GossipRouter. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL, NON_LOOPBACK, match-interface, match-host, match-address", defaultValueIPv4="NON_LOOPBACK_ADDRESS", defaultValueIPv6="NON_LOOPBACK_ADDRESS", systemProperty={"jgroups.bind_addr"}, writable=false)
    protected InetAddress bind_addr;
    @ManagedAttribute(description="server port on which the GossipRouter accepts client connections", writable=true)
    protected int port = 12001;
    @ManagedAttribute(description="time (in msecs) until gossip entry expires. 0 disables expiration.", writable=true)
    protected long expiry_time;
    @Property(description="Time (in ms) for setting SO_LINGER on sockets returned from accept(). 0 means do not set SO_LINGER")
    protected long linger_timeout = 2000L;
    @Property(description="Time (in ms) for SO_TIMEOUT on sockets returned from accept(). 0 means don't set SO_TIMEOUT")
    protected long sock_read_timeout;
    protected ThreadFactory thread_factory = new DefaultThreadFactory("gossip", false, true);
    protected SocketFactory socket_factory = new DefaultSocketFactory();
    @Property(description="The max queue size of backlogged connections")
    protected int backlog = 1000;
    @Property(description="Expose GossipRouter via JMX", writable=false)
    protected boolean jmx = true;
    @Property(description="Use non-blocking IO (true) or blocking IO (false). Cannot be changed at runtime", writable=false)
    protected boolean use_nio;
    @Property(description="Handles client disconnects: sends SUSPECT message to all other members of that group")
    protected boolean emit_suspect_events = true;
    @Property(description="Dumps messages (dest/src/length/headers) to stdout")
    protected DumpMessages dump_msgs;
    @Property(description="The max number of bytes a message can have. If greater, an exception will be thrown. 0 disables this")
    protected int max_length;
    protected BaseServer server;
    protected final AtomicBoolean running = new AtomicBoolean(false);
    protected Timer timer;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ConcurrentMap<String, ConcurrentMap<Address, Entry>> address_mappings = new ConcurrentHashMap<String, ConcurrentMap<Address, Entry>>();
    protected static final BiConsumer<Short, Message> MSG_CONSUMER = (version, msg) -> System.out.printf("dst=%s src=%s (%d bytes): hdrs= %s\n", msg.dest(), msg.src(), msg.getLength(), msg.printHeaders());

    public GossipRouter(String bind_addr, int local_port) {
        this.port = local_port;
        try {
            this.bind_addr = bind_addr != null ? InetAddress.getByName(bind_addr) : null;
        }
        catch (UnknownHostException e) {
            this.log.error("failed setting bind address %s: %s", bind_addr, e);
        }
    }

    public GossipRouter(InetAddress bind_addr, int local_port) {
        this.port = local_port;
        this.bind_addr = bind_addr;
    }

    public Address localAddress() {
        return this.server.localAddress();
    }

    public String bindAddress() {
        return this.bind_addr != null ? this.bind_addr.toString() : null;
    }

    public GossipRouter bindAddress(InetAddress addr) {
        this.bind_addr = addr;
        return this;
    }

    public int port() {
        return this.port;
    }

    public GossipRouter port(int port) {
        this.port = port;
        return this;
    }

    public long expiryTime() {
        return this.expiry_time;
    }

    public GossipRouter expiryTime(long t) {
        this.expiry_time = t;
        return this;
    }

    public long lingerTimeout() {
        return this.linger_timeout;
    }

    public GossipRouter lingerTimeout(long t) {
        this.linger_timeout = t;
        return this;
    }

    public long socketReadTimeout() {
        return this.sock_read_timeout;
    }

    public GossipRouter socketReadTimeout(long t) {
        this.sock_read_timeout = t;
        return this;
    }

    public ThreadFactory threadPoolFactory() {
        return this.thread_factory;
    }

    public GossipRouter threadPoolFactory(ThreadFactory f) {
        this.thread_factory = f;
        return this;
    }

    public SocketFactory socketFactory() {
        return this.socket_factory;
    }

    public GossipRouter socketFactory(SocketFactory sf) {
        this.socket_factory = sf;
        return this;
    }

    public int backlog() {
        return this.backlog;
    }

    public GossipRouter backlog(int backlog) {
        this.backlog = backlog;
        return this;
    }

    public boolean jmx() {
        return this.jmx;
    }

    public GossipRouter jmx(boolean flag) {
        this.jmx = flag;
        return this;
    }

    public boolean useNio() {
        return this.use_nio;
    }

    public GossipRouter useNio(boolean flag) {
        this.use_nio = flag;
        return this;
    }

    public boolean emitSuspectEvents() {
        return this.emit_suspect_events;
    }

    public GossipRouter emitSuspectEvents(boolean flag) {
        this.emit_suspect_events = flag;
        return this;
    }

    public DumpMessages dumpMessages() {
        return this.dump_msgs;
    }

    public GossipRouter dumpMessages(DumpMessages flag) {
        this.dump_msgs = flag;
        return this;
    }

    public int maxLength() {
        return this.max_length;
    }

    public GossipRouter maxLength(int len) {
        this.max_length = len;
        if (this.server != null) {
            this.server.setMaxLength(len);
        }
        return this;
    }

    @ManagedAttribute(description="operational status", name="running")
    public boolean running() {
        return this.running.get();
    }

    @ManagedOperation(description="Lifecycle operation. Called after create(). When this method is called, the managed attributes have already been set. Brings the Router into a fully functional state.")
    public GossipRouter start() throws Exception {
        if (!this.running.compareAndSet(false, true)) {
            return this;
        }
        if (this.jmx) {
            JmxConfigurator.register(this, Util.getMBeanServer(), "jgroups:name=GossipRouter");
        }
        this.server = this.use_nio ? new NioServer(this.thread_factory, this.socket_factory, this.bind_addr, this.port, this.port, null, 0) : new TcpServer(this.thread_factory, this.socket_factory, this.bind_addr, this.port, this.port, null, 0);
        this.server.receiver(this).setMaxLength(this.max_length);
        this.server.start();
        this.server.addConnectionListener(this);
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        return this;
    }

    @ManagedOperation(description="Always called before destroy(). Closes connections and frees resources")
    public void stop() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        try {
            JmxConfigurator.unregister(this, Util.getMBeanServer(), "jgroups:name=GossipRouter");
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("MBeanDeRegistrationFailed"), ex);
        }
        Util.close((Closeable)this.server);
        this.log.debug("router stopped");
    }

    @ManagedOperation(description="Dumps the contents of the routing table")
    public String dumpRoutingTable() {
        return this.server.printConnections();
    }

    @ManagedOperation(description="Dumps the address mappings")
    public String dumpAddresssMappings() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.address_mappings.entrySet()) {
            String group = (String)entry.getKey();
            Map val = (Map)entry.getValue();
            if (val == null) continue;
            sb.append(group).append(":\n");
            for (Map.Entry entry2 : val.entrySet()) {
                Address logical_addr = (Address)entry2.getKey();
                Entry val2 = (Entry)entry2.getValue();
                if (val2 == null) continue;
                sb.append(String.format("  %s: %s (client_addr: %s, uuid:%s)\n", val2.logical_name, val2.phys_addr, val2.client_addr, logical_addr));
            }
        }
        return sb.toString();
    }

    @Override
    public void receive(Address sender, byte[] buf, int offset, int length) {
        GossipType type;
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, offset, length);
        try {
            type = GossipType.values()[in.readByte()];
            in.position(1);
        }
        catch (Exception ex) {
            this.log.error("failed reading data from %s: %s", sender, ex);
            return;
        }
        switch (type) {
            case REGISTER: {
                this.handleRegister(sender, in);
                break;
            }
            case MESSAGE: {
                try {
                    String group = Bits.readString(in);
                    Address dest = Util.readAddress(in);
                    this.route(group, dest, buf, offset, length);
                    if (this.dump_msgs != DumpMessages.ALL) break;
                    ByteArrayDataInputStream input = new ByteArrayDataInputStream(buf, offset, length);
                    GossipData data = new GossipData();
                    data.readFrom(input);
                    GossipRouter.dump(data);
                    break;
                }
                catch (Throwable t) {
                    this.log.error(Util.getMessage("FailedReadingRequest"), t);
                    return;
                }
            }
            case GET_MBRS: {
                this.handleGetMembersRequest(sender, in);
                break;
            }
            case UNREGISTER: {
                this.handleUnregister(in);
            }
        }
    }

    @Override
    public void receive(Address sender, DataInput in) throws Exception {
        GossipType type = GossipType.values()[in.readByte()];
        GossipData request = null;
        switch (type) {
            case REGISTER: {
                this.handleRegister(sender, in);
                break;
            }
            case MESSAGE: {
                try {
                    request = this.readRequest(in, type);
                    if (request == null) break;
                    ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(request.serializedSize());
                    request.writeTo(out);
                    this.route(request.group, request.addr, out.buffer(), 0, out.position());
                    if (this.dump_msgs != DumpMessages.ALL) break;
                    GossipRouter.dump(request);
                    break;
                }
                catch (Throwable t) {
                    this.log.error(Util.getMessage("FailedReadingRequest"), t);
                    return;
                }
            }
            case GET_MBRS: {
                this.handleGetMembersRequest(sender, in);
                break;
            }
            case UNREGISTER: {
                this.handleUnregister(in);
            }
        }
    }

    protected void handleRegister(Address sender, DataInput in) {
        GossipData req = this.readRequest(in, GossipType.REGISTER);
        if (req != null) {
            String group = req.getGroup();
            Address addr = req.getAddress();
            PhysicalAddress phys_addr = req.getPhysicalAddress();
            String logical_name = req.getLogicalName();
            this.addAddressMapping(sender, group, addr, phys_addr, logical_name);
            if (this.log.isDebugEnabled()) {
                this.log.debug("added %s (%s) to group %s", logical_name, phys_addr, group);
            }
            if (this.dump_msgs == DumpMessages.REGISTRATION || this.dump_msgs == DumpMessages.ALL) {
                System.out.printf("added %s (%s) to group %s\n", logical_name, phys_addr, group);
            }
        }
    }

    protected void handleUnregister(DataInput in) {
        GossipData req = this.readRequest(in, GossipType.UNREGISTER);
        if (req != null) {
            this.removeAddressMapping(req.getGroup(), req.getAddress());
        }
    }

    protected void handleGetMembersRequest(Address sender, DataInput in) {
        GossipData req = this.readRequest(in, GossipType.GET_MBRS);
        if (req == null) {
            return;
        }
        GossipData rsp = new GossipData(GossipType.GET_MBRS_RSP, req.getGroup(), null);
        Map members = (Map)this.address_mappings.get(req.getGroup());
        if (members != null) {
            for (Map.Entry entry : members.entrySet()) {
                Address logical_addr = (Address)entry.getKey();
                PhysicalAddress phys_addr = ((Entry)entry.getValue()).phys_addr;
                String logical_name = ((Entry)entry.getValue()).logical_name;
                PingData data = new PingData(logical_addr, true, logical_name, phys_addr);
                rsp.addPingData(data);
            }
        }
        if (this.dump_msgs == DumpMessages.ALL || this.log.isDebugEnabled()) {
            String rsps;
            String string = rsps = rsp.ping_data == null ? null : rsp.ping_data.stream().map(r -> String.format("%s (%s)", r.getLogicalName(), r.getPhysicalAddr())).collect(Collectors.joining(", "));
            if (rsps != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("get(%s) -> %s", req.getGroup(), rsps);
                }
                if (this.dump_msgs == DumpMessages.ALL) {
                    System.out.printf("get(%s) -> %s\n", req.getGroup(), rsps);
                }
            }
        }
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(rsp.serializedSize());
        try {
            rsp.writeTo(out);
            this.server.send(sender, out.buffer(), 0, out.position());
        }
        catch (Exception ex) {
            this.log.error("failed sending %d to %s: %s", new Object[]{GossipType.GET_MBRS_RSP, sender, ex});
        }
    }

    protected static void dump(GossipData data) {
        Util.parse(data.buffer, data.offset, data.length, MSG_CONSUMER, null, false);
    }

    @Override
    public void connectionClosed(Connection conn) {
        this.removeFromAddressMappings(conn.peerAddress());
    }

    @Override
    public void connectionEstablished(Connection conn) {
        this.log.debug("connection to %s established", conn.peerAddress());
    }

    protected GossipData readRequest(DataInput in) {
        GossipData data = new GossipData();
        try {
            data.readFrom(in);
            return data;
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedReadingRequest"), ex);
            return null;
        }
    }

    protected GossipData readRequest(DataInput in, GossipType type) {
        GossipData data = new GossipData(type);
        try {
            data.readFrom(in, false);
            return data;
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedReadingRequest"), ex);
            return null;
        }
    }

    protected void addAddressMapping(Address sender, String group, Address addr, PhysicalAddress phys_addr, String logical_name) {
        ConcurrentMap existing;
        ConcurrentMap<Address, Entry> m3 = (ConcurrentHashMap<Address, Entry>)this.address_mappings.get(group);
        if (m3 == null && (existing = (ConcurrentMap)this.address_mappings.putIfAbsent(group, m3 = new ConcurrentHashMap<Address, Entry>())) != null) {
            m3 = existing;
        }
        m3.put(addr, new Entry(sender, phys_addr, logical_name));
    }

    protected void removeAddressMapping(String group, Address addr) {
        Map m3 = (Map)this.address_mappings.get(group);
        if (m3 == null) {
            return;
        }
        Entry e = (Entry)m3.get(addr);
        if (e != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("removed %s (%s) from group %s", e.logical_name, e.phys_addr, group);
            }
            if (this.dump_msgs == DumpMessages.REGISTRATION || this.dump_msgs == DumpMessages.ALL) {
                System.out.printf("removed %s (%s) from group %s\n", e.logical_name, e.phys_addr, group);
            }
        }
        if (m3.remove(addr) != null && m3.isEmpty()) {
            this.address_mappings.remove(group);
        }
    }

    protected void removeFromAddressMappings(Address client_addr) {
        if (client_addr == null) {
            return;
        }
        HashSet suspects = null;
        block0: for (Map.Entry entry : this.address_mappings.entrySet()) {
            ConcurrentMap map = (ConcurrentMap)entry.getValue();
            for (Map.Entry entry2 : map.entrySet()) {
                Entry e = (Entry)entry2.getValue();
                if (!client_addr.equals(e.client_addr)) continue;
                map.remove(entry2.getKey());
                this.log.debug("connection to %s closed", client_addr);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("removed %s (%s) from group %s", e.logical_name, e.phys_addr, entry.getKey());
                }
                if (this.dump_msgs == DumpMessages.REGISTRATION || this.dump_msgs == DumpMessages.ALL) {
                    System.out.printf("removed %s (%s) from group %s\n", e.logical_name, e.phys_addr, entry.getKey());
                }
                if (map.isEmpty()) {
                    this.address_mappings.remove(entry.getKey());
                }
                if (suspects == null) {
                    suspects = new HashSet();
                }
                suspects.add(new Tuple(entry.getKey(), entry2.getKey()));
                continue block0;
            }
        }
        if (this.emit_suspect_events && suspects != null && !suspects.isEmpty()) {
            for (Tuple tuple : suspects) {
                String group = (String)tuple.getVal1();
                Address addr = (Address)tuple.getVal2();
                ConcurrentMap map = (ConcurrentMap)this.address_mappings.get(group);
                if (map == null) continue;
                GossipData data = new GossipData(GossipType.SUSPECT, group, addr);
                this.sendToAllMembersInGroup(map.entrySet(), data);
            }
        }
    }

    protected void route(String group, Address dest, byte[] msg, int offset, int length) {
        ConcurrentMap map = (ConcurrentMap)this.address_mappings.get(group);
        if (map == null) {
            return;
        }
        if (dest != null) {
            Entry entry = (Entry)map.get(dest);
            if (entry != null) {
                this.sendToMember(entry.client_addr, msg, offset, length);
            } else {
                this.log.warn("dest %s in cluster %s not found", dest, group);
            }
        } else {
            Set<Map.Entry<Address, Entry>> dests = map.entrySet();
            this.sendToAllMembersInGroup(dests, msg, offset, length);
        }
    }

    protected void sendToAllMembersInGroup(Set<Map.Entry<Address, Entry>> dests, GossipData request) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(request.serializedSize());
        try {
            request.writeTo(out);
        }
        catch (Exception ex) {
            this.log.error("failed marshalling gossip data %s: %s; dropping request", request, ex);
            return;
        }
        for (Map.Entry<Address, Entry> entry : dests) {
            Entry e = entry.getValue();
            if (e == null) continue;
            try {
                this.server.send(e.client_addr, out.buffer(), 0, out.position());
            }
            catch (Exception ex) {
                this.log.error("failed sending message to %s (%s): %s", e.logical_name, e.phys_addr, ex);
            }
        }
    }

    protected void sendToAllMembersInGroup(Set<Map.Entry<Address, Entry>> dests, byte[] buf, int offset, int len) {
        for (Map.Entry<Address, Entry> entry : dests) {
            Entry e = entry.getValue();
            if (e == null) continue;
            try {
                this.server.send(e.client_addr, buf, offset, len);
            }
            catch (Exception ex) {
                this.log.error("failed sending message to %s (%s): %s", e.logical_name, e.phys_addr, ex);
            }
        }
    }

    protected void sendToMember(Address dest, GossipData request) {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(request.serializedSize());
        try {
            request.writeTo(out);
            this.server.send(dest, out.buffer(), 0, out.position());
        }
        catch (Exception ex) {
            this.log.error("failed sending unicast message to %s: %s", dest, ex);
        }
    }

    protected void sendToMember(Address dest, byte[] buf, int offset, int len) {
        try {
            this.server.send(dest, buf, offset, len);
        }
        catch (Exception ex) {
            this.log.error("failed sending unicast message to %s: %s", dest, ex);
        }
    }

    private void printStartupInfo() {
        System.out.println("GossipRouter started at " + new Date());
        System.out.print("Listening on port " + this.port);
        System.out.println(" bound on address " + this.server.localAddress());
        System.out.print("Backlog is " + this.backlog);
        System.out.print(", linger timeout is " + this.linger_timeout);
        System.out.println(", and read timeout is " + this.sock_read_timeout);
    }

    public static void main(String[] args2) throws Exception {
        int port = 12001;
        int backlog = 0;
        int max_length = 0;
        long soLinger = -1L;
        long soTimeout = -1L;
        long expiry_time = 60000L;
        String tls_protocol = null;
        String tls_provider = null;
        String tls_keystore_path = null;
        String tls_keystore_password = null;
        String tls_keystore_type = null;
        String tls_keystore_alias = null;
        String tls_truststore_path = null;
        String tls_truststore_password = null;
        String tls_truststore_type = null;
        TLSClientAuth tls_client_auth = TLSClientAuth.NONE;
        ArrayList<SNIMatcher> tls_sni_matchers = new ArrayList<SNIMatcher>();
        long start = System.currentTimeMillis();
        String bind_addr = null;
        boolean jmx = false;
        boolean suspects = true;
        boolean nio = false;
        DumpMessages dump_msgs = DumpMessages.NONE;
        for (int i = 0; i < args2.length; ++i) {
            String arg = args2[i];
            if ("-port".equals(arg)) {
                port = Integer.parseInt(args2[++i]);
                continue;
            }
            if ("-bindaddress".equals(arg) || "-bind_addr".equals(arg)) {
                bind_addr = args2[++i];
                continue;
            }
            if ("-backlog".equals(arg)) {
                backlog = Integer.parseInt(args2[++i]);
                continue;
            }
            if ("-expiry".equals(arg)) {
                expiry_time = Long.parseLong(args2[++i]);
                continue;
            }
            if ("-jmx".equals(arg)) {
                jmx = Boolean.parseBoolean(args2[++i]);
                continue;
            }
            if ("-solinger".equals(arg)) {
                soLinger = Long.parseLong(args2[++i]);
                continue;
            }
            if ("-sotimeout".equals(arg)) {
                soTimeout = Long.parseLong(args2[++i]);
                continue;
            }
            if ("-nio".equals(arg)) {
                nio = Boolean.parseBoolean(args2[++i]);
                continue;
            }
            if ("-suspect".equals(arg)) {
                suspects = Boolean.parseBoolean(args2[++i]);
                continue;
            }
            if ("-dump_msgs".equals(arg)) {
                dump_msgs = DumpMessages.parse(args2[++i]);
                continue;
            }
            if ("-max_length".equals(arg)) {
                max_length = Integer.parseInt(args2[++i]);
                continue;
            }
            if ("-tls_protocol".equals(arg)) {
                tls_protocol = args2[++i];
                continue;
            }
            if ("-tls_provider".equals(arg)) {
                tls_provider = args2[++i];
                continue;
            }
            if ("-tls_keystore_path".equals(arg)) {
                tls_keystore_path = args2[++i];
                continue;
            }
            if ("-tls_keystore_password".equals(arg)) {
                tls_keystore_password = args2[++i];
                continue;
            }
            if ("-tls_keystore_type".equals(arg)) {
                tls_keystore_type = args2[++i];
                continue;
            }
            if ("-tls_keystore_alias".equals(arg)) {
                tls_keystore_alias = args2[++i];
                continue;
            }
            if ("-tls_truststore_path".equals(arg)) {
                tls_truststore_path = args2[++i];
                continue;
            }
            if ("-tls_truststore_password".equals(arg)) {
                tls_truststore_password = args2[++i];
                continue;
            }
            if ("-tls_truststore_type".equals(arg)) {
                tls_truststore_type = args2[++i];
                continue;
            }
            if ("-tls_client_auth".equals(arg)) {
                tls_client_auth = TLSClientAuth.valueOf(args2[++i].toUpperCase());
                continue;
            }
            if ("-tls_sni_matcher".equals(arg)) {
                tls_sni_matchers.add(SNIHostName.createSNIMatcher(args2[++i]));
                continue;
            }
            GossipRouter.help();
            return;
        }
        if (tls_protocol != null && nio) {
            throw new IllegalArgumentException("Cannot use NIO with TLS");
        }
        GossipRouter router = new GossipRouter(bind_addr, port).jmx(jmx).expiryTime(expiry_time).useNio(nio).backlog(backlog).socketReadTimeout(soTimeout).lingerTimeout(soLinger).emitSuspectEvents(suspects).dumpMessages(dump_msgs).maxLength(max_length);
        if (tls_protocol != null) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.sslProtocol(tls_protocol).sslProvider(tls_provider).keyStoreFileName(tls_keystore_path).keyStorePassword(tls_keystore_password).keyStoreType(tls_keystore_type).keyAlias(tls_keystore_alias).trustStoreFileName(tls_truststore_path).trustStorePassword(tls_truststore_password).trustStoreType(tls_truststore_type);
            SSLContext context = sslContextFactory.getContext();
            DefaultSocketFactory socketFactory = new DefaultSocketFactory(context);
            SSLParameters serverParameters = new SSLParameters();
            socketFactory.setServerSocketConfigurator(s2 -> ((SSLServerSocket)s2).setSSLParameters(serverParameters));
            serverParameters.setSNIMatchers(tls_sni_matchers);
            switch (tls_client_auth) {
                case NEED: {
                    serverParameters.setNeedClientAuth(true);
                    break;
                }
                case WANT: {
                    serverParameters.setWantClientAuth(true);
                    break;
                }
            }
            router.socketFactory(socketFactory);
        }
        router.start();
        long time = System.currentTimeMillis() - start;
        IpAddress local = (IpAddress)router.localAddress();
        System.out.printf("\nGossipRouter started in %d ms listening on %s:%s%s\n", time, bind_addr != null ? bind_addr : "0.0.0.0", local.getPort(), tls_protocol == null ? "" : " (" + tls_protocol + ")");
    }

    static void help() {
        System.out.println();
        System.out.println("GossipRouter [-port <port>] [-bind_addr <address>] [options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println();
        System.out.println("    -backlog <backlog>      - Max queue size of backlogged connections. Must be");
        System.out.println("                              greater than zero or the default of 1000 will be");
        System.out.println("                              used.");
        System.out.println();
        System.out.println("    -jmx <true|false>       - Expose attributes and operations via JMX.");
        System.out.println();
        System.out.println("    -solinger <msecs>       - Time for setting SO_LINGER on connections. 0");
        System.out.println("                              means do not set SO_LINGER. Must be greater than");
        System.out.println("                              or equal to zero or the default of 2000 will be");
        System.out.println("                              used.");
        System.out.println();
        System.out.println("    -sotimeout <msecs>      - Time for setting SO_TIMEOUT on connections. 0");
        System.out.println("                               means don't set SO_TIMEOUT. Must be greater than");
        System.out.println("                               or equal to zero or the default of 3000 will be");
        System.out.println("                               used.");
        System.out.println();
        System.out.println("    -expiry <msecs>         - Time for closing idle connections. 0");
        System.out.println("                              means don't expire.");
        System.out.println();
        System.out.println("    -nio <true|false>       - Whether or not to use non-blocking connections (NIO)");
        System.out.println();
        System.out.println("    -max_length <bytes>     - The max size (in bytes) of a message");
        System.out.println();
        System.out.println("    -suspect <true|false>   - Whether or not to use send SUSPECT events when a conn is closed");
        System.out.println();
        System.out.println("    -dump_msgs <option>     - Dumps messages to stdout after routing them. Options:");
        System.out.println("                              none: does not dump any messages");
        System.out.println("                              registration: dumps a message when a node is registered or unregistered to a group");
        System.out.println("                              all: dumps everything");
        System.out.println();
        System.out.println("    -tls_protocol <proto>   - The name of the TLS protocol to use, e.g. TLSv1.2.");
        System.out.println("                              Setting this requires configuring key and trust stores.");
        System.out.println();
        System.out.println("    -tls_provider <name>    - The name of the security provider to use for TLS.");
        System.out.println();
        System.out.println("    -tls_keystore_path <file> - The keystore path which contains the .");
        System.out.println();
        System.out.println("    -tls_keystore_password <password> - The key store password.");
        System.out.println();
        System.out.println("    -tls_keystore_type <type>    - The type of keystore.");
        System.out.println();
        System.out.println("    -tls_keystore_alias <alias>  - The alias of the key to use as identity for this Gossip router.");
        System.out.println();
        System.out.println("    -tls_truststore_path <file>  - The truststore path.");
        System.out.println();
        System.out.println("    -tls_truststore_password <password> - The trust store password.");
        System.out.println();
        System.out.println("    -tls_truststore_type <type>  - The truststore path.");
        System.out.println();
        System.out.println("    -tls_sni_matcher <name>      - A regular expression that servers use to match and accept SNI host names.");
        System.out.println("                                   Can be repeated multiple times.");
        System.out.println();
        System.out.println("    -tls_client_auth <mode>      - none (default), want or need. Whether to require client");
        System.out.println("                                   certificate authentication.");
        System.out.println();
    }

    static enum DumpMessages {
        NONE,
        REGISTRATION,
        ALL;


        static DumpMessages parse(String s2) {
            if ((s2 = s2.trim()).isEmpty() || s2.equalsIgnoreCase("false")) {
                return NONE;
            }
            if (s2.equalsIgnoreCase("true")) {
                return ALL;
            }
            return DumpMessages.valueOf(s2.toUpperCase());
        }
    }

    public static enum TLSClientAuth {
        NONE,
        WANT,
        NEED;

    }

    protected static class Entry {
        protected final PhysicalAddress phys_addr;
        protected final String logical_name;
        protected final Address client_addr;

        public Entry(Address client_addr, PhysicalAddress phys_addr, String logical_name) {
            this.phys_addr = phys_addr;
            this.logical_name = logical_name;
            this.client_addr = client_addr;
        }

        public String toString() {
            return String.format("client=%s, name=%s, addr=%s", this.client_addr, this.logical_name, this.phys_addr);
        }
    }
}

