/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.BaseBundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.PaddedAtomicBoolean;
import org.jgroups.util.PaddedAtomicInteger;
import org.jgroups.util.PaddedAtomicLong;
import org.jgroups.util.Runner;
import org.jgroups.util.Util;

public class RingBufferBundlerLockless2
extends BaseBundler {
    protected Message[] buf;
    protected final AtomicInteger read_index;
    protected int ri = 0;
    protected final AtomicInteger write_index;
    protected final AtomicLong accumulated_bytes;
    protected final AtomicInteger num_threads;
    protected final AtomicBoolean unparking;
    protected Runner bundler_thread;
    protected final Runnable run_function = this::readMessages;
    protected static final String THREAD_NAME = RingBufferBundlerLockless2.class.getSimpleName();
    public static final Message NULL_MSG = new Message(false);

    public RingBufferBundlerLockless2() {
        this(1024, true);
    }

    public RingBufferBundlerLockless2(int capacity) {
        this(capacity, true);
    }

    public RingBufferBundlerLockless2(int capacity, boolean padded) {
        this.buf = new Message[Util.getNextHigherPowerOfTwo(capacity)];
        this.read_index = padded ? new PaddedAtomicInteger(0) : new AtomicInteger(0);
        this.write_index = padded ? new PaddedAtomicInteger(1) : new AtomicInteger(1);
        this.accumulated_bytes = padded ? new PaddedAtomicLong(0L) : new AtomicLong(0L);
        this.num_threads = padded ? new PaddedAtomicInteger(0) : new AtomicInteger(0);
        this.unparking = padded ? new PaddedAtomicBoolean(false) : new AtomicBoolean(false);
    }

    public int readIndex() {
        return this.read_index.get();
    }

    public int writeIndex() {
        return this.write_index.get();
    }

    public RingBufferBundlerLockless2 reset() {
        this.ri = 0;
        this.read_index.set(0);
        this.write_index.set(1);
        return this;
    }

    @Override
    public int getQueueSize() {
        return this.size();
    }

    @Override
    public int size() {
        return this._size(this.read_index.get(), this.write_index.get());
    }

    protected int _size(int ri, int wi) {
        return ri < wi ? wi - ri - 1 : this.buf.length - ri - 1 + wi;
    }

    @Override
    public void init(TP transport) {
        super.init(transport);
        this.bundler_thread = new Runner(transport.getThreadFactory(), THREAD_NAME, this.run_function, this::reset);
    }

    @Override
    public void start() {
        this.bundler_thread.start();
    }

    @Override
    public void stop() {
        this.bundler_thread.stop();
    }

    @Override
    public void send(Message msg) throws Exception {
        if (msg == null) {
            throw new IllegalArgumentException("message must not be null");
        }
        this.num_threads.incrementAndGet();
        int tmp_write_index = this.getWriteIndex(this.read_index.get());
        if (tmp_write_index == -1) {
            this.log.warn("buf is full: %s\n", this.toString());
            this.unparkIfNeeded(0L);
            return;
        }
        this.buf[tmp_write_index] = msg;
        this.unparkIfNeeded(msg.size());
    }

    public String toString() {
        int tmp_ri = this.read_index.get();
        int tmp_wi = this.write_index.get();
        int size = this._size(tmp_ri, tmp_wi);
        return String.format("read-index=%d write-index=%d size=%d cap=%d\n", tmp_ri, tmp_wi, size, this.buf.length);
    }

    protected void unparkIfNeeded(long size) {
        boolean unpark;
        long acc_bytes = size > 0L ? this.accumulated_bytes.addAndGet(size) : this.accumulated_bytes.get();
        boolean size_exceeded = acc_bytes >= (long)this.transport.getMaxBundleSize() && this.accumulated_bytes.compareAndSet(acc_bytes, 0L);
        boolean no_other_threads = this.num_threads.decrementAndGet() == 0;
        boolean bl = unpark = size_exceeded || no_other_threads;
        if (unpark && this.unparking.compareAndSet(false, true)) {
            Thread thread2 = this.bundler_thread.getThread();
            if (thread2 != null) {
                LockSupport.unpark(thread2);
            }
            this.unparking.set(false);
        }
    }

    protected int getWriteIndex(int current_read_index) {
        int next_wi;
        int wi;
        do {
            if ((next_wi = this.index((wi = this.write_index.get()) + 1)) != current_read_index) continue;
            return -1;
        } while (!this.write_index.compareAndSet(wi, next_wi));
        return wi;
    }

    public int _readMessages() {
        int wi = this.write_index.get();
        if (this.index(this.ri + 1) == wi) {
            return 0;
        }
        int sent_msgs = this.sendBundledMessages(this.buf, this.ri, wi);
        this.advanceReadIndex(wi);
        return sent_msgs;
    }

    protected boolean advanceReadIndex(int wi) {
        boolean advanced = false;
        int i = this.increment(this.ri);
        while (i != wi && this.buf[i] == NULL_MSG) {
            this.buf[i] = null;
            this.ri = i;
            advanced = true;
            i = this.increment(i);
        }
        if (advanced) {
            this.read_index.set(this.ri);
        }
        return advanced;
    }

    protected void readMessages() {
        this._readMessages();
        LockSupport.park();
    }

    protected int sendBundledMessages(Message[] buf, int read_index, int write_index) {
        int max_bundle_size = this.transport.getMaxBundleSize();
        byte[] cluster_name = this.transport.cluster_name.chars();
        int sent_msgs = 0;
        int i = this.increment(read_index);
        while (i != write_index) {
            Message msg = buf[i];
            if (msg != NULL_MSG) {
                if (msg == null) break;
                Address dest = msg.dest();
                try {
                    this.output.position(0);
                    Util.writeMessageListHeader(dest, msg.src(), cluster_name, 1, this.output, dest == null);
                    int size_pos = this.output.position() - 4;
                    int num_msgs = this.marshalMessagesToSameDestination(dest, buf, i, write_index, max_bundle_size);
                    sent_msgs += num_msgs;
                    if (num_msgs > 1) {
                        int current_pos = this.output.position();
                        this.output.position(size_pos);
                        this.output.writeInt(num_msgs);
                        this.output.position(current_pos);
                    }
                    this.transport.doSend(this.output.buffer(), 0, this.output.position(), dest);
                    if (this.transport.statsEnabled()) {
                        this.transport.incrBatchesSent(num_msgs);
                    }
                }
                catch (Exception ex) {
                    this.log.error("failed to send message(s)", ex);
                }
            }
            i = this.increment(i);
        }
        return sent_msgs;
    }

    protected int marshalMessagesToSameDestination(Address dest, Message[] buf, int start_index, int end_index, int max_bundle_size) throws Exception {
        int num_msgs = 0;
        int bytes = 0;
        int i = start_index;
        while (i != end_index) {
            Message msg = buf[i];
            if (msg != null && msg != NULL_MSG && Objects.equals(dest, msg.dest())) {
                long msg_size = msg.size();
                if ((long)bytes + msg_size > (long)max_bundle_size) break;
                bytes = (int)((long)bytes + msg_size);
                ++num_msgs;
                buf[i] = NULL_MSG;
                msg.writeToNoAddrs(msg.src(), this.output, this.transport.getId());
            }
            i = this.increment(i);
        }
        return num_msgs;
    }

    protected final int increment(int index) {
        return index + 1 == this.buf.length ? 0 : index + 1;
    }

    protected final int index(int idx) {
        return idx & this.buf.length - 1;
    }

    protected static int assertPositive(int value, String message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

