/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.FD_ALL;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.MERGE3;
import org.jgroups.protocols.MFC;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TCPPING;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UFC;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.VERIFY_SUSPECT;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class ProgrammaticChat {
    public static void main(String[] args2) throws Exception {
        String name = null;
        String bind_addr = null;
        for (int i = 0; i < args2.length; ++i) {
            if ("-name".equals(args2[i])) {
                name = args2[++i];
                continue;
            }
            if ("-bind_addr".equals(args2[i])) {
                bind_addr = args2[++i];
                continue;
            }
            System.out.printf("%s [-h] [-name name] [-bind_addr addr]\n", ProgrammaticChat.class.getSimpleName());
            return;
        }
        InetAddress bind_address = bind_addr != null ? Util.getAddress(bind_addr, Util.getIpStackType()) : Util.getLoopback();
        Protocol[] prot_stack = new Protocol[]{((TP)((TP)((TP)((TP)new TCP().setBindAddress(bind_address)).setBindPort(7800)).setDiagnosticsEnabled(true)).diagEnableTcp(true)).diagEnableUdp(false), new TCPPING().initialHosts(Collections.singletonList(new InetSocketAddress(bind_address, 7800))), new MERGE3(), new FD_SOCK(), new FD_ALL(), new VERIFY_SUSPECT(), new NAKACK2(), new UNICAST3(), new STABLE(), new GMS(), new UFC(), new MFC(), new FRAG2()};
        JChannel ch = new JChannel(prot_stack).name(name);
        ch.setReceiver(new ReceiverAdapter(){

            @Override
            public void viewAccepted(View new_view) {
                System.out.println("view: " + new_view);
            }

            @Override
            public void receive(Message msg) {
                System.out.println("<< " + msg.getObject() + " [" + msg.getSrc() + "]");
            }
        });
        ch.connect("ChatCluster");
        while (true) {
            String line = Util.readStringFromStdin(": ");
            ch.send(null, line);
        }
    }
}

