/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.infinispan.commons.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.irac.IracManagerKeyInfo;
import org.infinispan.xsite.irac.IracManagerKeyState;

class IracManagerKeyChangedState
implements IracManagerKeyState {
    private static final AtomicReferenceFieldUpdater<IracManagerKeyChangedState, Status> STATUS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(IracManagerKeyChangedState.class, Status.class, "status");
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final int segment;
    private final Object key;
    private final Object owner;
    private final boolean expiration;
    private volatile Status status = Status.READY;

    public IracManagerKeyChangedState(int segment, Object key, Object owner, boolean expiration) {
        this.segment = segment;
        this.key = Objects.requireNonNull(key);
        this.owner = Objects.requireNonNull(owner);
        this.expiration = expiration;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    @Override
    public boolean isExpiration() {
        return this.expiration;
    }

    @Override
    public boolean isStateTransfer() {
        return false;
    }

    @Override
    public boolean canSend() {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] State.setSending for key %s (status=%s)", (Object)Util.toStr(this.key), (Object)this.status);
        }
        return STATUS_UPDATER.compareAndSet(this, Status.READY, Status.SENDING);
    }

    @Override
    public void retry() {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] State.setRetry for key %s (status=%s)", (Object)Util.toStr(this.key), (Object)this.status);
        }
        STATUS_UPDATER.compareAndSet(this, Status.SENDING, Status.READY);
    }

    @Override
    public boolean done() {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] State.setCompleted for key %s (status=%s)", (Object)Util.toStr(this.key), (Object)this.status);
        }
        return STATUS_UPDATER.compareAndSet(this, Status.SENDING, Status.DONE);
    }

    @Override
    public void discard() {
        if (log.isTraceEnabled()) {
            log.tracef("[IRAC] State.setDiscard for key %s (status=%s)", (Object)Util.toStr(this.key), (Object)this.status);
        }
        STATUS_UPDATER.lazySet(this, Status.DONE);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{segment=" + this.segment + ", key=" + Util.toStr(this.key) + ", owner=" + this.owner + ", expiration=" + this.expiration + ", isStateTransfer=" + this.isStateTransfer() + ", status=" + (Object)((Object)this.status) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IracManagerKeyInfo)) {
            return false;
        }
        IracManagerKeyInfo that = (IracManagerKeyInfo)o;
        if (this.getSegment() != that.getSegment()) {
            return false;
        }
        if (!this.getKey().equals(that.getKey())) {
            return false;
        }
        return this.getOwner().equals(that.getOwner());
    }

    public int hashCode() {
        int result = this.getSegment();
        result = 31 * result + this.getKey().hashCode();
        result = 31 * result + this.getOwner().hashCode();
        return result;
    }

    private static enum Status {
        READY,
        SENDING,
        DONE;

    }
}

