/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.DoubleCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.primitive.d.BoxedDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.DistinctDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FilterDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FlatMapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.LimitDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToIntDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToLongDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToObjDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.PeekDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.SkipDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.SortedDoubleOperation;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.local.LocalIntCacheStream;
import org.infinispan.stream.impl.local.LocalLongCacheStream;

public class LocalDoubleCacheStream
extends AbstractLocalCacheStream<Double, DoubleStream, DoubleCacheStream>
implements DoubleCacheStream {
    public LocalDoubleCacheStream(AbstractLocalCacheStream.StreamSupplier<Double, DoubleStream> streamSupplier, boolean parallel, ComponentRegistry registry) {
        super(streamSupplier, parallel, registry);
    }

    LocalDoubleCacheStream(AbstractLocalCacheStream<?, ?, ?> original) {
        super(original);
    }

    @Override
    public LocalDoubleCacheStream filter(DoublePredicate predicate) {
        this.registry.wireDependencies(predicate);
        this.intermediateOperations.add(new FilterDoubleOperation(predicate));
        return this;
    }

    @Override
    public LocalDoubleCacheStream map(DoubleUnaryOperator mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapDoubleOperation(mapper));
        return this;
    }

    public <U> LocalCacheStream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapToObjDoubleOperation<U>(mapper));
        return new LocalCacheStream(this);
    }

    @Override
    public LocalIntCacheStream mapToInt(DoubleToIntFunction mapper) {
        this.intermediateOperations.add(new MapToIntDoubleOperation(mapper));
        return new LocalIntCacheStream(this);
    }

    @Override
    public LocalLongCacheStream mapToLong(DoubleToLongFunction mapper) {
        this.intermediateOperations.add(new MapToLongDoubleOperation(mapper));
        return new LocalLongCacheStream(this);
    }

    @Override
    public LocalDoubleCacheStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        this.intermediateOperations.add(new FlatMapDoubleOperation(mapper));
        return this;
    }

    @Override
    public LocalDoubleCacheStream distinct() {
        this.intermediateOperations.add(DistinctDoubleOperation.getInstance());
        return this;
    }

    @Override
    public LocalDoubleCacheStream sorted() {
        this.intermediateOperations.add(SortedDoubleOperation.getInstance());
        return this;
    }

    @Override
    public LocalDoubleCacheStream peek(DoubleConsumer action) {
        this.intermediateOperations.add(new PeekDoubleOperation(action));
        return this;
    }

    @Override
    public LocalDoubleCacheStream limit(long maxSize) {
        this.intermediateOperations.add(new LimitDoubleOperation(maxSize));
        return this;
    }

    @Override
    public LocalDoubleCacheStream skip(long n) {
        this.intermediateOperations.add(new SkipDoubleOperation(n));
        return this;
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.injectCache(action);
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            stream.forEach(action);
        }
    }

    @Override
    public <K, V> void forEach(ObjDoubleConsumer<Cache<K, V>> action) {
        Cache cache = this.registry.getComponent(Cache.class);
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            stream.forEach((double d) -> action.accept(cache, d));
        }
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.injectCache(action);
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            stream.forEachOrdered(action);
        }
    }

    private void injectCache(DoubleConsumer cacheAware) {
        if (cacheAware instanceof CacheAware) {
            ((CacheAware)((Object)cacheAware)).injectCache(this.registry.getComponent(Cache.class));
        }
    }

    @Override
    public double[] toArray() {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            double[] dArray = stream.toArray();
            return dArray;
        }
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            double d = stream.reduce(identity, op);
            return d;
        }
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            OptionalDouble optionalDouble = stream.reduce(op);
            return optionalDouble;
        }
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            R r = stream.collect(supplier, accumulator, combiner);
            return r;
        }
    }

    @Override
    public double sum() {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            double d = stream.sum();
            return d;
        }
    }

    @Override
    public OptionalDouble min() {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            OptionalDouble optionalDouble = stream.min();
            return optionalDouble;
        }
    }

    @Override
    public OptionalDouble max() {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            OptionalDouble optionalDouble = stream.max();
            return optionalDouble;
        }
    }

    @Override
    public long count() {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            long l = stream.count();
            return l;
        }
    }

    @Override
    public OptionalDouble average() {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            OptionalDouble optionalDouble = stream.average();
            return optionalDouble;
        }
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            DoubleSummaryStatistics doubleSummaryStatistics = stream.summaryStatistics();
            return doubleSummaryStatistics;
        }
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            boolean bl = stream.anyMatch(predicate);
            return bl;
        }
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            boolean bl = stream.allMatch(predicate);
            return bl;
        }
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            boolean bl = stream.noneMatch(predicate);
            return bl;
        }
    }

    @Override
    public OptionalDouble findFirst() {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            OptionalDouble optionalDouble = stream.findFirst();
            return optionalDouble;
        }
    }

    @Override
    public OptionalDouble findAny() {
        try (DoubleStream stream = (DoubleStream)this.createStream();){
            OptionalDouble optionalDouble = stream.findAny();
            return optionalDouble;
        }
    }

    @Override
    public LocalCacheStream<Double> boxed() {
        this.intermediateOperations.add(BoxedDoubleOperation.getInstance());
        return new LocalCacheStream<Double>(this);
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        DoubleStream stream = (DoubleStream)this.createStream();
        this.onCloseRunnables.add(stream::close);
        return stream.iterator();
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        DoubleStream stream = (DoubleStream)this.createStream();
        this.onCloseRunnables.add(stream::close);
        return stream.spliterator();
    }

    @Override
    public LocalDoubleCacheStream sequentialDistribution() {
        return this;
    }

    @Override
    public LocalDoubleCacheStream parallelDistribution() {
        return this;
    }

    @Override
    public LocalDoubleCacheStream filterKeySegments(Set<Integer> segments) {
        return this.filterKeySegments(IntSets.from(segments));
    }

    @Override
    public LocalDoubleCacheStream filterKeySegments(IntSet segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public LocalDoubleCacheStream filterKeys(Set<?> keys2) {
        this.keysToFilter = keys2;
        return this;
    }

    @Override
    public LocalDoubleCacheStream distributedBatchSize(int batchSize) {
        return this;
    }

    @Override
    public LocalDoubleCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        return this;
    }

    @Override
    public LocalDoubleCacheStream disableRehashAware() {
        return this;
    }

    @Override
    public LocalDoubleCacheStream timeout(long timeout2, TimeUnit unit) {
        return this;
    }
}

