/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.remoting.transport.jgroups.AbstractJGroupsChannelConfigurator;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.XmlConfigurator;

public class FileJGroupsChannelConfigurator
extends AbstractJGroupsChannelConfigurator {
    private final String name;
    private final String path;
    private final Properties properties;
    private final List<ProtocolConfiguration> stack;

    public FileJGroupsChannelConfigurator(String name, String path, InputStream is, Properties properties) throws IOException {
        this.name = name;
        this.path = path;
        this.stack = XmlConfigurator.getInstance(is).getProtocolStack();
        this.properties = properties;
    }

    @Override
    public String getProtocolStackString() {
        return this.stack.toString();
    }

    @Override
    public List<ProtocolConfiguration> getProtocolStack() {
        this.stack.forEach(c -> StringPropertyReplacer.replaceProperties(c.getProperties(), this.properties));
        return this.stack;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JChannel createChannel(String name) throws Exception {
        return this.amendChannel(new JChannel(this));
    }

    public String getPath() {
        return this.path;
    }
}

