/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.SegmentAwarePublisher;
import org.infinispan.reactive.publisher.impl.SegmentCompletionPublisher;
import org.infinispan.reactive.publisher.impl.commands.reduction.PublisherResult;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class LocalClusterPublisherManagerImpl<K, V>
implements ClusterPublisherManager<K, V> {
    @Inject
    LocalPublisherManager<K, V> localPublisherManager;
    @Inject
    Configuration cacheConfiguration;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    ComponentRegistry componentRegistry;
    private int maxSegment;

    @Start
    public void start() {
        this.maxSegment = Configurations.needSegments(this.cacheConfiguration) ? this.cacheConfiguration.clustering().hash().numSegments() : 1;
    }

    static <K> Flowable<K> keyPublisherFromContext(InvocationContext ctx, IntSet segments, KeyPartitioner keyPartitioner, Set<K> keysToInclude) {
        UnicastProcessor unicastProcessor = UnicastProcessor.create(ctx.lookedUpEntriesCount());
        ctx.forEachValue((o, cacheEntry) -> {
            Object key = o;
            if ((keysToInclude == null || keysToInclude.contains(key)) && (segments == null || segments.contains(keyPartitioner.getSegment(key)))) {
                unicastProcessor.onNext(key);
            }
        });
        unicastProcessor.onComplete();
        return unicastProcessor;
    }

    static <K, V> Flowable<CacheEntry<K, V>> entryPublisherFromContext(InvocationContext ctx, IntSet segments, KeyPartitioner keyPartitioner, Set<K> keysToInclude) {
        UnicastProcessor unicastProcessor = UnicastProcessor.create(ctx.lookedUpEntriesCount());
        ctx.forEachValue((o, cacheEntry) -> {
            Object key = o;
            if ((keysToInclude == null || keysToInclude.contains(key)) && (segments == null || segments.contains(keyPartitioner.getSegment(key)))) {
                unicastProcessor.onNext((CacheEntry)cacheEntry);
            }
        });
        unicastProcessor.onComplete();
        return unicastProcessor;
    }

    IntSet handleNullSegments(IntSet segments) {
        return segments != null ? segments : IntSets.immutableRangeSet(this.maxSegment);
    }

    @Override
    public <R> CompletionStage<R> keyReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        if (transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)transformer)).inject(this.componentRegistry);
        }
        if (finalizer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)finalizer)).inject(this.componentRegistry);
        }
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.keyReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, null, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        }
        HashSet keysToExclude = new HashSet(invocationContext.lookedUpEntriesCount());
        invocationContext.forEachEntry((key, ce) -> keysToExclude.add(key));
        CompletionStage<Object> stage = this.localPublisherManager.keyReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, keysToExclude, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        Flowable<K> entryFlowable = LocalClusterPublisherManagerImpl.keyPublisherFromContext(invocationContext, segments, this.keyPartitioner, keysToInclude);
        return transformer.apply(entryFlowable).thenCombine(stage, Flowable::just).thenCompose(finalizer);
    }

    @Override
    public <R> CompletionStage<R> entryReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        if (transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)transformer)).inject(this.componentRegistry);
        }
        if (finalizer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)finalizer)).inject(this.componentRegistry);
        }
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.entryReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, null, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        }
        HashSet keysToExclude = new HashSet(invocationContext.lookedUpEntriesCount());
        invocationContext.forEachEntry((key, ce) -> keysToExclude.add(key));
        CompletionStage<Object> stage = this.localPublisherManager.entryReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, keysToExclude, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        Flowable<CacheEntry<K, V>> entryFlowable = LocalClusterPublisherManagerImpl.entryPublisherFromContext(invocationContext, segments, this.keyPartitioner, keysToInclude);
        return transformer.apply(entryFlowable).thenCombine(stage, Flowable::just).thenCompose(finalizer);
    }

    @Override
    public <R> SegmentCompletionPublisher<R> keyPublisher(IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, int batchSize, Function<? super Publisher<K>, ? extends Publisher<R>> transformer) {
        if (transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)transformer)).inject(this.componentRegistry);
        }
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.keyPublisher(this.handleNullSegments(segments), keysToInclude, null, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer);
        }
        SegmentAwarePublisher cachePublisher = this.localPublisherManager.keyPublisher(this.handleNullSegments(segments), keysToInclude, null, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer);
        Flowable keyFlowable = LocalClusterPublisherManagerImpl.keyPublisherFromContext(invocationContext, segments, this.keyPartitioner, keysToInclude);
        return (subscriber, completedSegments) -> Flowable.concat((Publisher)transformer.apply(keyFlowable), s2 -> cachePublisher.subscribe(s2, completedSegments)).subscribe(subscriber);
    }

    @Override
    public <R> SegmentCompletionPublisher<R> entryPublisher(IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, int batchSize, Function<? super Publisher<CacheEntry<K, V>>, ? extends Publisher<R>> transformer) {
        if (transformer instanceof InjectableComponent) {
            ((InjectableComponent)((Object)transformer)).inject(this.componentRegistry);
        }
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.entryPublisher(this.handleNullSegments(segments), keysToInclude, null, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer);
        }
        SegmentAwarePublisher cachePublisher = this.localPublisherManager.entryPublisher(this.handleNullSegments(segments), keysToInclude, null, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer);
        Flowable entryFlowable = LocalClusterPublisherManagerImpl.entryPublisherFromContext(invocationContext, segments, this.keyPartitioner, keysToInclude);
        return (subscriber, completedSegments) -> Flowable.concat((Publisher)transformer.apply(entryFlowable), s2 -> cachePublisher.subscribe(s2, completedSegments)).subscribe(subscriber);
    }
}

