/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.configuration.IndexConfiguration;
import org.infinispan.util.logging.LogFactory;

public class IndexConfigurationBuilder
implements Builder<IndexConfiguration> {
    private static final Log log = LogFactory.getLog(IndexConfigurationBuilder.class, Log.class);
    private final AttributeSet attributes = IndexConfiguration.attributeDefinitionSet();

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexConfigurationBuilder indexLocation(String indexLocation) {
        this.attributes.attribute(IndexConfiguration.INDEX_LOCATION).set(indexLocation);
        return this;
    }

    public IndexConfigurationBuilder indexSegments(int indexSegments) {
        this.attributes.attribute(IndexConfiguration.INDEX_SEGMENTS).set(indexSegments);
        return this;
    }

    public IndexConfigurationBuilder minNodeSize(int minNodeSize) {
        this.attributes.attribute(IndexConfiguration.MIN_NODE_SIZE).set(minNodeSize);
        return this;
    }

    public IndexConfigurationBuilder maxNodeSize(int maxNodeSize) {
        this.attributes.attribute(IndexConfiguration.MAX_NODE_SIZE).set(maxNodeSize);
        return this;
    }

    public IndexConfigurationBuilder indexQueueLength(int indexQueueLength) {
        this.attributes.attribute(IndexConfiguration.INDEX_QUEUE_LENGTH).set(indexQueueLength);
        return this;
    }

    @Override
    public IndexConfiguration create() {
        return new IndexConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(IndexConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    @Override
    public void validate() {
        int minNodeSize = this.attributes.attribute(IndexConfiguration.MIN_NODE_SIZE).get();
        int maxNodeSize = this.attributes.attribute(IndexConfiguration.MAX_NODE_SIZE).get();
        if (maxNodeSize <= 0 || maxNodeSize > Short.MAX_VALUE) {
            throw log.maxNodeSizeLimitedToShort(maxNodeSize);
        }
        if (minNodeSize < 0 || minNodeSize > maxNodeSize) {
            throw log.minNodeSizeMustBeLessOrEqualToMax(minNodeSize, maxNodeSize);
        }
    }

    public String toString() {
        return "IndexConfigurationBuilder{attributes=" + this.attributes + '}';
    }
}

