/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.functional.Traversable;

public final class Traversables {
    public static <T> Traversable<T> of(Stream<T> stream) {
        return new StreamTraversable(stream);
    }

    public static <T> CloseableIterator<T> asIterator(Traversable<T> traversable) {
        if (traversable instanceof StreamTraversable) {
            return Closeables.iterator(((StreamTraversable)traversable).stream);
        }
        List collected = traversable.collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        return Closeables.iterator(collected.iterator());
    }

    private Traversables() {
    }

    private static final class StreamTraversable<T>
    implements Traversable<T> {
        final Stream<T> stream;

        private StreamTraversable(Stream<T> stream) {
            this.stream = stream;
        }

        @Override
        public Traversable<T> filter(Predicate<? super T> p) {
            return new StreamTraversable<T>(this.stream.filter(p));
        }

        @Override
        public <R> Traversable<R> map(Function<? super T, ? extends R> f) {
            return new StreamTraversable<R>(this.stream.map(f));
        }

        @Override
        public <R> Traversable<R> flatMap(final Function<? super T, ? extends Traversable<? extends R>> f) {
            Function mapper = new Function<T, Stream<? extends R>>(){

                @Override
                public Stream<? extends R> apply(T t) {
                    StreamTraversable applied = (StreamTraversable)f.apply(t);
                    return applied.stream;
                }
            };
            return new StreamTraversable(this.stream.flatMap(mapper));
        }

        @Override
        public void forEach(Consumer<? super T> c) {
            this.stream.forEach(c);
        }

        @Override
        public T reduce(T z, BinaryOperator<T> folder) {
            return this.stream.reduce(z, folder);
        }

        @Override
        public Optional<T> reduce(BinaryOperator<T> folder) {
            return this.stream.reduce(folder);
        }

        @Override
        public <U> U reduce(U z, BiFunction<U, ? super T, U> mapper, BinaryOperator<U> folder) {
            return this.stream.reduce(z, mapper, folder);
        }

        @Override
        public <R> R collect(Supplier<R> s2, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
            return this.stream.collect(s2, accumulator, combiner);
        }

        @Override
        public <R, A> R collect(Collector<? super T, A, R> collector) {
            return this.stream.collect(collector);
        }

        @Override
        public long count() {
            return this.stream.count();
        }

        @Override
        public boolean anyMatch(Predicate<? super T> p) {
            return this.stream.anyMatch(p);
        }

        @Override
        public boolean allMatch(Predicate<? super T> p) {
            return this.stream.allMatch(p);
        }

        @Override
        public boolean noneMatch(Predicate<? super T> predicate) {
            return this.stream.noneMatch(predicate);
        }

        @Override
        public Optional<T> findAny() {
            return this.stream.findAny();
        }
    }
}

