/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.threads;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.executors.NonBlockingResource;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.concurrent.BlockingRejectedExecutionHandler;
import org.infinispan.factories.threads.AbstractThreadPoolExecutorFactory;
import org.jboss.threads.EnhancedQueueExecutor;
import org.jboss.threads.management.ManageableThreadPoolExecutorService;

public class EnhancedQueueExecutorFactory
extends AbstractThreadPoolExecutorFactory<ManageableThreadPoolExecutorService> {
    protected EnhancedQueueExecutorFactory(int maxThreads, int coreThreads, int queueLength, long keepAlive) {
        super(maxThreads, coreThreads, queueLength, keepAlive);
    }

    public static EnhancedQueueExecutorFactory create(int maxThreads, int queueSize) {
        int coreThreads = queueSize == 0 ? 1 : maxThreads;
        return new EnhancedQueueExecutorFactory(maxThreads, coreThreads, queueSize, 60000L);
    }

    @Override
    public ManageableThreadPoolExecutorService createExecutor(ThreadFactory factory2) {
        if (factory2 instanceof NonBlockingResource) {
            throw new IllegalStateException("Executor factory configured to be blocking and received a thread factory that creates non-blocking threads!");
        }
        EnhancedQueueExecutor.Builder builder = new EnhancedQueueExecutor.Builder();
        builder.setThreadFactory(factory2);
        builder.setCorePoolSize(this.coreThreads);
        builder.setMaximumPoolSize(this.maxThreads);
        builder.setGrowthResistance(0.0f);
        builder.setMaximumQueueSize(this.queueLength);
        builder.setKeepAliveTime(this.keepAlive, TimeUnit.MILLISECONDS);
        EnhancedQueueExecutor enhancedQueueExecutor = builder.build();
        enhancedQueueExecutor.setHandoffExecutor(task -> BlockingRejectedExecutionHandler.getInstance().rejectedExecution(task, enhancedQueueExecutor));
        return enhancedQueueExecutor;
    }

    @Override
    public void validate() {
        if (this.coreThreads < 0) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("core threads", ">= 0");
        }
        if (this.maxThreads <= 0) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("max threads", "> 0");
        }
        if (this.maxThreads < this.coreThreads) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("max threads and core threads", "max threads >= core threads");
        }
        if (this.keepAlive < 0L) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("keep alive time", ">= 0");
        }
        if (this.queueLength < 0) {
            throw Log.CONFIG.illegalValueThreadPoolParameter("work queue length", ">= 0");
        }
    }
}

