/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class NumericVersionGenerator
implements VersionGenerator {
    private static final Log log = LogFactory.getLog(NumericVersionGenerator.class);
    final AtomicInteger versionCounter = new AtomicInteger();
    final AtomicLong versionPrefix = new AtomicLong();
    private static final NumericVersion NON_EXISTING = new NumericVersion(0L);
    @Inject
    Configuration configuration;
    @Inject
    CacheManagerNotifier cacheManagerNotifier;
    @Inject
    Transport transport;
    private boolean isClustered;

    @Start(priority=11)
    public void start() {
        this.cacheManagerNotifier.addListener(new RankCalculator());
        this.isClustered = this.configuration.clustering().cacheMode().isClustered();
        if (this.isClustered) {
            this.calculateRank(this.transport.getAddress(), this.transport.getMembers(), this.transport.getViewId());
        }
    }

    public NumericVersionGenerator clustered(boolean clustered) {
        this.isClustered = clustered;
        return this;
    }

    @Override
    public IncrementableEntryVersion generateNew() {
        long counter = this.versionCounter.incrementAndGet();
        return this.createNumericVersion(counter);
    }

    private IncrementableEntryVersion createNumericVersion(long counter) {
        return this.isClustered ? new NumericVersion(this.versionPrefix.get() | counter) : new NumericVersion(counter);
    }

    @Override
    public IncrementableEntryVersion increment(IncrementableEntryVersion initialVersion) {
        if (initialVersion instanceof NumericVersion) {
            NumericVersion old = (NumericVersion)initialVersion;
            long counter = old.getVersion() + 1L;
            return this.createNumericVersion(counter);
        }
        throw Log.CONTAINER.unexpectedInitialVersion(initialVersion.getClass().getName());
    }

    @Override
    public IncrementableEntryVersion nonExistingVersion() {
        return NON_EXISTING;
    }

    long calculateRank(Address address, List<Address> members, long viewId) {
        long rank = this.findAddressRank(address, members, 1);
        long newVersionPrefix = viewId << 48 | rank << 32;
        this.versionPrefix.compareAndSet(this.versionPrefix.get(), newVersionPrefix);
        return this.versionPrefix.get();
    }

    void resetCounter() {
        this.versionCounter.set(0);
    }

    private int findAddressRank(Address address, List<Address> members, int rank) {
        if (address.equals(members.get(0))) {
            return rank;
        }
        return this.findAddressRank(address, members.subList(1, members.size()), rank + 1);
    }

    @Listener
    public class RankCalculator {
        @ViewChanged
        public void calculateRank(ViewChangedEvent e) {
            long rank = NumericVersionGenerator.this.calculateRank(e.getLocalAddress(), e.getNewMembers(), e.getViewId());
            if (log.isTraceEnabled()) {
                log.tracef("Calculated rank based on view %s and result was %d", (Object)e, (Object)rank);
            }
        }
    }
}

