/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.JGroupsConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.infinispan.configuration.global.ThreadsConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.remoting.transport.Transport;

public class TransportConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<TransportConfiguration> {
    public static final String DEFAULT_TRANSPORT = "org.infinispan.remoting.transport.jgroups.JGroupsTransport";
    private final ThreadsConfigurationBuilder threads;
    private final AttributeSet attributes;
    private final JGroupsConfigurationBuilder jgroupsConfigurationBuilder;
    private TypedProperties typedProperties = new TypedProperties();

    TransportConfigurationBuilder(GlobalConfigurationBuilder globalConfig, ThreadsConfigurationBuilder threads) {
        super(globalConfig);
        this.threads = threads;
        this.attributes = TransportConfiguration.attributeSet();
        this.jgroupsConfigurationBuilder = new JGroupsConfigurationBuilder(globalConfig);
    }

    public TransportConfigurationBuilder clusterName(String clusterName) {
        this.attributes.attribute(TransportConfiguration.CLUSTER_NAME).set(clusterName);
        return this;
    }

    public TransportConfigurationBuilder machineId(String machineId) {
        this.attributes.attribute(TransportConfiguration.MACHINE_ID).set(machineId);
        return this;
    }

    public TransportConfigurationBuilder rackId(String rackId) {
        this.attributes.attribute(TransportConfiguration.RACK_ID).set(rackId);
        return this;
    }

    public TransportConfigurationBuilder siteId(String siteId) {
        this.attributes.attribute(TransportConfiguration.SITE_ID).set(siteId);
        return this;
    }

    public TransportConfigurationBuilder stack(String stack) {
        this.attributes.attribute(TransportConfiguration.STACK).set(stack);
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout) {
        this.attributes.attribute(TransportConfiguration.DISTRIBUTED_SYNC_TIMEOUT).set(distributedSyncTimeout);
        return this;
    }

    public TransportConfigurationBuilder distributedSyncTimeout(long distributedSyncTimeout, TimeUnit unit) {
        return this.distributedSyncTimeout(unit.toMillis(distributedSyncTimeout));
    }

    public TransportConfigurationBuilder initialClusterSize(int clusterSize) {
        this.attributes.attribute(TransportConfiguration.INITIAL_CLUSTER_SIZE).set(clusterSize);
        return this;
    }

    public TransportConfigurationBuilder initialClusterTimeout(long initialClusterTimeout, TimeUnit unit) {
        this.attributes.attribute(TransportConfiguration.INITIAL_CLUSTER_TIMEOUT).set(unit.toMillis(initialClusterTimeout));
        return this;
    }

    public TransportConfigurationBuilder transport(Transport transport) {
        this.jgroupsConfigurationBuilder.transport(transport);
        return this;
    }

    public TransportConfigurationBuilder nodeName(String nodeName) {
        this.attributes.attribute(TransportConfiguration.NODE_NAME).set(nodeName);
        return this;
    }

    public TransportConfigurationBuilder withProperties(Properties properties) {
        this.typedProperties = TypedProperties.toTypedProperties(properties);
        return this;
    }

    public TransportConfigurationBuilder clearProperties() {
        this.typedProperties.clear();
        return this;
    }

    public TransportConfigurationBuilder addProperty(String key, Object value) {
        this.typedProperties.put(key, value);
        return this;
    }

    public TransportConfigurationBuilder removeProperty(String key) {
        this.typedProperties.remove(key);
        return this;
    }

    public String getProperty(String key) {
        return String.valueOf(this.typedProperties.get(key));
    }

    public ThreadPoolConfigurationBuilder transportThreadPool() {
        return this.threads.transportThreadPool();
    }

    public ThreadPoolConfigurationBuilder remoteCommandThreadPool() {
        return this.threads.remoteCommandThreadPool();
    }

    @Override
    public void validate() {
        if (this.attributes.attribute(TransportConfiguration.CLUSTER_NAME).get() == null) {
            throw new CacheConfigurationException("Transport clusterName cannot be null");
        }
    }

    public JGroupsConfigurationBuilder jgroups() {
        return this.jgroupsConfigurationBuilder;
    }

    @Override
    public TransportConfiguration create() {
        return new TransportConfiguration(this.attributes.protect(), this.jgroupsConfigurationBuilder.create(), this.threads.transportThreadPool().create(), this.threads.remoteCommandThreadPool().create(), this.typedProperties);
    }

    public TransportConfigurationBuilder defaultTransport() {
        Transport transport = (Transport)Util.getInstance(DEFAULT_TRANSPORT, this.getGlobalConfig().getClassLoader());
        this.transport(transport);
        return this;
    }

    @Deprecated
    public TransportConfigurationBuilder transportExecutor(String threadPoolName) {
        this.attributes.attribute(TransportConfiguration.TRANSPORT_EXECUTOR).set(threadPoolName);
        return this;
    }

    public TransportConfigurationBuilder remoteExecutor(String threadPoolName) {
        this.attributes.attribute(TransportConfiguration.REMOTE_EXECUTOR).set(threadPoolName);
        return this;
    }

    public TransportConfigurationBuilder read(TransportConfiguration template) {
        this.attributes.read(template.attributes());
        this.jgroupsConfigurationBuilder.read(template.jgroups());
        this.typedProperties = new TypedProperties((Map<?, ?>)template.properties());
        if (template.transport() != null) {
            Transport transport = (Transport)Util.getInstance(template.transport().getClass().getName(), template.transport().getClass().getClassLoader());
            this.transport(transport);
        }
        return this;
    }

    public Transport getTransport() {
        return this.jgroupsConfigurationBuilder.jgroupsTransport();
    }

    public String toString() {
        return "TransportConfigurationBuilder{threads=" + this.threads + ", attributes=" + this.attributes + ", jgroupsConfigurationBuilder=" + this.jgroupsConfigurationBuilder + ", typedProperties=" + this.typedProperties + '}';
    }
}

