/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.JGroupsConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.remoting.transport.Transport;

public class TransportConfiguration {
    public static final AttributeDefinition<String> CLUSTER_NAME = AttributeDefinition.builder("cluster", "ISPN").immutable().build();
    public static final AttributeDefinition<String> MACHINE_ID = AttributeDefinition.builder("machine", null, String.class).immutable().build();
    public static final AttributeDefinition<String> RACK_ID = AttributeDefinition.builder("rack", null, String.class).immutable().build();
    public static final AttributeDefinition<String> SITE_ID = AttributeDefinition.builder("site", null, String.class).immutable().build();
    public static final AttributeDefinition<String> NODE_NAME = AttributeDefinition.builder("nodeName", null, String.class).immutable().build();
    public static final AttributeDefinition<Long> DISTRIBUTED_SYNC_TIMEOUT = AttributeDefinition.builder("lockTimeout", Long.valueOf(TimeUnit.MINUTES.toMillis(4L))).build();
    public static final AttributeDefinition<Integer> INITIAL_CLUSTER_SIZE = AttributeDefinition.builder("initialClusterSize", Integer.valueOf(-1)).immutable().build();
    public static final AttributeDefinition<Long> INITIAL_CLUSTER_TIMEOUT = AttributeDefinition.builder("initialClusterTimeout", Long.valueOf(TimeUnit.MINUTES.toMillis(1L))).build();
    public static final AttributeDefinition<String> STACK = AttributeDefinition.builder("stack", null, String.class).build();
    public static final AttributeDefinition<String> TRANSPORT_EXECUTOR = AttributeDefinition.builder("executor", "transport-pool", String.class).build();
    public static final AttributeDefinition<String> REMOTE_EXECUTOR = AttributeDefinition.builder("remoteCommandExecutor", "remote-command-pool", String.class).build();
    private final Attribute<String> clusterName;
    private final Attribute<String> stack;
    private final Attribute<String> machineId;
    private final Attribute<String> rackId;
    private final Attribute<String> siteId;
    private final Attribute<String> nodeName;
    private final Attribute<Long> distributedSyncTimeout;
    private final Attribute<Integer> initialClusterSize;
    private final Attribute<Long> initialClusterTimeout;
    private final AttributeSet attributes;
    private final JGroupsConfiguration jgroupsConfiguration;
    private final ThreadPoolConfiguration transportThreadPool;
    private final ThreadPoolConfiguration remoteCommandThreadPool;
    private final TypedProperties properties;

    static AttributeSet attributeSet() {
        return new AttributeSet(TransportConfiguration.class, CLUSTER_NAME, MACHINE_ID, RACK_ID, SITE_ID, NODE_NAME, DISTRIBUTED_SYNC_TIMEOUT, INITIAL_CLUSTER_SIZE, INITIAL_CLUSTER_TIMEOUT, STACK, TRANSPORT_EXECUTOR, REMOTE_EXECUTOR);
    }

    TransportConfiguration(AttributeSet attributes, JGroupsConfiguration jgroupsConfiguration, ThreadPoolConfiguration transportThreadPool, ThreadPoolConfiguration remoteCommandThreadPool, TypedProperties properties) {
        this.attributes = attributes.checkProtection();
        this.jgroupsConfiguration = jgroupsConfiguration;
        this.transportThreadPool = transportThreadPool;
        this.remoteCommandThreadPool = remoteCommandThreadPool;
        this.properties = properties;
        this.clusterName = attributes.attribute(CLUSTER_NAME);
        this.stack = attributes.attribute(STACK);
        this.machineId = attributes.attribute(MACHINE_ID);
        this.rackId = attributes.attribute(RACK_ID);
        this.siteId = attributes.attribute(SITE_ID);
        this.distributedSyncTimeout = attributes.attribute(DISTRIBUTED_SYNC_TIMEOUT);
        this.initialClusterSize = attributes.attribute(INITIAL_CLUSTER_SIZE);
        this.initialClusterTimeout = attributes.attribute(INITIAL_CLUSTER_TIMEOUT);
        this.nodeName = attributes.attribute(NODE_NAME);
    }

    public String clusterName() {
        return this.clusterName.get();
    }

    public String stack() {
        return this.stack.get();
    }

    public String machineId() {
        return this.machineId.get();
    }

    public String rackId() {
        return this.rackId.get();
    }

    public String siteId() {
        return this.siteId.get();
    }

    public long distributedSyncTimeout() {
        return this.distributedSyncTimeout.get();
    }

    public int initialClusterSize() {
        return this.initialClusterSize.get();
    }

    public long initialClusterTimeout() {
        return this.initialClusterTimeout.get();
    }

    public Transport transport() {
        return this.jgroupsConfiguration.transport();
    }

    public String nodeName() {
        return this.nodeName.get();
    }

    public TypedProperties properties() {
        return this.properties;
    }

    public boolean hasTopologyInfo() {
        return this.siteId() != null || this.rackId() != null || this.machineId() != null;
    }

    @Deprecated
    public ThreadPoolConfiguration transportThreadPool() {
        return this.transportThreadPool;
    }

    @Deprecated
    public ThreadPoolConfiguration remoteCommandThreadPool() {
        return this.remoteCommandThreadPool;
    }

    public String transportThreadPoolName() {
        return this.attributes.attribute(TRANSPORT_EXECUTOR).get();
    }

    public String remoteThreadPoolName() {
        return this.attributes.attribute(REMOTE_EXECUTOR).get();
    }

    public JGroupsConfiguration jgroups() {
        return this.jgroupsConfiguration;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

