/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.JGroupsConfigurationBuilder;
import org.infinispan.configuration.global.StackBuilder;
import org.infinispan.configuration.global.StackFileConfiguration;
import org.infinispan.remoting.transport.jgroups.BuiltinJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;

public class StackFileConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements StackBuilder<StackFileConfiguration> {
    private final AttributeSet attributes = StackFileConfiguration.attributeDefinitionSet();
    private FileJGroupsChannelConfigurator configurator;

    StackFileConfigurationBuilder(String name, JGroupsConfigurationBuilder jgroups) {
        super(jgroups.getGlobalConfig());
        this.attributes.attribute(StackFileConfiguration.NAME).set(name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public StackFileConfigurationBuilder path(String name) {
        this.attributes.attribute(StackFileConfiguration.PATH).set(name);
        return this;
    }

    public StackFileConfigurationBuilder fileChannelConfigurator(FileJGroupsChannelConfigurator configurator) {
        this.configurator = configurator;
        this.attributes.attribute(StackFileConfiguration.NAME).set(configurator.getName());
        this.attributes.attribute(StackFileConfiguration.PATH).set(configurator.getPath());
        this.attributes.attribute(StackFileConfiguration.BUILTIN).set(configurator instanceof BuiltinJGroupsChannelConfigurator);
        return this;
    }

    @Override
    public StackFileConfiguration create() {
        return new StackFileConfiguration(this.attributes.protect(), this.configurator);
    }

    public StackFileConfigurationBuilder read(StackFileConfiguration template) {
        this.attributes.read(template.attributes());
        this.configurator = (FileJGroupsChannelConfigurator)template.configurator();
        return this;
    }

    @Override
    public JGroupsChannelConfigurator getConfigurator() {
        return this.configurator;
    }
}

