/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.persistence.file.SingleFileStore;

@BuiltBy(value=SingleFileStoreConfigurationBuilder.class)
@ConfigurationFor(value=SingleFileStore.class)
public class SingleFileStoreConfiguration
extends AbstractStoreConfiguration {
    public static final AttributeDefinition<String> LOCATION = AttributeDefinition.builder(Attribute.PATH, null, String.class).immutable().global(false).build();
    @Deprecated
    public static final AttributeDefinition<Integer> MAX_ENTRIES = AttributeDefinition.builder(Attribute.MAX_ENTRIES, Integer.valueOf(-1)).immutable().build();
    public static final AttributeDefinition<Float> FRAGMENTATION_FACTOR = AttributeDefinition.builder(Attribute.FRAGMENTATION_FACTOR, Float.valueOf(0.75f)).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<String> location;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> maxEntries;
    private final org.infinispan.commons.configuration.attributes.Attribute<Float> fragmentationFactor;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SingleFileStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), LOCATION, MAX_ENTRIES, FRAGMENTATION_FACTOR);
    }

    public SingleFileStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
        super(attributes, async);
        this.location = attributes.attribute(LOCATION);
        this.maxEntries = attributes.attribute(MAX_ENTRIES);
        this.fragmentationFactor = attributes.attribute(FRAGMENTATION_FACTOR);
    }

    public String location() {
        return this.location.get();
    }

    @Deprecated
    public int maxEntries() {
        return this.maxEntries.get();
    }

    public float fragmentationFactor() {
        return this.fragmentationFactor.get().floatValue();
    }

    @Override
    public String toString() {
        return "SingleFileStoreConfiguration [attributes=" + this.attributes + "]";
    }
}

