/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractTransportConfigurationChildBuilder;
import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class RecoveryConfigurationBuilder
extends AbstractTransportConfigurationChildBuilder
implements Builder<RecoveryConfiguration> {
    private final AttributeSet attributes = RecoveryConfiguration.attributeDefinitionSet();

    RecoveryConfigurationBuilder(TransactionConfigurationBuilder builder) {
        super(builder);
    }

    public RecoveryConfigurationBuilder enable() {
        this.attributes.attribute(RecoveryConfiguration.ENABLED).set(true);
        return this;
    }

    public RecoveryConfigurationBuilder disable() {
        this.attributes.attribute(RecoveryConfiguration.ENABLED).set(false);
        return this;
    }

    public RecoveryConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(RecoveryConfiguration.ENABLED).set(enabled);
        return this;
    }

    boolean isEnabled() {
        return this.attributes.attribute(RecoveryConfiguration.ENABLED).get();
    }

    public RecoveryConfigurationBuilder recoveryInfoCacheName(String recoveryInfoName) {
        this.attributes.attribute(RecoveryConfiguration.RECOVERY_INFO_CACHE_NAME).set(recoveryInfoName);
        return this;
    }

    @Override
    public void validate() {
        if (!this.attributes.attribute(RecoveryConfiguration.ENABLED).get().booleanValue()) {
            return;
        }
        if (this.transaction().transactionMode() == TransactionMode.NON_TRANSACTIONAL) {
            throw Log.CONFIG.recoveryNotSupportedWithNonTxCache();
        }
        if (this.transaction().useSynchronization()) {
            throw Log.CONFIG.recoveryNotSupportedWithSynchronization();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.validate();
    }

    @Override
    public RecoveryConfiguration create() {
        return new RecoveryConfiguration(this.attributes.protect());
    }

    public RecoveryConfigurationBuilder read(RecoveryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "RecoveryConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

