/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class ClusteringConfiguration
extends ConfigurationElement<ClusteringConfiguration> {
    public static final AttributeDefinition<CacheMode> CACHE_MODE = AttributeDefinition.builder(Attribute.MODE, CacheMode.LOCAL).immutable().build();
    public static final AttributeDefinition<Long> REMOTE_TIMEOUT = AttributeDefinition.builder(Attribute.REMOTE_TIMEOUT, Long.valueOf(TimeUnit.SECONDS.toMillis(15L))).build();
    public static final AttributeDefinition<Integer> INVALIDATION_BATCH_SIZE = AttributeDefinition.builder(Attribute.INVALIDATION_BATCH_SIZE, Integer.valueOf(128)).immutable().build();
    public static final AttributeDefinition<BiasAcquisition> BIAS_ACQUISITION = AttributeDefinition.builder(Attribute.BIAS_ACQUISITION, BiasAcquisition.ON_WRITE).immutable().build();
    public static final AttributeDefinition<Long> BIAS_LIFESPAN = AttributeDefinition.builder(Attribute.BIAS_LIFESPAN, Long.valueOf(TimeUnit.MINUTES.toMillis(5L))).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<CacheMode> cacheMode;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> remoteTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> invalidationBatchSize;
    private final HashConfiguration hashConfiguration;
    private final L1Configuration l1Configuration;
    private final StateTransferConfiguration stateTransferConfiguration;
    private final PartitionHandlingConfiguration partitionHandlingConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ClusteringConfiguration.class, CACHE_MODE, REMOTE_TIMEOUT, INVALIDATION_BATCH_SIZE, BIAS_ACQUISITION, BIAS_LIFESPAN);
    }

    ClusteringConfiguration(AttributeSet attributes, HashConfiguration hashConfiguration, L1Configuration l1Configuration, StateTransferConfiguration stateTransferConfiguration, PartitionHandlingConfiguration partitionHandlingStrategy) {
        super(Element.CLUSTERING, attributes, hashConfiguration, l1Configuration, stateTransferConfiguration, partitionHandlingStrategy);
        this.cacheMode = attributes.attribute(CACHE_MODE);
        this.remoteTimeout = attributes.attribute(REMOTE_TIMEOUT);
        this.invalidationBatchSize = attributes.attribute(INVALIDATION_BATCH_SIZE);
        this.hashConfiguration = hashConfiguration;
        this.l1Configuration = l1Configuration;
        this.stateTransferConfiguration = stateTransferConfiguration;
        this.partitionHandlingConfiguration = partitionHandlingStrategy;
    }

    public CacheMode cacheMode() {
        return this.cacheMode.get();
    }

    public long remoteTimeout() {
        return this.remoteTimeout.get();
    }

    public void remoteTimeout(long timeoutMillis) {
        this.remoteTimeout.set(timeoutMillis);
    }

    public PartitionHandlingConfiguration partitionHandling() {
        return this.partitionHandlingConfiguration;
    }

    public String cacheModeString() {
        return this.cacheMode() == null ? "none" : this.cacheMode().toString();
    }

    public int invalidationBatchSize() {
        return this.invalidationBatchSize.get();
    }

    public BiasAcquisition biasAcquisition() {
        return this.attributes.attribute(BIAS_ACQUISITION).get();
    }

    public long biasLifespan() {
        return this.attributes.attribute(BIAS_LIFESPAN).get();
    }

    public HashConfiguration hash() {
        return this.hashConfiguration;
    }

    public L1Configuration l1() {
        return this.l1Configuration;
    }

    public StateTransferConfiguration stateTransfer() {
        return this.stateTransferConfiguration;
    }
}

