/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.reactivestreams.Publisher;

public class Closeables {
    private Closeables() {
    }

    public static <E> CloseableSpliterator<E> spliterator(CloseableIterator<? extends E> iterator2, long size, int characteristics) {
        return new CloseableIteratorAsCloseableSpliterator<E>(iterator2, size, characteristics);
    }

    public static <T> CloseableSpliterator<T> spliterator(Spliterator<T> spliterator) {
        if (spliterator instanceof CloseableSpliterator) {
            return (CloseableSpliterator)spliterator;
        }
        return new SpliteratorAsCloseableSpliterator<T>(spliterator);
    }

    public static <R> CloseableSpliterator<R> spliterator(BaseStream<R, Stream<R>> stream) {
        Spliterator<R> spliterator = stream.spliterator();
        if (spliterator instanceof CloseableSpliterator) {
            return (CloseableSpliterator)spliterator;
        }
        return new StreamToCloseableSpliterator<R>(stream, spliterator);
    }

    public static <R> CloseableIterator<R> iterator(BaseStream<R, Stream<R>> stream) {
        Iterator<R> iterator2 = stream.iterator();
        if (iterator2 instanceof CloseableIterator) {
            return (CloseableIterator)iterator2;
        }
        return new StreamToCloseableIterator<R>(stream, iterator2);
    }

    public static <E> CloseableIterator<E> iterator(Iterator<? extends E> iterator2) {
        if (iterator2 instanceof CloseableIterator) {
            return (CloseableIterator)iterator2;
        }
        return new IteratorAsCloseableIterator<E>(iterator2);
    }

    public static <E> Stream<E> stream(CloseableSpliterator<E> spliterator, boolean parallel) {
        Stream<E> stream = StreamSupport.stream(spliterator, parallel);
        stream.onClose(spliterator::close);
        return stream;
    }

    public static <E> Stream<E> stream(CloseableIterator<E> iterator2, boolean parallel, long size, int characteristics) {
        Stream<E> stream = StreamSupport.stream(Spliterators.spliterator(iterator2, size, characteristics), parallel);
        stream.onClose(iterator2::close);
        return stream;
    }

    public static <E> CloseableIterator<E> iterator(Publisher<E> publisher, int fetchSize) {
        Flowable<E> flowable = Flowable.fromPublisher(publisher);
        Iterable<E> iterable = flowable.blockingIterable(fetchSize);
        final Iterator<E> iterator2 = iterable.iterator();
        return new CloseableIterator<E>(){

            @Override
            public void close() {
                ((Disposable)((Object)iterator2)).dispose();
            }

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public E next() {
                return iterator2.next();
            }
        };
    }

    private static class StreamToCloseableSpliterator<T>
    extends SpliteratorAsCloseableSpliterator<T> {
        private final BaseStream<T, Stream<T>> stream;

        public StreamToCloseableSpliterator(BaseStream<T, Stream<T>> stream, Spliterator<T> spliterator) {
            super(spliterator);
            this.stream = stream;
        }

        @Override
        public void close() {
            this.stream.close();
        }
    }

    private static class StreamToCloseableIterator<E>
    extends IteratorAsCloseableIterator<E> {
        private final BaseStream<E, Stream<E>> stream;

        public StreamToCloseableIterator(BaseStream<E, Stream<E>> stream, Iterator<E> iterator2) {
            super(iterator2);
            this.stream = stream;
        }

        @Override
        public void close() {
            this.stream.close();
        }
    }

    private static class CloseableIteratorAsCloseableSpliterator<E>
    extends SpliteratorAsCloseableSpliterator<E> {
        private final CloseableIterator<? extends E> iterator;

        CloseableIteratorAsCloseableSpliterator(CloseableIterator<? extends E> iterator2, long size, int characteristics) {
            super(Spliterators.spliterator(iterator2, size, characteristics));
            this.iterator = iterator2;
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }

    private static class SpliteratorAsCloseableSpliterator<T>
    implements CloseableSpliterator<T> {
        private final Spliterator<T> spliterator;

        public SpliteratorAsCloseableSpliterator(Spliterator<T> spliterator) {
            this.spliterator = spliterator;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.spliterator.tryAdvance(action);
        }

        @Override
        public Spliterator<T> trySplit() {
            return this.spliterator.trySplit();
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.spliterator.characteristics();
        }
    }

    private static class IteratorAsCloseableIterator<E>
    implements CloseableIterator<E> {
        private final Iterator<? extends E> iterator;

        public IteratorAsCloseableIterator(Iterator<? extends E> iterator2) {
            this.iterator = iterator2;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public E next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

