/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;

public final class WriteOnlyManyEntriesCommand<K, V, T>
extends AbstractWriteManyCommand<K, V> {
    public static final byte COMMAND_ID = 57;
    private Map<?, ?> arguments;
    private BiConsumer<T, EntryView.WriteEntryView<K, V>> f;

    public WriteOnlyManyEntriesCommand(Map<?, ?> arguments, BiConsumer<T, EntryView.WriteEntryView<K, V>> f, Params params, CommandInvocationId commandInvocationId, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(commandInvocationId, params, keyDataConversion, valueDataConversion);
        this.arguments = arguments;
        this.f = f;
    }

    public WriteOnlyManyEntriesCommand(WriteOnlyManyEntriesCommand<K, V, T> command) {
        super(command);
        this.arguments = command.arguments;
        this.f = command.f;
    }

    public WriteOnlyManyEntriesCommand() {
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        super.init(componentRegistry);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    public BiConsumer<T, EntryView.WriteEntryView<K, V>> getBiConsumer() {
        return this.f;
    }

    public Map<?, ?> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<?, ?> arguments) {
        this.arguments = arguments;
        this.internalMetadataMap.keySet().retainAll(arguments.keySet());
    }

    public final WriteOnlyManyEntriesCommand<K, V, T> withArguments(Map<?, ?> entries) {
        this.setArguments(entries);
        return this;
    }

    @Override
    public byte getCommandId() {
        return 57;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        MarshallUtil.marshallMap(this.arguments, output);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
        Params.writeObject(output, this.params);
        output.writeInt(this.topologyId);
        output.writeLong(this.flags);
        DataConversion.writeTo(output, this.keyDataConversion);
        DataConversion.writeTo(output, this.valueDataConversion);
        MarshallUtil.marshallMap(this.internalMetadataMap, output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.arguments = MarshallUtil.unmarshallMap(input, LinkedHashMap::new);
        this.f = (BiConsumer)input.readObject();
        this.isForwarded = input.readBoolean();
        this.params = Params.readObject(input);
        this.topologyId = input.readInt();
        this.flags = input.readLong();
        this.keyDataConversion = DataConversion.readFrom(input);
        this.valueDataConversion = DataConversion.readFrom(input);
        this.internalMetadataMap = MarshallUtil.unmarshallMap(input, ConcurrentHashMap::new);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.arguments.keySet();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyManyEntriesCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteOnlyManyEntriesCommand{");
        sb.append("arguments=").append(this.arguments);
        sb.append(", f=").append(this.f.getClass().getName());
        sb.append(", isForwarded=").append(this.isForwarded);
        sb.append(", keyDataConversion=").append(this.keyDataConversion);
        sb.append(", valueDataConversion=").append(this.valueDataConversion);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.arguments.keySet();
    }

    @Override
    public Mutation<K, V, ?> toMutation(Object key) {
        return new Mutations.WriteWithValue<K, V, T>(this.keyDataConversion, this.valueDataConversion, this.arguments.get(key), this.f);
    }
}

