/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.hl7.fhir.utilities.ToolingClientLogger;

public class CacheVerificationLogger
implements ToolingClientLogger {
    public static final String FHIR_TXCACHE_REBUILD = "fhir.txcache.rebuild";
    public static final String isRebuildingCache = System.getProperty("fhir.txcache.rebuild");
    int requests = 0;

    @Override
    public void logRequest(String method, String url, List<String> headers, byte[] body) {
        if (!this.isRebuildingCache()) {
            System.err.println("Unexpected request to server");
            System.err.println(method);
            System.err.println(url);
            if (headers != null) {
                for (String header : headers) {
                    System.err.println("Header: " + header);
                }
            }
            System.err.println("Body");
            System.err.println("----");
            System.err.println(new String(body, StandardCharsets.UTF_8));
        }
        ++this.requests;
    }

    @Override
    public void logResponse(String outcome, List<String> headers, byte[] body) {
    }

    @Override
    public String getLastId() {
        return null;
    }

    @Override
    public void clearLastId() {
    }

    private boolean isRebuildingCache() {
        return isRebuildingCache != null && "TRUE".equals(isRebuildingCache.toUpperCase());
    }

    public boolean verifyHasNoRequests() {
        if (this.isRebuildingCache()) {
            return true;
        }
        if (this.requests != 0) {
            System.err.println(this.requests + " unexpected TX server requests logged. If a new test has been added, you may need to rebuild the TX Cache for the test using the 'mvn test -D" + FHIR_TXCACHE_REBUILD + "=true' option");
            return false;
        }
        return true;
    }

    public int getRequests() {
        return this.requests;
    }
}

