/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils.client.network;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.utils.client.EFhirClientException;
import org.hl7.fhir.r4.utils.client.network.ByteUtils;
import org.hl7.fhir.r4.utils.client.network.FhirLoggingInterceptor;
import org.hl7.fhir.r4.utils.client.network.FhirRequestBuilder;
import org.hl7.fhir.r4.utils.client.network.ResourceRequest;
import org.hl7.fhir.utilities.ToolingClientLogger;

public class Client {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final long DEFAULT_TIMEOUT = 5000L;
    private ToolingClientLogger logger;
    private FhirLoggingInterceptor fhirLoggingInterceptor;
    private int retryCount;
    private long timeout = 5000L;

    public ToolingClientLogger getLogger() {
        return this.logger;
    }

    public void setLogger(ToolingClientLogger logger2) {
        this.logger = logger2;
        this.fhirLoggingInterceptor = new FhirLoggingInterceptor(logger2);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout2) {
        this.timeout = timeout2;
    }

    public <T extends Resource> ResourceRequest<T> issueOptionsRequest(URI optionsUri, String resourceFormat, String message, long timeout2) throws IOException {
        Request.Builder request = new Request.Builder().method("OPTIONS", null).url(optionsUri.toURL());
        return this.executeFhirRequest(request, resourceFormat, new Headers.Builder().build(), message, this.retryCount, timeout2);
    }

    public <T extends Resource> ResourceRequest<T> issueGetResourceRequest(URI resourceUri, String resourceFormat, Headers headers, String message, long timeout2) throws IOException {
        Request.Builder request = new Request.Builder().url(resourceUri.toURL());
        return this.executeFhirRequest(request, resourceFormat, headers, message, this.retryCount, timeout2);
    }

    public int tester(int trytry) {
        return 5;
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, String message, long timeout2) throws IOException {
        return this.issuePutRequest(resourceUri, payload, resourceFormat, new Headers.Builder().build(), message, timeout2);
    }

    public <T extends Resource> ResourceRequest<T> issuePutRequest(URI resourceUri, byte[] payload, String resourceFormat, Headers headers, String message, long timeout2) throws IOException {
        if (payload == null) {
            throw new EFhirClientException("PUT requests require a non-null payload");
        }
        RequestBody body = RequestBody.create(payload);
        Request.Builder request = new Request.Builder().url(resourceUri.toURL()).put(body);
        return this.executeFhirRequest(request, resourceFormat, headers, message, this.retryCount, timeout2);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, String message, long timeout2) throws IOException {
        return this.issuePostRequest(resourceUri, payload, resourceFormat, new Headers.Builder().build(), message, timeout2);
    }

    public <T extends Resource> ResourceRequest<T> issuePostRequest(URI resourceUri, byte[] payload, String resourceFormat, Headers headers, String message, long timeout2) throws IOException {
        if (payload == null) {
            throw new EFhirClientException("POST requests require a non-null payload");
        }
        RequestBody body = RequestBody.create(MediaType.parse(resourceFormat + ";charset=" + DEFAULT_CHARSET), payload);
        Request.Builder request = new Request.Builder().url(resourceUri.toURL()).post(body);
        return this.executeFhirRequest(request, resourceFormat, headers, message, this.retryCount, timeout2);
    }

    public boolean issueDeleteRequest(URI resourceUri) throws IOException {
        Request.Builder request = new Request.Builder().url(resourceUri.toURL()).delete();
        return this.executeFhirRequest(request, null, new Headers.Builder().build(), null, this.retryCount, this.timeout).isSuccessfulRequest();
    }

    public Bundle issueGetFeedRequest(URI resourceUri, String resourceFormat) throws IOException {
        Request.Builder request = new Request.Builder().url(resourceUri.toURL());
        return this.executeBundleRequest(request, resourceFormat, new Headers.Builder().build(), null, this.retryCount, this.timeout);
    }

    public Bundle issuePostFeedRequest(URI resourceUri, Map<String, String> parameters, String resourceName, Resource resource, String resourceFormat) throws IOException {
        String boundary = "----WebKitFormBoundarykbMUo6H8QaUnYtRy";
        byte[] payload = ByteUtils.encodeFormSubmission(parameters, resourceName, resource, boundary);
        RequestBody body = RequestBody.create(MediaType.parse(resourceFormat + ";charset=" + DEFAULT_CHARSET), payload);
        Request.Builder request = new Request.Builder().url(resourceUri.toURL()).post(body);
        return this.executeBundleRequest(request, resourceFormat, new Headers.Builder().build(), null, this.retryCount, this.timeout);
    }

    public Bundle postBatchRequest(URI resourceUri, byte[] payload, String resourceFormat, String message, int timeout2) throws IOException {
        if (payload == null) {
            throw new EFhirClientException("POST requests require a non-null payload");
        }
        RequestBody body = RequestBody.create(MediaType.parse(resourceFormat + ";charset=" + DEFAULT_CHARSET), payload);
        Request.Builder request = new Request.Builder().url(resourceUri.toURL()).post(body);
        return this.executeBundleRequest(request, resourceFormat, new Headers.Builder().build(), message, this.retryCount, timeout2);
    }

    public <T extends Resource> Bundle executeBundleRequest(Request.Builder request, String resourceFormat, Headers headers, String message, int retryCount, long timeout2) throws IOException {
        return new FhirRequestBuilder(request).withLogger(this.fhirLoggingInterceptor).withResourceFormat(resourceFormat).withRetryCount(retryCount).withMessage(message).withHeaders(headers == null ? new Headers.Builder().build() : headers).withTimeout(timeout2, TimeUnit.MILLISECONDS).executeAsBatch();
    }

    public <T extends Resource> ResourceRequest<T> executeFhirRequest(Request.Builder request, String resourceFormat, Headers headers, String message, int retryCount, long timeout2) throws IOException {
        return new FhirRequestBuilder(request).withLogger(this.fhirLoggingInterceptor).withResourceFormat(resourceFormat).withRetryCount(retryCount).withMessage(message).withHeaders(headers == null ? new Headers.Builder().build() : headers).withTimeout(timeout2, TimeUnit.MILLISECONDS).execute();
    }
}

