/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.Tldc;

public class TldcEnumFactory
implements EnumFactory<Tldc> {
    @Override
    public Tldc fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return Tldc.DRAFT;
        }
        if ("pending".equals(codeString)) {
            return Tldc.PENDING;
        }
        if ("active".equals(codeString)) {
            return Tldc.ACTIVE;
        }
        if ("review".equals(codeString)) {
            return Tldc.REVIEW;
        }
        if ("cancelled".equals(codeString)) {
            return Tldc.CANCELLED;
        }
        if ("rejected".equals(codeString)) {
            return Tldc.REJECTED;
        }
        if ("retired".equals(codeString)) {
            return Tldc.RETIRED;
        }
        if ("terminated".equals(codeString)) {
            return Tldc.TERMINATED;
        }
        throw new IllegalArgumentException("Unknown Tldc code '" + codeString + "'");
    }

    @Override
    public String toCode(Tldc code) {
        if (code == Tldc.DRAFT) {
            return "draft";
        }
        if (code == Tldc.PENDING) {
            return "pending";
        }
        if (code == Tldc.ACTIVE) {
            return "active";
        }
        if (code == Tldc.REVIEW) {
            return "review";
        }
        if (code == Tldc.CANCELLED) {
            return "cancelled";
        }
        if (code == Tldc.REJECTED) {
            return "rejected";
        }
        if (code == Tldc.RETIRED) {
            return "retired";
        }
        if (code == Tldc.TERMINATED) {
            return "terminated";
        }
        return "?";
    }

    @Override
    public String toSystem(Tldc code) {
        return code.getSystem();
    }
}

