/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ServiceReferralMethod {
    FAX,
    PHONE,
    ELEC,
    SEMAIL,
    MAIL,
    NULL;


    public static ServiceReferralMethod fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("fax".equals(codeString)) {
            return FAX;
        }
        if ("phone".equals(codeString)) {
            return PHONE;
        }
        if ("elec".equals(codeString)) {
            return ELEC;
        }
        if ("semail".equals(codeString)) {
            return SEMAIL;
        }
        if ("mail".equals(codeString)) {
            return MAIL;
        }
        throw new FHIRException("Unknown ServiceReferralMethod code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FAX: {
                return "fax";
            }
            case PHONE: {
                return "phone";
            }
            case ELEC: {
                return "elec";
            }
            case SEMAIL: {
                return "semail";
            }
            case MAIL: {
                return "mail";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/service-referral-method";
    }

    public String getDefinition() {
        switch (this) {
            case FAX: {
                return "Referrals may be accepted by fax.";
            }
            case PHONE: {
                return "Referrals may be accepted over the phone from a practitioner.";
            }
            case ELEC: {
                return "Referrals may be accepted via a secure messaging system. To determine the types of secure messaging systems supported, refer to the identifiers collection. Callers will need to understand the specific identifier system used to know that they are able to transmit messages.";
            }
            case SEMAIL: {
                return "Referrals may be accepted via a secure email. To send please encrypt with the services public key.";
            }
            case MAIL: {
                return "Referrals may be accepted via regular postage (or hand delivered).";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FAX: {
                return "Fax";
            }
            case PHONE: {
                return "Phone";
            }
            case ELEC: {
                return "Secure Messaging";
            }
            case SEMAIL: {
                return "Secure Email";
            }
            case MAIL: {
                return "Mail";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

