/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum OperationParameterUse {
    IN,
    OUT,
    NULL;


    public static OperationParameterUse fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("in".equals(codeString)) {
            return IN;
        }
        if ("out".equals(codeString)) {
            return OUT;
        }
        throw new FHIRException("Unknown OperationParameterUse code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case IN: {
                return "in";
            }
            case OUT: {
                return "out";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/operation-parameter-use";
    }

    public String getDefinition() {
        switch (this) {
            case IN: {
                return "This is an input parameter.";
            }
            case OUT: {
                return "This is an output parameter.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case IN: {
                return "In";
            }
            case OUT: {
                return "Out";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

