/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GuidePageGeneration {
    HTML,
    MARKDOWN,
    XML,
    GENERATED,
    NULL;


    public static GuidePageGeneration fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("html".equals(codeString)) {
            return HTML;
        }
        if ("markdown".equals(codeString)) {
            return MARKDOWN;
        }
        if ("xml".equals(codeString)) {
            return XML;
        }
        if ("generated".equals(codeString)) {
            return GENERATED;
        }
        throw new FHIRException("Unknown GuidePageGeneration code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HTML: {
                return "html";
            }
            case MARKDOWN: {
                return "markdown";
            }
            case XML: {
                return "xml";
            }
            case GENERATED: {
                return "generated";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/guide-page-generation";
    }

    public String getDefinition() {
        switch (this) {
            case HTML: {
                return "Page is proper xhtml with no templating.  Will be brought across unchanged for standard post-processing.";
            }
            case MARKDOWN: {
                return "Page is markdown with templating.  Will use the template to create a file that imports the markdown file prior to post-processing.";
            }
            case XML: {
                return "Page is xml with templating.  Will use the template to create a file that imports the source file and run the nominated XSLT transform (see parameters) if present prior to post-processing.";
            }
            case GENERATED: {
                return "Page will be generated by the publication process - no source to bring across.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HTML: {
                return "HTML";
            }
            case MARKDOWN: {
                return "Markdown";
            }
            case XML: {
                return "XML";
            }
            case GENERATED: {
                return "Generated";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

