/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Type;

@DatatypeDef(name="Range")
public class Range
extends Type
implements ICompositeType {
    @Child(name="low", type={Quantity.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Low limit", formalDefinition="The low limit. The boundary is inclusive.")
    protected Quantity low;
    @Child(name="high", type={Quantity.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="High limit", formalDefinition="The high limit. The boundary is inclusive.")
    protected Quantity high;
    private static final long serialVersionUID = -474933350L;

    public Quantity getLow() {
        if (this.low == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Range.low");
            }
            if (Configuration.doAutoCreate()) {
                this.low = new Quantity();
            }
        }
        return this.low;
    }

    public boolean hasLow() {
        return this.low != null && !this.low.isEmpty();
    }

    public Range setLow(Quantity value) {
        this.low = value;
        return this;
    }

    public Quantity getHigh() {
        if (this.high == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Range.high");
            }
            if (Configuration.doAutoCreate()) {
                this.high = new Quantity();
            }
        }
        return this.high;
    }

    public boolean hasHigh() {
        return this.high != null && !this.high.isEmpty();
    }

    public Range setHigh(Quantity value) {
        this.high = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("low", "SimpleQuantity", "The low limit. The boundary is inclusive.", 0, 1, this.low));
        children.add(new Property("high", "SimpleQuantity", "The high limit. The boundary is inclusive.", 0, 1, this.high));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 107348: {
                return new Property("low", "SimpleQuantity", "The low limit. The boundary is inclusive.", 0, 1, this.low);
            }
            case 3202466: {
                return new Property("high", "SimpleQuantity", "The high limit. The boundary is inclusive.", 0, 1, this.high);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 107348: {
                Base[] baseArray;
                if (this.low == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.low;
                }
                return baseArray;
            }
            case 3202466: {
                Base[] baseArray;
                if (this.high == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.high;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 107348: {
                this.low = this.castToQuantity(value);
                return value;
            }
            case 3202466: {
                this.high = this.castToQuantity(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("low")) {
            this.low = this.castToQuantity(value);
        } else if (name.equals("high")) {
            this.high = this.castToQuantity(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 107348: {
                return this.getLow();
            }
            case 3202466: {
                return this.getHigh();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 107348: {
                return new String[]{"SimpleQuantity"};
            }
            case 3202466: {
                return new String[]{"SimpleQuantity"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("low")) {
            this.low = new Quantity();
            return this.low;
        }
        if (name.equals("high")) {
            this.high = new Quantity();
            return this.high;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Range";
    }

    @Override
    public Range copy() {
        Range dst = new Range();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Range dst) {
        super.copyValues(dst);
        dst.low = this.low == null ? null : this.low.copy();
        dst.high = this.high == null ? null : this.high.copy();
    }

    @Override
    protected Range typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Range)) {
            return false;
        }
        Range o = (Range)other_;
        return Range.compareDeep(this.low, o.low, true) && Range.compareDeep(this.high, o.high, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Range)) {
            return false;
        }
        Range o = (Range)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.low, this.high);
    }
}

