/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.math.BigDecimal;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;

@DatatypeDef(name="id", profileOf=StringType.class)
public final class IdType
extends UriType
implements IPrimitiveType<String>,
IIdType {
    public static final String URN_PREFIX = "urn:";
    public static final int MAX_LENGTH = 64;
    private static final long serialVersionUID = 2L;
    private String myBaseUrl;
    private boolean myHaveComponentParts;
    private String myResourceType;
    private String myUnqualifiedId;
    private String myUnqualifiedVersionId;

    public IdType() {
    }

    public IdType(BigDecimal thePid) {
        if (thePid != null) {
            this.setValue(IdType.toPlainStringWithNpeThrowIfNeeded(thePid));
        } else {
            this.setValue(null);
        }
    }

    public IdType(long theId) {
        this.setValue(Long.toString(theId));
    }

    public IdType(String theValue) {
        this.setValue(theValue);
    }

    public IdType(String theResourceType, BigDecimal theIdPart) {
        this(theResourceType, IdType.toPlainStringWithNpeThrowIfNeeded(theIdPart));
    }

    public IdType(String theResourceType, Long theIdPart) {
        this(theResourceType, IdType.toPlainStringWithNpeThrowIfNeeded(theIdPart));
    }

    public IdType(String theResourceType, String theId) {
        this(theResourceType, theId, null);
    }

    public IdType(String theResourceType, String theId, String theVersionId) {
        this(null, theResourceType, theId, theVersionId);
    }

    public IdType(String theBaseUrl, String theResourceType, String theId, String theVersionId) {
        this.myBaseUrl = theBaseUrl;
        this.myResourceType = theResourceType;
        this.myUnqualifiedId = theId;
        this.myUnqualifiedVersionId = StringUtils.defaultIfBlank(theVersionId, null);
        this.myHaveComponentParts = true;
        if (StringUtils.isBlank(this.myBaseUrl) && StringUtils.isBlank(this.myResourceType) && StringUtils.isBlank(this.myUnqualifiedId) && StringUtils.isBlank(this.myUnqualifiedVersionId)) {
            this.myHaveComponentParts = false;
        }
    }

    public IdType(UriType theUrl) {
        this.setValue(theUrl.getValueAsString());
    }

    @Override
    public void applyTo(IBaseResource theResouce) {
        if (theResouce == null) {
            throw new NullPointerException("theResource can not be null");
        }
        theResouce.setId(new IdType(this.getValue()));
    }

    @Deprecated
    public BigDecimal asBigDecimal() {
        return this.getIdPartAsBigDecimal();
    }

    @Override
    public IdType copy() {
        IdType ret = new IdType(this.getValue());
        this.copyValues(ret);
        return ret;
    }

    public boolean equals(Object theArg0) {
        if (!(theArg0 instanceof IdType)) {
            return false;
        }
        return StringUtils.equals(this.getValueAsString(), ((IdType)theArg0).getValueAsString());
    }

    public boolean equalsIgnoreBase(IdType theId) {
        if (theId == null) {
            return false;
        }
        if (theId.isEmpty()) {
            return this.isEmpty();
        }
        return ObjectUtils.equals(this.getResourceType(), theId.getResourceType()) && ObjectUtils.equals(this.getIdPart(), theId.getIdPart()) && ObjectUtils.equals(this.getVersionIdPart(), theId.getVersionIdPart());
    }

    @Override
    public String fhirType() {
        return "id";
    }

    @Override
    public String getBaseUrl() {
        return this.myBaseUrl;
    }

    @Override
    public String getIdPart() {
        return this.myUnqualifiedId;
    }

    public BigDecimal getIdPartAsBigDecimal() {
        String val = this.getIdPart();
        if (StringUtils.isBlank(val)) {
            return null;
        }
        return new BigDecimal(val);
    }

    @Override
    public Long getIdPartAsLong() {
        String val = this.getIdPart();
        if (StringUtils.isBlank(val)) {
            return null;
        }
        return Long.parseLong(val);
    }

    @Override
    public String getResourceType() {
        return this.myResourceType;
    }

    @Override
    public String getValue() {
        String retVal = (String)super.getValue();
        if (retVal == null && this.myHaveComponentParts) {
            if (this.isLocal() || this.isUrn()) {
                return this.myUnqualifiedId;
            }
            StringBuilder b = new StringBuilder();
            if (StringUtils.isNotBlank(this.myBaseUrl)) {
                b.append(this.myBaseUrl);
                if (this.myBaseUrl.charAt(this.myBaseUrl.length() - 1) != '/') {
                    b.append('/');
                }
            }
            if (StringUtils.isNotBlank(this.myResourceType)) {
                b.append(this.myResourceType);
            }
            if (b.length() > 0 && StringUtils.isNotBlank(this.myUnqualifiedId)) {
                b.append('/');
            }
            if (StringUtils.isNotBlank(this.myUnqualifiedId)) {
                b.append(this.myUnqualifiedId);
            } else if (StringUtils.isNotBlank(this.myUnqualifiedVersionId)) {
                b.append('/');
            }
            if (StringUtils.isNotBlank(this.myUnqualifiedVersionId)) {
                b.append('/');
                b.append("_history");
                b.append('/');
                b.append(this.myUnqualifiedVersionId);
            }
            retVal = b.toString();
            super.setValue(retVal);
        }
        return retVal;
    }

    @Override
    public IdType setValue(String theValue) {
        super.setValue(theValue);
        this.myHaveComponentParts = false;
        if (StringUtils.isBlank(theValue)) {
            this.myBaseUrl = null;
            super.setValue((Object)null);
            this.myUnqualifiedId = null;
            this.myUnqualifiedVersionId = null;
            this.myResourceType = null;
        } else if (theValue.charAt(0) == '#' && theValue.length() > 1) {
            super.setValue(theValue);
            this.myBaseUrl = null;
            this.myUnqualifiedId = theValue;
            this.myUnqualifiedVersionId = null;
            this.myResourceType = null;
            this.myHaveComponentParts = true;
        } else if (theValue.startsWith(URN_PREFIX)) {
            this.myBaseUrl = null;
            this.myUnqualifiedId = theValue;
            this.myUnqualifiedVersionId = null;
            this.myResourceType = null;
            this.myHaveComponentParts = true;
        } else {
            int idIndex;
            int vidIndex = theValue.indexOf("/_history/");
            if (vidIndex != -1) {
                this.myUnqualifiedVersionId = theValue.substring(vidIndex + "/_history/".length());
                idIndex = theValue.lastIndexOf(47, vidIndex - 1);
                this.myUnqualifiedId = theValue.substring(idIndex + 1, vidIndex);
            } else {
                idIndex = theValue.lastIndexOf(47);
                this.myUnqualifiedId = theValue.substring(idIndex + 1);
                this.myUnqualifiedVersionId = null;
            }
            this.myBaseUrl = null;
            if (idIndex <= 0) {
                this.myResourceType = null;
            } else {
                int typeIndex = theValue.lastIndexOf(47, idIndex - 1);
                if (typeIndex == -1) {
                    this.myResourceType = theValue.substring(0, idIndex);
                } else {
                    if (typeIndex > 0 && '/' == theValue.charAt(typeIndex - 1)) {
                        typeIndex = theValue.indexOf(47, typeIndex + 1);
                    }
                    if (typeIndex >= idIndex) {
                        this.myResourceType = this.myUnqualifiedId;
                        this.myUnqualifiedId = null;
                        super.setValue((Object)null);
                        this.myHaveComponentParts = true;
                    } else {
                        this.myResourceType = theValue.substring(typeIndex + 1, idIndex);
                    }
                    if (typeIndex > 4) {
                        this.myBaseUrl = theValue.substring(0, typeIndex);
                    }
                }
            }
        }
        return this;
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    @Override
    public void setValueAsString(String theValue) {
        this.setValue(theValue);
    }

    @Override
    public String getVersionIdPart() {
        return this.myUnqualifiedVersionId;
    }

    @Override
    public Long getVersionIdPartAsLong() {
        if (!this.hasVersionIdPart()) {
            return null;
        }
        return Long.parseLong(this.getVersionIdPart());
    }

    @Override
    public boolean hasBaseUrl() {
        return StringUtils.isNotBlank(this.myBaseUrl);
    }

    @Override
    public boolean hasIdPart() {
        return StringUtils.isNotBlank(this.getIdPart());
    }

    @Override
    public boolean hasResourceType() {
        return StringUtils.isNotBlank(this.myResourceType);
    }

    @Override
    public boolean hasVersionIdPart() {
        return StringUtils.isNotBlank(this.getVersionIdPart());
    }

    @Override
    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append(this.getValueAsString());
        return b.toHashCode();
    }

    @Override
    public boolean isAbsolute() {
        if (StringUtils.isBlank(this.getValue())) {
            return false;
        }
        return IdType.isUrlAbsolute(this.getValue());
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank(this.getValue());
    }

    @Override
    public boolean isIdPartValid() {
        String id = this.getIdPart();
        if (StringUtils.isBlank(id)) {
            return false;
        }
        if (id.length() > 64) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char nextChar = id.charAt(i);
            if (nextChar >= 'a' && nextChar <= 'z' || nextChar >= 'A' && nextChar <= 'Z' || nextChar >= '0' && nextChar <= '9' || nextChar == '-' || nextChar == '.') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isIdPartValidLong() {
        return IdType.isValidLong(this.getIdPart());
    }

    @Override
    public boolean isLocal() {
        return StringUtils.defaultString(this.myUnqualifiedId).startsWith("#");
    }

    public boolean isUrn() {
        return StringUtils.defaultString(this.myUnqualifiedId).startsWith(URN_PREFIX);
    }

    @Override
    public boolean isVersionIdPartValidLong() {
        return IdType.isValidLong(this.getVersionIdPart());
    }

    @Override
    public IIdType setParts(String theBaseUrl, String theResourceType, String theIdPart, String theVersionIdPart) {
        if (StringUtils.isNotBlank(theVersionIdPart)) {
            Validate.notBlank(theResourceType, "If theVersionIdPart is populated, theResourceType and theIdPart must be populated", new Object[0]);
            Validate.notBlank(theIdPart, "If theVersionIdPart is populated, theResourceType and theIdPart must be populated", new Object[0]);
        }
        if (StringUtils.isNotBlank(theBaseUrl) && StringUtils.isNotBlank(theIdPart)) {
            Validate.notBlank(theResourceType, "If theBaseUrl is populated and theIdPart is populated, theResourceType must be populated", new Object[0]);
        }
        this.setValue(null);
        this.myBaseUrl = theBaseUrl;
        this.myResourceType = theResourceType;
        this.myUnqualifiedId = theIdPart;
        this.myUnqualifiedVersionId = StringUtils.defaultIfBlank(theVersionIdPart, null);
        this.myHaveComponentParts = true;
        return this;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    public IdType toUnqualified() {
        if (this.isLocal() || this.isUrn()) {
            return new IdType(this.getValueAsString());
        }
        return new IdType(this.getResourceType(), this.getIdPart(), this.getVersionIdPart());
    }

    @Override
    public IdType toUnqualifiedVersionless() {
        if (this.isLocal() || this.isUrn()) {
            return new IdType(this.getValueAsString());
        }
        return new IdType(this.getResourceType(), this.getIdPart());
    }

    @Override
    public IdType toVersionless() {
        if (this.isLocal() || this.isUrn()) {
            return new IdType(this.getValueAsString());
        }
        return new IdType(this.getBaseUrl(), this.getResourceType(), this.getIdPart(), null);
    }

    @Override
    public IdType withResourceType(String theResourceName) {
        if (this.isLocal() || this.isUrn()) {
            return new IdType(this.getValueAsString());
        }
        return new IdType(theResourceName, this.getIdPart(), this.getVersionIdPart());
    }

    @Override
    public IdType withServerBase(String theServerBase, String theResourceType) {
        if (this.isLocal() || this.isUrn()) {
            return new IdType(this.getValueAsString());
        }
        return new IdType(theServerBase, theResourceType, this.getIdPart(), this.getVersionIdPart());
    }

    @Override
    public IdType withVersion(String theVersion) {
        if (StringUtils.isBlank(theVersion)) {
            return this.toVersionless();
        }
        if (this.isLocal() || this.isUrn()) {
            return new IdType(this.getValueAsString());
        }
        String existingValue = this.getValue();
        int i = existingValue.indexOf("_history");
        String value = i > 1 ? existingValue.substring(0, i - 1) : existingValue;
        return new IdType(value + '/' + "_history" + '/' + theVersion);
    }

    private static boolean isUrlAbsolute(String theValue) {
        String value = theValue.toLowerCase();
        return value.startsWith("http://") || value.startsWith("https://");
    }

    private static boolean isValidLong(String id) {
        if (StringUtils.isBlank(id)) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            if (Character.isDigit(id.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static IdType newRandomUuid() {
        return new IdType("urn:uuid:" + UUID.randomUUID().toString());
    }

    public static IdType of(IBaseResource theResouce) {
        if (theResouce == null) {
            throw new NullPointerException("theResource can not be null");
        }
        IIdType retVal = theResouce.getIdElement();
        if (retVal == null) {
            return null;
        }
        if (retVal instanceof IdType) {
            return (IdType)retVal;
        }
        return new IdType(retVal.getValue());
    }

    private static String toPlainStringWithNpeThrowIfNeeded(BigDecimal theIdPart) {
        if (theIdPart == null) {
            throw new NullPointerException("BigDecimal ID can not be null");
        }
        return theIdPart.toPlainString();
    }

    private static String toPlainStringWithNpeThrowIfNeeded(Long theIdPart) {
        if (theIdPart == null) {
            throw new NullPointerException("Long ID can not be null");
        }
        return theIdPart.toString();
    }
}

