/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.BaseExtension;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Count;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Distance;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UuidType;

@DatatypeDef(name="Extension")
public class Extension
extends BaseExtension
implements IBaseExtension<Extension, Type>,
IBaseHasExtensions {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="identifies the meaning of the extension", formalDefinition="Source of the definition for the extension code - a logical name or a URL.")
    protected UriType url;
    @Child(name="value", type={}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Value of extension", formalDefinition="Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).")
    protected Type value;
    private static final long serialVersionUID = 194602931L;

    public Extension() {
    }

    public Extension(UriType url) {
        this.url = url;
    }

    public Extension(String theUrl) {
        this.setUrl(theUrl);
    }

    public Extension(String theUrl, IBaseDatatype theValue) {
        this.setUrl(theUrl);
        this.setValue(theValue);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Extension.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Extension setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public Extension setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    @Override
    public Type getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    @Override
    public Extension setValue(Type value) {
        this.value = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("url", "uri", "Source of the definition for the extension code - a logical name or a URL.", 0, 1, this.url));
        children.add(new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property("url", "uri", "Source of the definition for the extension code - a logical name or a URL.", 0, 1, this.url);
            }
            case -1410166417: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 111972721: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1535024575: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 733421943: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -786218365: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -766209282: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -766192449: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 1047929900: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -2083993440: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 231604844: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1668687056: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1668204915: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -497880704: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1410178407: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1249932027: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1424603934: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -765708322: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 26529417: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1410172357: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1410172354: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -765667124: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -478981821: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -67108992: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -475566732: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 924902896: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1887705029: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 944904545: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -2026205465: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -130498310: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1524344174: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -2029823716: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 2030761548: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 2030767386: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case 1755241690: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -962229101: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -540985785: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1406282469: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
            case -1858636920: {
                return new Property("value[x]", "*", "Value of extension - must be one of a constrained set of the data types (see [Extensibility](extensibility.html) for a list).", 0, 1, this.value);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 111972721: {
                this.value = this.castToType(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("url")) {
            this.url = this.castToUri(value);
        } else if (name.equals("value[x]")) {
            this.value = this.castToType(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1410166417: {
                return this.getValue();
            }
            case 111972721: {
                return this.getValue();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 111972721: {
                return new String[]{"*"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a primitive type Extension.url");
        }
        if (name.equals("valueBase64Binary")) {
            this.value = new Base64BinaryType();
            return this.value;
        }
        if (name.equals("valueBoolean")) {
            this.value = new BooleanType();
            return this.value;
        }
        if (name.equals("valueCanonical")) {
            this.value = new CanonicalType();
            return this.value;
        }
        if (name.equals("valueCode")) {
            this.value = new CodeType();
            return this.value;
        }
        if (name.equals("valueDate")) {
            this.value = new DateType();
            return this.value;
        }
        if (name.equals("valueDateTime")) {
            this.value = new DateTimeType();
            return this.value;
        }
        if (name.equals("valueDecimal")) {
            this.value = new DecimalType();
            return this.value;
        }
        if (name.equals("valueId")) {
            this.value = new IdType();
            return this.value;
        }
        if (name.equals("valueInstant")) {
            this.value = new InstantType();
            return this.value;
        }
        if (name.equals("valueInteger")) {
            this.value = new IntegerType();
            return this.value;
        }
        if (name.equals("valueMarkdown")) {
            this.value = new MarkdownType();
            return this.value;
        }
        if (name.equals("valueOid")) {
            this.value = new OidType();
            return this.value;
        }
        if (name.equals("valuePositiveInt")) {
            this.value = new PositiveIntType();
            return this.value;
        }
        if (name.equals("valueString")) {
            this.value = new StringType();
            return this.value;
        }
        if (name.equals("valueTime")) {
            this.value = new TimeType();
            return this.value;
        }
        if (name.equals("valueUnsignedInt")) {
            this.value = new UnsignedIntType();
            return this.value;
        }
        if (name.equals("valueUri")) {
            this.value = new UriType();
            return this.value;
        }
        if (name.equals("valueUrl")) {
            this.value = new UrlType();
            return this.value;
        }
        if (name.equals("valueUuid")) {
            this.value = new UuidType();
            return this.value;
        }
        if (name.equals("valueAddress")) {
            this.value = new Address();
            return this.value;
        }
        if (name.equals("valueAge")) {
            this.value = new Age();
            return this.value;
        }
        if (name.equals("valueAnnotation")) {
            this.value = new Annotation();
            return this.value;
        }
        if (name.equals("valueAttachment")) {
            this.value = new Attachment();
            return this.value;
        }
        if (name.equals("valueCodeableConcept")) {
            this.value = new CodeableConcept();
            return this.value;
        }
        if (name.equals("valueCoding")) {
            this.value = new Coding();
            return this.value;
        }
        if (name.equals("valueContactPoint")) {
            this.value = new ContactPoint();
            return this.value;
        }
        if (name.equals("valueCount")) {
            this.value = new Count();
            return this.value;
        }
        if (name.equals("valueDistance")) {
            this.value = new Distance();
            return this.value;
        }
        if (name.equals("valueDuration")) {
            this.value = new Duration();
            return this.value;
        }
        if (name.equals("valueHumanName")) {
            this.value = new HumanName();
            return this.value;
        }
        if (name.equals("valueIdentifier")) {
            this.value = new Identifier();
            return this.value;
        }
        if (name.equals("valueMoney")) {
            this.value = new Money();
            return this.value;
        }
        if (name.equals("valuePeriod")) {
            this.value = new Period();
            return this.value;
        }
        if (name.equals("valueQuantity")) {
            this.value = new Quantity();
            return this.value;
        }
        if (name.equals("valueRange")) {
            this.value = new Range();
            return this.value;
        }
        if (name.equals("valueRatio")) {
            this.value = new Ratio();
            return this.value;
        }
        if (name.equals("valueReference")) {
            this.value = new Reference();
            return this.value;
        }
        if (name.equals("valueSampledData")) {
            this.value = new SampledData();
            return this.value;
        }
        if (name.equals("valueSignature")) {
            this.value = new Signature();
            return this.value;
        }
        if (name.equals("valueTiming")) {
            this.value = new Timing();
            return this.value;
        }
        if (name.equals("valueContactDetail")) {
            this.value = new ContactDetail();
            return this.value;
        }
        if (name.equals("valueContributor")) {
            this.value = new Contributor();
            return this.value;
        }
        if (name.equals("valueDataRequirement")) {
            this.value = new DataRequirement();
            return this.value;
        }
        if (name.equals("valueExpression")) {
            this.value = new Expression();
            return this.value;
        }
        if (name.equals("valueParameterDefinition")) {
            this.value = new ParameterDefinition();
            return this.value;
        }
        if (name.equals("valueRelatedArtifact")) {
            this.value = new RelatedArtifact();
            return this.value;
        }
        if (name.equals("valueTriggerDefinition")) {
            this.value = new TriggerDefinition();
            return this.value;
        }
        if (name.equals("valueUsageContext")) {
            this.value = new UsageContext();
            return this.value;
        }
        if (name.equals("valueDosage")) {
            this.value = new Dosage();
            return this.value;
        }
        if (name.equals("valueMeta")) {
            this.value = new Meta();
            return this.value;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Extension";
    }

    @Override
    public Extension copy() {
        Extension dst = new Extension();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Extension dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.value = this.value == null ? null : this.value.copy();
    }

    @Override
    protected Extension typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Extension)) {
            return false;
        }
        Extension o = (Extension)other_;
        return Extension.compareDeep(this.url, o.url, true) && Extension.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Extension)) {
            return false;
        }
        Extension o = (Extension)other_;
        return Extension.compareValues(this.url, o.url, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.url, this.value);
    }
}

