/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.fuseable.QueueSubscription;
import io.reactivex.rxjava3.internal.fuseable.SimpleQueue;
import io.reactivex.rxjava3.internal.subscribers.InnerQueuedSubscriberSupport;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class InnerQueuedSubscriber<T>
extends AtomicReference<Subscription>
implements FlowableSubscriber<T>,
Subscription {
    private static final long serialVersionUID = 22876611072430776L;
    final InnerQueuedSubscriberSupport<T> parent;
    final int prefetch;
    final int limit;
    volatile SimpleQueue<T> queue;
    volatile boolean done;
    long produced;
    int fusionMode;

    public InnerQueuedSubscriber(InnerQueuedSubscriberSupport<T> parent, int prefetch) {
        this.parent = parent;
        this.prefetch = prefetch;
        this.limit = prefetch - (prefetch >> 2);
    }

    @Override
    public void onSubscribe(Subscription s2) {
        if (SubscriptionHelper.setOnce(this, s2)) {
            if (s2 instanceof QueueSubscription) {
                QueueSubscription qs = (QueueSubscription)s2;
                int m3 = qs.requestFusion(3);
                if (m3 == 1) {
                    this.fusionMode = m3;
                    this.queue = qs;
                    this.done = true;
                    this.parent.innerComplete(this);
                    return;
                }
                if (m3 == 2) {
                    this.fusionMode = m3;
                    this.queue = qs;
                    QueueDrainHelper.request(s2, this.prefetch);
                    return;
                }
            }
            this.queue = QueueDrainHelper.createQueue(this.prefetch);
            QueueDrainHelper.request(s2, this.prefetch);
        }
    }

    @Override
    public void onNext(T t) {
        if (this.fusionMode == 0) {
            this.parent.innerNext(this, t);
        } else {
            this.parent.drain();
        }
    }

    @Override
    public void onError(Throwable t) {
        this.parent.innerError(this, t);
    }

    @Override
    public void onComplete() {
        this.parent.innerComplete(this);
    }

    @Override
    public void request(long n) {
        if (this.fusionMode != 1) {
            long p = this.produced + n;
            if (p >= (long)this.limit) {
                this.produced = 0L;
                ((Subscription)this.get()).request(p);
            } else {
                this.produced = p;
            }
        }
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this);
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public SimpleQueue<T> queue() {
        return this.queue;
    }
}

