/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableDoFinally
extends Completable {
    final CompletableSource source;
    final Action onFinally;

    public CompletableDoFinally(CompletableSource source2, Action onFinally) {
        this.source = source2;
        this.onFinally = onFinally;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new DoFinallyObserver(observer, this.onFinally));
    }

    static final class DoFinallyObserver
    extends AtomicInteger
    implements CompletableObserver,
    Disposable {
        private static final long serialVersionUID = 4109457741734051389L;
        final CompletableObserver downstream;
        final Action onFinally;
        Disposable upstream;

        DoFinallyObserver(CompletableObserver actual, Action onFinally) {
            this.downstream = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
            this.runFinally();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.runFinally();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.runFinally();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }
}

