/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.impl;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.util.UrlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseHttpClientInvocation {
    private final FhirContext myContext;
    private final List<Header> myHeaders;

    public BaseHttpClientInvocation(FhirContext myContext) {
        this.myContext = myContext;
        this.myHeaders = new ArrayList<Header>();
    }

    public void addHeader(String theName, String theValue) {
        this.myHeaders.add(new Header(theName, theValue));
    }

    public abstract IHttpRequest asHttpRequest(String var1, Map<String, List<String>> var2, EncodingEnum var3, Boolean var4);

    protected IHttpRequest createHttpRequest(String theUrl, EncodingEnum theEncoding, RequestTypeEnum theRequestType) {
        IHttpClient httpClient = this.getRestfulClientFactory().getHttpClient(new StringBuilder(theUrl), null, null, theRequestType, this.myHeaders);
        return httpClient.createGetRequest(this.getContext(), theEncoding);
    }

    public FhirContext getContext() {
        return this.myContext;
    }

    public List<Header> getHeaders() {
        return this.myHeaders;
    }

    public IRestfulClientFactory getRestfulClientFactory() {
        return this.myContext.getRestfulClientFactory();
    }

    public static void appendExtraParamsWithQuestionMark(Map<String, List<String>> theExtraParams, StringBuilder theUrlBuilder, boolean theWithQuestionMark) {
        if (theExtraParams == null) {
            return;
        }
        boolean first = theWithQuestionMark;
        if (!theExtraParams.isEmpty()) {
            for (Map.Entry<String, List<String>> next : theExtraParams.entrySet()) {
                for (String nextValue : next.getValue()) {
                    if (first) {
                        theUrlBuilder.append('?');
                        first = false;
                    } else {
                        theUrlBuilder.append('&');
                    }
                    theUrlBuilder.append(UrlUtil.escapeUrlParam(next.getKey()));
                    theUrlBuilder.append('=');
                    theUrlBuilder.append(UrlUtil.escapeUrlParam(nextValue));
                }
            }
        }
    }
}

