/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.ModelScanner;
import ca.uhn.fhir.context.RuntimeChildAny;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildCompositeBoundDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeChildDirectResource;
import ca.uhn.fhir.context.RuntimeChildExtension;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveBoundCodeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildPrimitiveEnumerationDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeChildResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IBoundCodeableConcept;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.model.base.composite.BaseNarrativeDt;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.INarrative;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRuntimeElementCompositeDefinition<T extends IBase>
extends BaseRuntimeElementDefinition<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseRuntimeElementCompositeDefinition.class);
    private final FhirContext myContext;
    private Map<String, Integer> forcedOrder = null;
    private List<BaseRuntimeChildDefinition> myChildren = new ArrayList<BaseRuntimeChildDefinition>();
    private List<BaseRuntimeChildDefinition> myChildrenAndExtensions;
    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myClassToElementDefinitions;
    private Map<String, BaseRuntimeChildDefinition> myNameToChild = new HashMap<String, BaseRuntimeChildDefinition>();
    private List<ScannedField> myScannedFields = new ArrayList<ScannedField>();
    private volatile SealingStateEnum mySealed = SealingStateEnum.NOT_SEALED;

    /*
     * WARNING - void declaration
     */
    public BaseRuntimeElementCompositeDefinition(String theName, Class<? extends T> theImplementingClass, boolean theStandardType, FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        super(theName, theImplementingClass, theStandardType);
        this.myContext = theContext;
        this.myClassToElementDefinitions = theClassToElementDefinitions;
        Class<T> current = theImplementingClass;
        LinkedList<Class<T>> classes = new LinkedList<Class<T>>();
        do {
            ChildOrder childOrder;
            if (this.forcedOrder == null && (childOrder = current.getAnnotation(ChildOrder.class)) != null) {
                this.forcedOrder = new HashMap<String, Integer>();
                for (int i = 0; i < childOrder.names().length; ++i) {
                    void var10_11;
                    String string = childOrder.names()[i];
                    if (string.endsWith("[x]")) {
                        String string2 = string.substring(0, string.length() - 3);
                    }
                    this.forcedOrder.put((String)var10_11, i);
                }
            }
            classes.push(current);
        } while ((current = IBase.class.isAssignableFrom(current.getSuperclass()) ? current.getSuperclass() : null) != null);
        HashSet<Field> fields = new HashSet<Field>();
        for (Class clazz : classes) {
            int fieldIndexInClass = 0;
            for (Field next : clazz.getDeclaredFields()) {
                ScannedField scannedField;
                if (!fields.add(next) || (scannedField = new ScannedField(next, theImplementingClass, fieldIndexInClass == 0)).getChildAnnotation() == null) continue;
                this.myScannedFields.add(scannedField);
                ++fieldIndexInClass;
            }
        }
    }

    void addChild(BaseRuntimeChildDefinition theNext) {
        if (theNext == null) {
            throw new NullPointerException(Msg.code(1698));
        }
        if (theNext.getExtensionUrl() != null) {
            throw new IllegalArgumentException(Msg.code(1699) + "Shouldn't haven an extension URL, use addExtension instead");
        }
        this.myChildren.add(theNext);
    }

    @Override
    public BaseRuntimeChildDefinition getChildByName(String theName) {
        this.validateSealed();
        return this.myNameToChild.get(theName);
    }

    public BaseRuntimeChildDefinition getChildByNameOrThrowDataFormatException(String theName) throws DataFormatException {
        this.validateSealed();
        BaseRuntimeChildDefinition retVal = this.myNameToChild.get(theName);
        if (retVal == null) {
            throw new DataFormatException(Msg.code(1700) + "Unknown child name '" + theName + "' in element " + this.getName() + " - Valid names are: " + new TreeSet<String>(this.myNameToChild.keySet()));
        }
        return retVal;
    }

    @Override
    public List<BaseRuntimeChildDefinition> getChildren() {
        this.validateSealed();
        return this.myChildren;
    }

    public List<BaseRuntimeChildDefinition> getChildrenAndExtension() {
        this.validateSealed();
        return this.myChildrenAndExtensions;
    }

    public boolean isSealed() {
        return this.mySealed == SealingStateEnum.SEALED;
    }

    void populateScanAlso(Set<Class<? extends IBase>> theScanAlso) {
        for (ScannedField next : this.myScannedFields) {
            if (IBase.class.isAssignableFrom(next.getElementType()) && !next.getElementType().isInterface() && !Modifier.isAbstract(next.getElementType().getModifiers())) {
                theScanAlso.add(next.getElementType());
            }
            for (Class<? extends IBase> nextChildType : next.getChoiceTypes()) {
                if (nextChildType.isInterface() || Modifier.isAbstract(nextChildType.getModifiers())) continue;
                theScanAlso.add(nextChildType);
            }
        }
    }

    private void scanCompositeElementForChildren() {
        HashSet<String> elementNames = new HashSet<String>();
        TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> orderToElementDef = new TreeMap<Integer, BaseRuntimeDeclaredChildDefinition>();
        TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> orderToExtensionDef = new TreeMap<Integer, BaseRuntimeDeclaredChildDefinition>();
        this.scanCompositeElementForChildren(elementNames, orderToElementDef, orderToExtensionDef);
        if (this.forcedOrder != null) {
            TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> newOrderToExtensionDef = new TreeMap<Integer, BaseRuntimeDeclaredChildDefinition>();
            int unknownCount = 0;
            for (BaseRuntimeDeclaredChildDefinition nextEntry : orderToElementDef.values()) {
                if (this.forcedOrder.containsKey(nextEntry.getElementName())) continue;
                newOrderToExtensionDef.put(unknownCount, nextEntry);
                ++unknownCount;
            }
            for (BaseRuntimeDeclaredChildDefinition nextEntry : orderToElementDef.values()) {
                if (!this.forcedOrder.containsKey(nextEntry.getElementName())) continue;
                Integer newOrder = this.forcedOrder.get(nextEntry.getElementName());
                newOrderToExtensionDef.put(newOrder + unknownCount, nextEntry);
            }
            orderToElementDef = newOrderToExtensionDef;
        }
        TreeSet<Integer> orders = new TreeSet<Integer>();
        orders.addAll(orderToElementDef.keySet());
        orders.addAll(orderToExtensionDef.keySet());
        for (Integer i : orders) {
            BaseRuntimeDeclaredChildDefinition nextExt;
            BaseRuntimeChildDefinition nextChild = orderToElementDef.get(i);
            if (nextChild != null) {
                this.addChild(nextChild);
            }
            if ((nextExt = orderToExtensionDef.get(i)) == null) continue;
            this.addExtension((RuntimeChildDeclaredExtensionDefinition)nextExt);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scanCompositeElementForChildren(Set<String> elementNames, TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> theOrderToElementDef, TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> theOrderToExtensionDef) {
        int baseElementOrder = 0;
        for (ScannedField next : this.myScannedFields) {
            BaseRuntimeDeclaredChildDefinition def;
            if (next.isFirstFieldInNewClass()) {
                baseElementOrder = theOrderToElementDef.isEmpty() ? 0 : theOrderToElementDef.lastEntry().getKey() + 1;
            }
            Class<?> declaringClass = next.getField().getDeclaringClass();
            Description descriptionAnnotation = ModelScanner.pullAnnotation(next.getField(), Description.class);
            TreeMap<Integer, BaseRuntimeDeclaredChildDefinition> orderMap = theOrderToElementDef;
            Extension extensionAttr = ModelScanner.pullAnnotation(next.getField(), Extension.class);
            if (extensionAttr != null) {
                orderMap = theOrderToExtensionDef;
            }
            Child childAnnotation = next.getChildAnnotation();
            Field nextField = next.getField();
            String elementName = childAnnotation.name();
            int order = childAnnotation.order();
            boolean childIsChoiceType = false;
            boolean orderIsReplaceParent = false;
            BaseRuntimeChildDefinition replacedParent = null;
            if (order == -2) {
                BaseRuntimeDeclaredChildDefinition nextDef;
                if (extensionAttr != null) {
                    for (Map.Entry<Integer, BaseRuntimeDeclaredChildDefinition> nextEntry : orderMap.entrySet()) {
                        nextDef = nextEntry.getValue();
                        if (!(nextDef instanceof RuntimeChildDeclaredExtensionDefinition) || !nextDef.getExtensionUrl().equals(extensionAttr.url())) continue;
                        orderIsReplaceParent = true;
                        order = nextEntry.getKey();
                        replacedParent = orderMap.remove(nextEntry.getKey());
                        elementNames.remove(elementName);
                        break;
                    }
                    if (order == -2) {
                        throw new ConfigurationException(Msg.code(1701) + "Field " + nextField.getName() + "' on target type " + declaringClass.getSimpleName() + " has order() of REPLACE_PARENT (-2) but no parent element with extension URL " + extensionAttr.url() + " could be found on type " + nextField.getDeclaringClass().getSimpleName());
                    }
                } else {
                    for (Map.Entry<Integer, BaseRuntimeDeclaredChildDefinition> nextEntry : orderMap.entrySet()) {
                        BaseRuntimeDeclaredChildDefinition existing;
                        nextDef = nextEntry.getValue();
                        if (!elementName.equals(nextDef.getElementName())) continue;
                        orderIsReplaceParent = true;
                        order = nextEntry.getKey();
                        replacedParent = existing = orderMap.remove(nextEntry.getKey());
                        elementNames.remove(elementName);
                        if (!(existing instanceof RuntimeChildChoiceDefinition)) break;
                        childIsChoiceType = true;
                        break;
                    }
                    if (order == -2) {
                        throw new ConfigurationException(Msg.code(1702) + "Field " + nextField.getName() + "' on target type " + declaringClass.getSimpleName() + " has order() of REPLACE_PARENT (-2) but no parent element with name " + elementName + " could be found on type " + nextField.getDeclaringClass().getSimpleName());
                    }
                }
            }
            if (order < 0 && order != -1) {
                throw new ConfigurationException(Msg.code(1703) + "Invalid order '" + order + "' on @Child for field '" + nextField.getName() + "' on target type: " + declaringClass);
            }
            if (order != -1 && !orderIsReplaceParent) {
                order += baseElementOrder;
            }
            if (order == -1) {
                order = 0;
                while (orderMap.containsKey(order)) {
                    ++order;
                }
            }
            List<Class<? extends IBase>> choiceTypes = next.getChoiceTypes();
            if (orderMap.containsKey(order)) {
                throw new ConfigurationException(Msg.code(1704) + "Detected duplicate field order '" + childAnnotation.order() + "' for element named '" + elementName + "' in type '" + declaringClass.getCanonicalName() + "' - Already had: " + orderMap.get(order).getElementName());
            }
            if (elementNames.contains(elementName)) {
                throw new ConfigurationException(Msg.code(1705) + "Detected duplicate field name '" + elementName + "' in type '" + declaringClass.getCanonicalName() + "'");
            }
            Class<?> nextElementType = next.getElementType();
            if (childAnnotation.name().equals("extension") && IBaseExtension.class.isAssignableFrom(nextElementType)) {
                def = new RuntimeChildExtension(nextField, childAnnotation.name(), childAnnotation, descriptionAnnotation);
            } else if (childAnnotation.name().equals("modifierExtension") && IBaseExtension.class.isAssignableFrom(nextElementType)) {
                def = new RuntimeChildExtension(nextField, childAnnotation.name(), childAnnotation, descriptionAnnotation);
            } else if (BaseContainedDt.class.isAssignableFrom(nextElementType) || childAnnotation.name().equals("contained") && IBaseResource.class.isAssignableFrom(nextElementType)) {
                def = new RuntimeChildContainedResources(nextField, childAnnotation, descriptionAnnotation, elementName);
            } else if (IAnyResource.class.isAssignableFrom(nextElementType) || IResource.class.equals(nextElementType)) {
                def = new RuntimeChildDirectResource(nextField, childAnnotation, descriptionAnnotation, elementName);
            } else {
                if (extensionAttr == null && (childIsChoiceType |= choiceTypes.size() > 1) && !BaseResourceReferenceDt.class.isAssignableFrom(nextElementType) && !IBaseReference.class.isAssignableFrom(nextElementType)) {
                    def = new RuntimeChildChoiceDefinition(nextField, elementName, childAnnotation, descriptionAnnotation, choiceTypes);
                } else if (extensionAttr != null) {
                    void var22_25;
                    Class<?> et = nextElementType;
                    Object var22_23 = null;
                    if (BoundCodeDt.class.isAssignableFrom(nextElementType) || IBoundCodeableConcept.class.isAssignableFrom(nextElementType)) {
                        IValueSetEnumBinder<Enum<?>> iValueSetEnumBinder = ModelScanner.getBoundCodeBinder(nextField);
                    }
                    def = new RuntimeChildDeclaredExtensionDefinition(nextField, childAnnotation, descriptionAnnotation, extensionAttr, elementName, extensionAttr.url(), et, var22_25);
                    if (IBaseEnumeration.class.isAssignableFrom(nextElementType)) {
                        ((RuntimeChildDeclaredExtensionDefinition)def).setEnumerationType(ReflectionUtil.getGenericCollectionTypeOfFieldWithSecondOrderForList(nextField));
                    }
                } else if (BaseResourceReferenceDt.class.isAssignableFrom(nextElementType) || IBaseReference.class.isAssignableFrom(nextElementType)) {
                    ArrayList<Class<? extends IBaseResource>> refTypesList = new ArrayList<Class<? extends IBaseResource>>();
                    for (Class<? extends IElement> nextType : childAnnotation.type()) {
                        if (IBaseReference.class.isAssignableFrom(nextType)) {
                            refTypesList.add(this.myContext.getVersion().getVersion().isRi() ? IAnyResource.class : IResource.class);
                            continue;
                        }
                        if (!IBaseResource.class.isAssignableFrom(nextType)) {
                            throw new ConfigurationException(Msg.code(1706) + "Field '" + nextField.getName() + "' in class '" + nextField.getDeclaringClass().getCanonicalName() + "' is of type " + BaseResourceReferenceDt.class + " but contains a non-resource type: " + nextType.getCanonicalName());
                        }
                        refTypesList.add(nextType);
                    }
                    def = new RuntimeChildResourceDefinition(nextField, elementName, childAnnotation, descriptionAnnotation, refTypesList);
                } else if (IResourceBlock.class.isAssignableFrom(nextElementType) || IBaseBackboneElement.class.isAssignableFrom(nextElementType) || IBaseDatatypeElement.class.isAssignableFrom(nextElementType)) {
                    Class<?> blockDef = nextElementType;
                    def = new RuntimeChildResourceBlockDefinition(this.myContext, nextField, childAnnotation, descriptionAnnotation, elementName, blockDef);
                } else if (IDatatype.class.equals(nextElementType) || IElement.class.equals(nextElementType) || "Type".equals(nextElementType.getSimpleName()) || IBaseDatatype.class.equals(nextElementType)) {
                    def = new RuntimeChildAny(nextField, elementName, childAnnotation, descriptionAnnotation);
                } else if (IDatatype.class.isAssignableFrom(nextElementType) || IPrimitiveType.class.isAssignableFrom(nextElementType) || ICompositeType.class.isAssignableFrom(nextElementType) || IBaseDatatype.class.isAssignableFrom(nextElementType) || IBaseExtension.class.isAssignableFrom(nextElementType)) {
                    Class<?> nextDatatype = nextElementType;
                    if (IPrimitiveType.class.isAssignableFrom(nextElementType)) {
                        if (nextElementType.equals(BoundCodeDt.class)) {
                            IValueSetEnumBinder<Enum<?>> iValueSetEnumBinder = ModelScanner.getBoundCodeBinder(nextField);
                            Class<? extends Enum<?>> enumType = ModelScanner.determineEnumTypeForBoundField(nextField);
                            def = new RuntimeChildPrimitiveBoundCodeDatatypeDefinition(nextField, elementName, childAnnotation, descriptionAnnotation, nextDatatype, iValueSetEnumBinder, enumType);
                        } else if (IBaseEnumeration.class.isAssignableFrom(nextElementType)) {
                            Class<? extends Enum<?>> clazz = ModelScanner.determineEnumTypeForBoundField(nextField);
                            def = new RuntimeChildPrimitiveEnumerationDatatypeDefinition(nextField, elementName, childAnnotation, descriptionAnnotation, nextDatatype, clazz);
                        } else {
                            def = new RuntimeChildPrimitiveDatatypeDefinition(nextField, elementName, descriptionAnnotation, childAnnotation, nextDatatype);
                        }
                    } else if (IBoundCodeableConcept.class.isAssignableFrom(nextElementType)) {
                        IValueSetEnumBinder<Enum<?>> iValueSetEnumBinder = ModelScanner.getBoundCodeBinder(nextField);
                        Class<? extends Enum<?>> enumType = ModelScanner.determineEnumTypeForBoundField(nextField);
                        def = new RuntimeChildCompositeBoundDatatypeDefinition(nextField, elementName, childAnnotation, descriptionAnnotation, nextDatatype, iValueSetEnumBinder, enumType);
                    } else {
                        def = BaseNarrativeDt.class.isAssignableFrom(nextElementType) || INarrative.class.isAssignableFrom(nextElementType) ? new RuntimeChildNarrativeDefinition(nextField, elementName, childAnnotation, descriptionAnnotation, nextDatatype) : new RuntimeChildCompositeDatatypeDefinition(nextField, elementName, childAnnotation, descriptionAnnotation, nextDatatype);
                    }
                } else {
                    throw new ConfigurationException(Msg.code(1707) + "Field '" + elementName + "' in type '" + declaringClass.getCanonicalName() + "' is not a valid child type: " + nextElementType);
                }
                Binding bindingAnnotation = ModelScanner.pullAnnotation(nextField, Binding.class);
                if (bindingAnnotation != null && StringUtils.isNotBlank(bindingAnnotation.valueSet())) {
                    def.setBindingValueSet(bindingAnnotation.valueSet());
                }
            }
            def.setReplacedParentDefinition(replacedParent);
            orderMap.put(order, def);
            elementNames.add(elementName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        if (this.mySealed == SealingStateEnum.SEALED) {
            return;
        }
        FhirContext fhirContext = this.myContext;
        synchronized (fhirContext) {
            if (this.mySealed == SealingStateEnum.SEALED || this.mySealed == SealingStateEnum.SEALING) {
                return;
            }
            this.mySealed = SealingStateEnum.SEALING;
            this.scanCompositeElementForChildren();
            super.sealAndInitialize(theContext, theClassToElementDefinitions);
            for (BaseRuntimeChildDefinition next : this.myChildren) {
                next.sealAndInitialize(theContext, theClassToElementDefinitions);
            }
            this.myNameToChild = new HashMap<String, BaseRuntimeChildDefinition>();
            for (BaseRuntimeChildDefinition next : this.myChildren) {
                if (next instanceof RuntimeChildChoiceDefinition) {
                    String key = next.getElementName() + "[x]";
                    this.myNameToChild.put(key, next);
                }
                for (String nextName : next.getValidChildNames()) {
                    if (this.myNameToChild.containsKey(nextName)) {
                        throw new ConfigurationException(Msg.code(1708) + "Duplicate child name[" + nextName + "] in Element[" + this.getName() + "]");
                    }
                    this.myNameToChild.put(nextName, next);
                }
            }
            this.myChildren = Collections.unmodifiableList(this.myChildren);
            this.myNameToChild = Collections.unmodifiableMap(this.myNameToChild);
            ArrayList<BaseRuntimeChildDefinition> children = new ArrayList<BaseRuntimeChildDefinition>();
            children.addAll(this.myChildren);
            if (theContext.getVersion().getVersion() == FhirVersionEnum.DSTU2) {
                int extIndex = BaseRuntimeElementCompositeDefinition.findIndex(children, "extension", false);
                int containedIndex = BaseRuntimeElementCompositeDefinition.findIndex(children, "contained", false);
                if (containedIndex != -1 && extIndex != -1 && extIndex < containedIndex) {
                    BaseRuntimeChildDefinition extension = (BaseRuntimeChildDefinition)children.remove(extIndex);
                    if (containedIndex > children.size()) {
                        children.add(extension);
                    } else {
                        children.add(containedIndex, extension);
                    }
                    int modIndex = BaseRuntimeElementCompositeDefinition.findIndex(children, "modifierExtension", false);
                    if (modIndex < containedIndex) {
                        extension = (BaseRuntimeChildDefinition)children.remove(modIndex);
                        if (containedIndex > children.size()) {
                            children.add(extension);
                        } else {
                            children.add(containedIndex, extension);
                        }
                    }
                }
            }
            if (!this.getExtensionsNonModifier().isEmpty()) {
                children.addAll(BaseRuntimeElementCompositeDefinition.findIndex(children, "extension", true), this.getExtensionsNonModifier());
            }
            if (!this.getExtensionsModifier().isEmpty()) {
                children.addAll(BaseRuntimeElementCompositeDefinition.findIndex(children, "modifierExtension", true), this.getExtensionsModifier());
            }
            this.myChildrenAndExtensions = Collections.unmodifiableList(children);
            this.mySealed = SealingStateEnum.SEALED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateSealed() {
        if (this.mySealed != SealingStateEnum.SEALED) {
            FhirContext fhirContext = this.myContext;
            synchronized (fhirContext) {
                if (this.mySealed == SealingStateEnum.NOT_SEALED) {
                    this.sealAndInitialize(this.myContext, this.myClassToElementDefinitions);
                }
            }
        }
    }

    private static int findIndex(List<BaseRuntimeChildDefinition> theChildren, String theName, boolean theDefaultAtEnd) {
        int index = theDefaultAtEnd ? theChildren.size() : -1;
        ListIterator<BaseRuntimeChildDefinition> iter = theChildren.listIterator();
        while (iter.hasNext()) {
            if (!iter.next().getElementName().equals(theName)) continue;
            index = iter.previousIndex();
            break;
        }
        return index;
    }

    private static enum SealingStateEnum {
        NOT_SEALED,
        SEALING,
        SEALED;

    }

    private static class ScannedField {
        private Child myChildAnnotation;
        private List<Class<? extends IBase>> myChoiceTypes = new ArrayList<Class<? extends IBase>>();
        private Class<?> myElementType;
        private Field myField;
        private boolean myFirstFieldInNewClass;

        ScannedField(Field theField, Class<?> theClass, boolean theFirstFieldInNewClass) {
            this.myField = theField;
            this.myFirstFieldInNewClass = theFirstFieldInNewClass;
            Child childAnnotation = ModelScanner.pullAnnotation(theField, Child.class);
            if (childAnnotation == null) {
                ourLog.trace("Ignoring non @Child field {} on target type {}", (Object)theField.getName(), (Object)theClass);
                return;
            }
            if (Modifier.isFinal(theField.getModifiers())) {
                ourLog.trace("Ignoring constant {} on target type {}", (Object)theField.getName(), (Object)theClass);
                return;
            }
            this.myChildAnnotation = childAnnotation;
            this.myElementType = ModelScanner.determineElementType(theField);
            Collections.addAll(this.myChoiceTypes, childAnnotation.type());
        }

        public Child getChildAnnotation() {
            return this.myChildAnnotation;
        }

        public List<Class<? extends IBase>> getChoiceTypes() {
            return this.myChoiceTypes;
        }

        public Class<?> getElementType() {
            return this.myElementType;
        }

        public Field getField() {
            return this.myField;
        }

        public boolean isFirstFieldInNewClass() {
            return this.myFirstFieldInNewClass;
        }

        public String toString() {
            return this.myField.getName();
        }
    }
}

