/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology.mock;

import au.csiro.pathling.terminology.TerminologyService;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.codesystems.ConceptMapEquivalence;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;

public class MockTerminologyService
implements TerminologyService {
    private final Map<String, ValueSet> valueSets = new HashMap<String, ValueSet>();
    private final Map<String, ConceptMap> conceptMap = new HashMap<String, ConceptMap>();
    private final Set<Pair<SystemAndCode, SystemAndCode>> subsumes = new HashSet<Pair<SystemAndCode, SystemAndCode>>();

    public MockTerminologyService() {
        this.valueSets.put("http://snomed.info/sct?fhir_vs=refset/723264001", new ValueSet(new Coding("http://snomed.info/sct", "368529001", null)));
        this.valueSets.put("http://loinc.org/vs/LP14885-5", new ValueSet(new Coding("http://loinc.org", "55915-3", null)));
        this.subsumes.add(Pair.of(new SystemAndCode("http://snomed.info/sct", "107963000"), new SystemAndCode("http://snomed.info/sct", "63816008")));
        this.conceptMap.put("http://snomed.info/sct?fhir_cm=100", new ConceptMap(ImmutableMap.of(new SystemAndCode("http://snomed.info/sct", "368529001"), List.of(TerminologyService.Translation.of(ConceptMapEquivalence.EQUIVALENT, new Coding("http://snomed.info/sct", "368529002", null)), TerminologyService.Translation.of(ConceptMapEquivalence.RELATEDTO, new Coding("http://loinc.org", "55916-3", null)))), Collections.emptyMap()));
        this.conceptMap.put("http://snomed.info/sct?fhir_cm=200", new ConceptMap(Collections.emptyMap(), ImmutableMap.of(new SystemAndCode("http://loinc.org", "55915-3"), List.of(TerminologyService.Translation.of(ConceptMapEquivalence.RELATEDTO, new Coding("http://snomed.info/sct", "368529002", null)), TerminologyService.Translation.of(ConceptMapEquivalence.EQUIVALENT, new Coding("http://loinc.org", "55916-3", null))))));
    }

    @Override
    public boolean validateCode(@Nonnull String codeSystemUrl, @Nonnull Coding coding) {
        return this.valueSets.getOrDefault(codeSystemUrl, ValueSet.EMPTY).contains(coding);
    }

    @Override
    @Nonnull
    public List<TerminologyService.Translation> translate(@Nonnull Coding coding, @Nonnull String conceptMapUrl, boolean reverse, @Nullable String target) {
        return this.conceptMap.getOrDefault(conceptMapUrl, ConceptMap.EMPTY).translate(coding, reverse, target);
    }

    @Override
    @Nonnull
    public ConceptSubsumptionOutcome subsumes(@Nonnull Coding codingA, @Nonnull Coding codingB) {
        SystemAndCode systemAndCodeB;
        SystemAndCode systemAndCodeA = SystemAndCode.of(codingA);
        if (systemAndCodeA.equals(systemAndCodeB = SystemAndCode.of(codingB))) {
            return ConceptSubsumptionOutcome.EQUIVALENT;
        }
        if (this.subsumes.contains(Pair.of(systemAndCodeA, systemAndCodeB))) {
            return ConceptSubsumptionOutcome.SUBSUMES;
        }
        if (this.subsumes.contains(Pair.of(systemAndCodeB, systemAndCodeA))) {
            return ConceptSubsumptionOutcome.SUBSUMEDBY;
        }
        return ConceptSubsumptionOutcome.NOTSUBSUMED;
    }

    @Override
    @Nonnull
    public List<TerminologyService.PropertyOrDesignation> lookup(@Nonnull Coding coding, @Nullable String propertyCode) {
        Coding snomedCoding = new Coding("http://snomed.info/sct", "439319006", "Screening for phenothiazine in serum");
        Coding loincCoding = new Coding("http://loinc.org", "55915-3", null);
        Coding useDisplay = new Coding("http://terminology.hl7.org/CodeSystem/designation-usage", "display", null);
        Coding useFullySpecifiedName = new Coding("http://snomed.info/sct", "900000000000003001", "Fully specified name");
        if (SystemAndCode.of(snomedCoding).equals(SystemAndCode.of(coding))) {
            return List.of(TerminologyService.Property.of("display", new StringType(snomedCoding.getDisplay())), TerminologyService.Property.of("parent", new CodeType("785673007")), TerminologyService.Property.of("parent", new CodeType("74754006")), TerminologyService.Designation.of(useDisplay, "en", "Screening for phenothiazine in serum"), TerminologyService.Designation.of(useFullySpecifiedName, "en", "Screening for phenothiazine in serum (procedure)"));
        }
        if (SystemAndCode.of(loincCoding).equals(SystemAndCode.of(coding))) {
            return List.of(TerminologyService.Property.of("inactive", new BooleanType(false)), TerminologyService.Designation.of(useDisplay, "en", "Beta 2 globulin [Mass/volume] in Cerebral spinal fluid by Electrophoresis"), TerminologyService.Designation.of(useDisplay, "fr-FR", "B\u00eata-2 globulines [Masse/Volume] Liquide c\u00e9phalorachidien"), TerminologyService.Designation.of(useFullySpecifiedName, "fr-FR", "Beta 2 globulin:MCnc:Pt:CSF:Qn:Electrophoresis"));
        }
        return Collections.emptyList();
    }

    static class ValueSet {
        private final Set<SystemAndCode> members;
        public static final ValueSet EMPTY = new ValueSet(new Coding[0]);

        ValueSet(Coding ... coding) {
            this.members = Stream.of(coding).map(SystemAndCode::of).collect(Collectors.toUnmodifiableSet());
        }

        boolean contains(@Nonnull Coding coding) {
            return this.members.contains(SystemAndCode.of(coding));
        }
    }

    static class ConceptMap {
        public static final ConceptMap EMPTY = new ConceptMap(Collections.emptyMap(), Collections.emptyMap());
        private final Map<SystemAndCode, List<TerminologyService.Translation>> mappings;
        private final Map<SystemAndCode, List<TerminologyService.Translation>> invertedMappings;

        ConceptMap(Map<SystemAndCode, List<TerminologyService.Translation>> mappings, Map<SystemAndCode, List<TerminologyService.Translation>> invertedMappings) {
            this.mappings = mappings;
            this.invertedMappings = invertedMappings;
        }

        public List<TerminologyService.Translation> translate(Coding coding, boolean reverse, String target) {
            return (reverse ? this.invertedMappings : this.mappings).getOrDefault(SystemAndCode.of(coding), Collections.emptyList()).stream().filter(c -> Objects.isNull(target) || target.equals(c.getConcept().getSystem())).collect(Collectors.toUnmodifiableList());
        }
    }

    static final class SystemAndCode {
        @Nonnull
        private final String system;
        @Nonnull
        private final String code;

        static SystemAndCode of(@Nonnull Coding coding) {
            return new SystemAndCode(coding.getSystem(), coding.getCode());
        }

        @Nonnull
        public String getSystem() {
            return this.system;
        }

        @Nonnull
        public String getCode() {
            return this.code;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SystemAndCode)) {
                return false;
            }
            SystemAndCode other = (SystemAndCode)o;
            String this$system = this.getSystem();
            String other$system = other.getSystem();
            if (this$system == null ? other$system != null : !this$system.equals(other$system)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            return !(this$code == null ? other$code != null : !this$code.equals(other$code));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $system = this.getSystem();
            result = result * 59 + ($system == null ? 43 : $system.hashCode());
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            return result;
        }

        public String toString() {
            return "MockTerminologyService.SystemAndCode(system=" + this.getSystem() + ", code=" + this.getCode() + ")";
        }

        public SystemAndCode(@Nonnull String system, @Nonnull String code) {
            if (system == null) {
                throw new NullPointerException("system is marked non-null but is null");
            }
            if (code == null) {
                throw new NullPointerException("code is marked non-null but is null");
            }
            this.system = system;
            this.code = code;
        }
    }
}

