/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology.caching;

import au.csiro.pathling.config.HttpClientCachingConfiguration;
import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import au.csiro.pathling.terminology.BaseTerminologyService;
import au.csiro.pathling.terminology.TerminologyOperation;
import au.csiro.pathling.terminology.TerminologyParameters;
import au.csiro.pathling.terminology.TerminologyResult;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.lookup.LookupExecutor;
import au.csiro.pathling.terminology.lookup.LookupParameters;
import au.csiro.pathling.terminology.subsumes.SubsumesExecutor;
import au.csiro.pathling.terminology.subsumes.SubsumesParameters;
import au.csiro.pathling.terminology.translate.TranslateExecutor;
import au.csiro.pathling.terminology.translate.TranslateParameters;
import au.csiro.pathling.terminology.validatecode.ValidateCodeExecutor;
import au.csiro.pathling.terminology.validatecode.ValidateCodeParameters;
import au.csiro.pathling.utilities.Preconditions;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.gclient.IOperationUntypedWithInput;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import java.io.Closeable;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.CacheControl;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.codesystems.ConceptSubsumptionOutcome;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;

public abstract class CachingTerminologyService
extends BaseTerminologyService {
    public static final String VALIDATE_CODE_CACHE_NAME = "validate-code";
    public static final String SUBSUMES_CACHE_NAME = "subsumes";
    public static final String TRANSLATE_CACHE_NAME = "translate";
    public static final String LOOKUP_CACHE_NAME = "lookup";
    public static final String ETAG_HEADER_NAME = "etag";
    public static final String IF_NONE_MATCH_HEADER_NAME = "if-none-match";
    public static final String CACHE_CONTROL_HEADER_NAME = "cache-control";
    @Nonnull
    protected final HttpClientCachingConfiguration configuration;
    @Nonnull
    protected final EmbeddedCacheManager cacheManager;
    @Nonnull
    protected final Cache<Integer, TerminologyResult<Boolean>> validateCodeCache;
    @Nonnull
    protected final Cache<Integer, TerminologyResult<ConceptSubsumptionOutcome>> subsumesCache;
    @Nonnull
    protected final Cache<Integer, TerminologyResult<ArrayList<TerminologyService.Translation>>> translateCache;
    @Nonnull
    protected final Cache<Integer, TerminologyResult<ArrayList<TerminologyService.PropertyOrDesignation>>> lookupCache;

    public CachingTerminologyService(@Nonnull TerminologyClient terminologyClient, @Nullable Closeable toClose, @Nonnull HttpClientCachingConfiguration configuration) {
        super(terminologyClient, toClose);
        this.configuration = configuration;
        this.cacheManager = this.buildCacheManager();
        this.validateCodeCache = this.buildCache(this.cacheManager, VALIDATE_CODE_CACHE_NAME);
        this.subsumesCache = this.buildCache(this.cacheManager, SUBSUMES_CACHE_NAME);
        this.translateCache = this.buildCache(this.cacheManager, TRANSLATE_CACHE_NAME);
        this.lookupCache = this.buildCache(this.cacheManager, LOOKUP_CACHE_NAME);
    }

    @Override
    public boolean validateCode(@Nonnull String valueSetUrl, @Nonnull Coding coding) {
        ValidateCodeParameters parameters = new ValidateCodeParameters(valueSetUrl, ImmutableCoding.of(coding));
        ValidateCodeExecutor executor = new ValidateCodeExecutor(this.terminologyClient, parameters);
        return this.getFromCache(this.validateCodeCache, parameters, executor);
    }

    @Override
    @Nonnull
    public List<TerminologyService.Translation> translate(@Nonnull Coding coding, @Nonnull String conceptMapUrl, boolean reverse, @Nullable String target) {
        TranslateParameters parameters = new TranslateParameters(ImmutableCoding.of(coding), conceptMapUrl, reverse, target);
        TranslateExecutor executor = new TranslateExecutor(this.terminologyClient, parameters);
        return this.getFromCache(this.translateCache, parameters, executor);
    }

    @Override
    @Nonnull
    public ConceptSubsumptionOutcome subsumes(@Nonnull Coding codingA, @Nonnull Coding codingB) {
        SubsumesParameters parameters = new SubsumesParameters(ImmutableCoding.of(codingA), ImmutableCoding.of(codingB));
        SubsumesExecutor executor = new SubsumesExecutor(this.terminologyClient, parameters);
        return this.getFromCache(this.subsumesCache, parameters, executor);
    }

    @Override
    @Nonnull
    public List<TerminologyService.PropertyOrDesignation> lookup(@Nonnull Coding coding, @Nullable String property) {
        LookupParameters parameters = new LookupParameters(ImmutableCoding.of(coding), property);
        LookupExecutor executor = new LookupExecutor(this.terminologyClient, parameters);
        return this.getFromCache(this.lookupCache, parameters, executor);
    }

    private <ParametersType extends TerminologyParameters, ResponseType, ResultType extends Serializable> ResultType getFromCache(@Nonnull Cache<Integer, TerminologyResult<ResultType>> cache, @Nonnull ParametersType parameters, @Nonnull TerminologyOperation<ResponseType, ResultType> operation) {
        int key = parameters.hashCode();
        TerminologyResult cached = (TerminologyResult)cache.get(key);
        if (cached == null) {
            TerminologyResult<ResultType> result = this.fetch(operation, Optional.empty());
            cache.put(key, result);
            return result.getData();
        }
        boolean expired = cached.getExpires() != null && System.currentTimeMillis() > cached.getExpires();
        return Objects.requireNonNull(cache.compute((Integer)key, (k, v) -> expired ? this.fetch(operation, Optional.ofNullable(v)) : v)).getData();
    }

    private <ResponseType, ResultType extends Serializable> TerminologyResult<ResultType> fetch(@Nonnull TerminologyOperation<ResponseType, ResultType> operation, @Nonnull Optional<TerminologyResult<ResultType>> cached) {
        Optional<ResultType> invalidResult = operation.validate();
        if (invalidResult.isPresent()) {
            return new TerminologyResult<Serializable>((Serializable)invalidResult.get(), null, null, false);
        }
        IOperationUntypedWithInput request = operation.buildRequest();
        cached.flatMap(c -> Optional.ofNullable(c.getETag())).ifPresent(eTag -> request.withAdditionalHeader(IF_NONE_MATCH_HEADER_NAME, (String)eTag));
        Optional<Long> defaultExpires = Optional.of(CachingTerminologyService.secondsFromNow(this.configuration.getDefaultExpiry()));
        Optional<Long> overrideExpires = Optional.ofNullable(this.configuration.getOverrideExpiry()).map(CachingTerminologyService::secondsFromNow);
        try {
            MethodOutcome outcome = (MethodOutcome)request.returnMethodOutcome().execute();
            Serializable result = (Serializable)operation.extractResult(outcome.getResource());
            Optional<String> newETag = CachingTerminologyService.getSingularHeader(outcome, ETAG_HEADER_NAME);
            Optional<Long> serverExpires = CachingTerminologyService.getExpires(outcome);
            return new TerminologyResult<Serializable>(result, newETag.orElse(null), CachingTerminologyService.resolveExpires(overrideExpires, serverExpires, defaultExpires), false);
        }
        catch (NotModifiedException e) {
            Optional<String> newETag = CachingTerminologyService.getSingularHeader(e.getResponseHeaders(), ETAG_HEADER_NAME);
            TerminologyResult<ResultType> previous = Preconditions.checkPresent(cached);
            Optional<Long> serverExpires = CachingTerminologyService.getExpires(e.getResponseHeaders());
            Optional<Long> previousExpiry = Optional.ofNullable(previous.getExpires());
            return new TerminologyResult<ResultType>(previous.getData(), newETag.orElse(previous.getETag()), CachingTerminologyService.resolveExpires(overrideExpires, serverExpires, previousExpiry, defaultExpires), false);
        }
        catch (BaseServerResponseException e) {
            Optional<Long> serverExpires = CachingTerminologyService.getExpires(e.getResponseHeaders());
            long expires = CachingTerminologyService.resolveExpires(serverExpires, defaultExpires);
            TerminologyResult<Serializable> fallback = new TerminologyResult<Serializable>((Serializable)operation.invalidRequestFallback(), null, expires, false);
            return CachingTerminologyService.handleError(e, fallback);
        }
    }

    protected abstract EmbeddedCacheManager buildCacheManager();

    protected abstract Cache<Integer, ?> buildCache(@Nonnull EmbeddedCacheManager var1, @Nonnull String var2);

    @Nonnull
    private static Optional<String> getSingularHeader(@Nonnull MethodOutcome outcome, @Nonnull String headerName) {
        return CachingTerminologyService.getSingularHeader(outcome.getResponseHeaders(), headerName);
    }

    @Nonnull
    private static Optional<String> getSingularHeader(@Nullable Map<String, List<String>> headers, @Nonnull String headerName) {
        return Optional.ofNullable(headers).map(rh -> (List)rh.get(headerName)).flatMap(h2 -> h2.stream().findFirst());
    }

    @Nonnull
    private static Optional<Long> getExpires(@Nonnull MethodOutcome outcome) {
        return CachingTerminologyService.getExpires(outcome.getResponseHeaders());
    }

    @Nonnull
    private static Optional<Long> getExpires(@Nullable Map<String, List<String>> headers) {
        Optional<Integer> maxAge = CachingTerminologyService.getSingularHeader(headers, CACHE_CONTROL_HEADER_NAME).map(CacheControl::valueOf).map(CacheControl::getMaxAge);
        return maxAge.map(CachingTerminologyService::secondsFromNow);
    }

    private static long secondsFromNow(int seconds) {
        return Instant.now().plusSeconds(seconds).toEpochMilli();
    }

    @SafeVarargs
    private static Long resolveExpires(Optional<Long> ... orderedExpiryValues) {
        return Arrays.stream(orderedExpiryValues).reduce((acc, v) -> acc.or(() -> v)).orElseThrow().orElseThrow();
    }
}

