/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.sql.Terminology;
import au.csiro.pathling.sql.TerminologySupport;
import au.csiro.pathling.terminology.TerminologyFunctions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

class TerminologyFunctionsImpl
implements TerminologyFunctions {
    TerminologyFunctionsImpl() {
    }

    @Override
    @Nonnull
    public Dataset<Row> memberOf(@Nonnull Column codingArrayCol, @Nonnull String valueSetUri, @Nonnull Dataset<Row> dataset, @Nonnull String outputColumnName) {
        return dataset.withColumn(outputColumnName, Terminology.member_of(codingArrayCol, valueSetUri));
    }

    @Override
    @Nonnull
    public Dataset<Row> translate(@Nonnull Column codingArrayCol, @Nonnull String conceptMapUrl, boolean reverse, @Nonnull String equivalencesCsv, @Nullable String target, @Nonnull Dataset<Row> dataset, @Nonnull String outputColumnName) {
        return dataset.withColumn(outputColumnName, Terminology.translate(codingArrayCol, conceptMapUrl, reverse, TerminologySupport.parseCsvEquivalences(equivalencesCsv), target));
    }

    @Override
    @Nonnull
    public Dataset<Row> subsumes(@Nonnull Dataset<Row> dataset, @Nonnull Column codingArrayA, @Nonnull Column codingArrayB, @Nonnull String outputColumnName, boolean inverted) {
        return dataset.withColumn(outputColumnName, inverted ? Terminology.subsumed_by(codingArrayA, codingArrayB) : Terminology.subsumes(codingArrayA, codingArrayB));
    }
}

