/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    private static final Logger log = LoggerFactory.getLogger(RequestRetryHandler.class);

    public RequestRetryHandler(@Nonnull int retryCount) {
        super(retryCount, true, List.of(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class, SocketException.class, HttpHostConnectException.class, ConnectTimeoutException.class, NoHttpResponseException.class));
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        log.debug("Problem issuing terminology request, retrying", exception);
        return super.retryRequest(exception, executionCount, context);
    }
}

