/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhir.TerminologyClient;
import au.csiro.pathling.terminology.TerminologyService;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseTerminologyService
implements TerminologyService,
Closeable {
    @Nonnull
    protected final TerminologyClient terminologyClient;
    @Nullable
    protected final Closeable toClose;

    public BaseTerminologyService(@Nonnull TerminologyClient terminologyClient, @Nullable Closeable toClose) {
        this.terminologyClient = terminologyClient;
        this.toClose = toClose;
    }

    @Nullable
    public static <ResultType> ResultType handleError(@Nonnull BaseServerResponseException e, @Nullable ResultType invalidInputReturnValue) {
        if (e.getStatusCode() / 100 == 4) {
            return invalidInputReturnValue;
        }
        throw e;
    }

    @Override
    public void close() throws IOException {
        if (Objects.nonNull(this.toClose)) {
            this.toClose.close();
        }
    }
}

