/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.sql.udf;

import au.csiro.pathling.errors.InvalidUserInputError;
import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import au.csiro.pathling.sql.udf.SqlFunction;
import au.csiro.pathling.sql.udf.SqlFunction5;
import au.csiro.pathling.sql.udf.TerminologyUdfHelpers;
import au.csiro.pathling.terminology.TerminologyService;
import au.csiro.pathling.terminology.TerminologyServiceFactory;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumerations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag;

public class TranslateUdf
implements SqlFunction,
SqlFunction5<Object, String, Boolean, WrappedArray<String>, String, Row[]> {
    private static final Logger log = LoggerFactory.getLogger(TranslateUdf.class);
    private static final long serialVersionUID = 7605853352299165569L;
    public static final Set<String> VALID_EQUIVALENCE_CODES = Stream.of(Enumerations.ConceptMapEquivalence.values()).map(Enumerations.ConceptMapEquivalence::toCode).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    public static final Set<String> DEFAULT_EQUIVALENCES = ImmutableSet.of(Enumerations.ConceptMapEquivalence.EQUIVALENT.toCode());
    public static final String FUNCTION_NAME = "translate_coding";
    public static final DataType RETURN_TYPE = DataTypes.createArrayType((DataType)CodingEncoding.DATA_TYPE);
    public static final boolean PARAM_REVERSE_DEFAULT = false;
    @Nonnull
    private final TerminologyServiceFactory terminologyServiceFactory;

    TranslateUdf(@Nonnull TerminologyServiceFactory terminologyServiceFactory) {
        this.terminologyServiceFactory = terminologyServiceFactory;
    }

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public DataType getReturnType() {
        return RETURN_TYPE;
    }

    @Nonnull
    public static String checkValidEquivalenceCode(@Nonnull String code) {
        if (!VALID_EQUIVALENCE_CODES.contains(code)) {
            throw new InvalidUserInputError(String.format("Unknown ConceptMapEquivalence code '%s'", code));
        }
        return code;
    }

    @Nullable
    protected Stream<Coding> doCall(@Nullable Stream<Coding> codings, @Nullable String conceptMapUri, @Nullable Boolean reverse, @Nullable String[] equivalences, @Nullable String target) {
        Set<String> includeEquivalences;
        if (codings == null || conceptMapUri == null) {
            return null;
        }
        boolean resolvedReverse = reverse != null ? reverse : false;
        Set<String> set = includeEquivalences = equivalences == null ? DEFAULT_EQUIVALENCES : this.toValidSetOfEquivalenceCodes(equivalences);
        if (includeEquivalences.isEmpty()) {
            return Stream.empty();
        }
        TerminologyService terminologyService = this.terminologyServiceFactory.build();
        return TerminologyUdfHelpers.validCodings(codings).flatMap(coding -> terminologyService.translate((Coding)coding, conceptMapUri, resolvedReverse, target).stream()).filter(entry -> includeEquivalences.contains(entry.getEquivalence().toCode())).map(TerminologyService.Translation::getConcept).map(ImmutableCoding::of).distinct().map(ImmutableCoding::toCoding);
    }

    @Nullable
    public Row[] call(@Nullable Object codingRowOrArray, @Nullable String conceptMapUri, @Nullable Boolean reverse, @Nullable WrappedArray<String> equivalences, @Nullable String target) {
        return TerminologyUdfHelpers.encodeMany(this.doCall(TerminologyUdfHelpers.decodeOneOrMany(codingRowOrArray), conceptMapUri, reverse, Objects.nonNull(equivalences) ? (String[])equivalences.toArray(ClassTag.apply(String.class)) : null, target));
    }

    @Nonnull
    private Set<String> toValidSetOfEquivalenceCodes(@Nonnull String[] equivalences) {
        return Stream.of(equivalences).filter(Objects::nonNull).filter(Predicate.not(String::isEmpty)).map(TranslateUdf::checkValidEquivalenceCode).collect(Collectors.toUnmodifiableSet());
    }
}

